/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.LayoutProvider;
import org.apache.myfaces.tobago.component.UILayout;
import org.apache.myfaces.tobago.component.UITreeListboxBox;
import org.apache.myfaces.tobago.component.UITreeOld;
import org.apache.myfaces.tobago.component.UITreeOldNode;
import org.apache.myfaces.tobago.config.ThemeConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UITreeListbox
extends UITreeOld
implements LayoutProvider {
    private static final Log LOG = LogFactory.getLog(UITreeListbox.class);
    public static final String COMPONENT_TYPE = "org.apache.myfaces.tobago.TreeListbox";
    public static final String BOXES_PREFIX = "boxes_";
    private List<UITreeOldNode> selectionPath = null;
    private List<UITreeOldNode> expandPath = null;
    private boolean encodingChildren = false;
    private List<UITreeListboxBox> boxes;

    protected String nodeStateId(FacesContext facesContext, UITreeOldNode node) {
        String clientId = node.getClientId(facesContext);
        int last = clientId.lastIndexOf(58) + 1;
        return clientId.substring(last);
    }

    @Override
    public void encodeBegin(FacesContext facesContext) throws IOException {
        UILayout.getLayout((UIComponent)this).layoutBegin(facesContext, (UIComponent)this);
        this.fixSelectionType();
        super.encodeBegin(facesContext);
        this.debugStates(facesContext);
        this.createUIBoxes(facesContext);
    }

    private void fixSelectionType() {
        Map attributes = this.getAttributes();
        Object selectable = attributes.get("selectable");
        if (!("single".equals(selectable) || "singleLeafOnly".equals(selectable) || "siblingLeafOnly".equals(selectable))) {
            if (selectable == null) {
                attributes.put("selectable", "single");
            } else {
                LOG.warn((Object)("Illegal attributeValue selectable : " + selectable + " set to 'single'"));
                attributes.put("selectable", "single");
            }
        }
    }

    private void debugStates(FacesContext facesContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"#####################################################");
            StringBuilder state = new StringBuilder("expandState : ;");
            for (DefaultMutableTreeNode defaultMutableTreeNode : this.getState().getExpandState()) {
                state.append(this.nodeStateId(facesContext, this.findUITreeNode(this.getRoot(), defaultMutableTreeNode)));
                state.append(";");
            }
            LOG.debug((Object)state);
            state = new StringBuilder("selectState : ;");
            for (DefaultMutableTreeNode defaultMutableTreeNode : this.getState().getSelection()) {
                state.append(this.nodeStateId(facesContext, this.findUITreeNode(this.getRoot(), defaultMutableTreeNode)));
                state.append(";");
            }
            LOG.debug((Object)state);
            state = new StringBuilder("selectionPath : ;");
            for (UITreeOldNode uITreeOldNode : this.getSelectionPath()) {
                state.append(this.nodeStateId(facesContext, uITreeOldNode));
                state.append(";");
            }
            LOG.debug((Object)state);
            state = new StringBuilder("expandPath : ;");
            for (UITreeOldNode uITreeOldNode : this.getExpandPath()) {
                state.append(this.nodeStateId(facesContext, uITreeOldNode));
                state.append(";");
            }
            LOG.debug((Object)state);
            LOG.debug((Object)"");
        }
    }

    public void createSelectionPath() {
        TreeNode treeNode;
        Iterator<DefaultMutableTreeNode> iterator;
        this.selectionPath = new ArrayList<UITreeOldNode>();
        this.expandPath = new ArrayList<UITreeOldNode>();
        if (this.isSelectableTree() && (iterator = this.getState().getSelection().iterator()).hasNext()) {
            treeNode = iterator.next();
            UITreeOldNode selectedNode = this.findUITreeNode(this.getRoot(), treeNode);
            if (selectedNode != null) {
                for (UITreeOldNode ancestor = selectedNode; ancestor != null && ancestor instanceof UITreeOldNode; ancestor = ancestor.getParent()) {
                    this.selectionPath.add(0, ancestor);
                }
            }
        }
        Set<DefaultMutableTreeNode> expandState = this.getState().getExpandState();
        if (this.selectionPath.isEmpty()) {
            treeNode = this.getRoot().getTreeNode();
            this.createExpandPath((DefaultMutableTreeNode)treeNode, expandState);
            this.selectionPath.addAll(this.expandPath);
        } else {
            for (UITreeOldNode node : this.selectionPath) {
                if (node.getTreeNode().isLeaf()) continue;
                this.expandPath.add(node);
            }
        }
        if (this.expandPath.isEmpty()) {
            this.expandPath.add(this.getRoot());
        }
        expandState.clear();
        for (UITreeOldNode uiTreeNode : this.expandPath) {
            expandState.add((DefaultMutableTreeNode)uiTreeNode.getValue());
        }
    }

    private boolean createExpandPath(DefaultMutableTreeNode node, Set<DefaultMutableTreeNode> expandState) {
        if (expandState.contains(node)) {
            this.expandPath.add(this.findUITreeNode(this.getRoot(), node));
            for (int i = 0; i < node.getChildCount() && !this.createExpandPath((DefaultMutableTreeNode)node.getChildAt(i), expandState); ++i) {
            }
            return true;
        }
        return false;
    }

    private void createUIBoxes(FacesContext facesContext) {
        int depth = this.getRoot().getTreeNode().getDepth();
        this.boxes = new ArrayList<UITreeListboxBox>(depth);
        for (int i = 0; i < depth; ++i) {
            UITreeListboxBox box = (UITreeListboxBox)ComponentUtil.createComponent(facesContext, "org.apache.myfaces.tobago.TreeListboxBox", "TreeListboxBox");
            this.getFacets().put(BOXES_PREFIX + i, box);
            box.setLevel(i);
            box.setNodes(this.getNodes(i));
            this.boxes.add(box);
        }
    }

    private List<UITreeOldNode> getNodes(int level) {
        List children = level == 0 ? this.getRoot().getChildren() : (this.selectionPath.size() > level ? this.selectionPath.get(level).getChildren() : Collections.EMPTY_LIST);
        ArrayList<UITreeOldNode> nodes = new ArrayList<UITreeOldNode>(children.size());
        for (Object node : children) {
            if (!(node instanceof UITreeOldNode)) continue;
            nodes.add((UITreeOldNode)((Object)node));
        }
        return nodes;
    }

    @Override
    public void encodeChildren(FacesContext facesContext) throws IOException {
        if (this.isRendered()) {
            this.encodingChildren = true;
            UILayout.getLayout((UIComponent)this).encodeChildrenOfComponent(facesContext, (UIComponent)this);
            this.encodingChildren = false;
        }
    }

    public void encodeEnd(FacesContext facesContext) throws IOException {
        super.encodeEnd(facesContext);
    }

    public int getChildCount() {
        if (this.encodingChildren) {
            return this.boxes != null ? this.boxes.size() : 0;
        }
        return super.getChildCount();
    }

    public List getChildren() {
        if (this.encodingChildren) {
            return this.boxes;
        }
        return super.getChildren();
    }

    public UITreeOldNode getSelectedNode(int level) {
        UITreeOldNode selectedComponent = null;
        if (this.selectionPath.size() > level + 1) {
            selectedComponent = this.selectionPath.get(level + 1);
        }
        return selectedComponent;
    }

    public List<UITreeOldNode> getSelectionPath() {
        return this.selectionPath;
    }

    public List<UITreeOldNode> getExpandPath() {
        return this.expandPath;
    }

    public boolean isSelectedNode(DefaultMutableTreeNode treeNode) {
        return this.getState().getSelection().contains(treeNode);
    }

    @Override
    public UILayout provideLayout() {
        UILayout layout = (UILayout)this.getFacet("layoutDefault");
        if (layout == null) {
            layout = (UILayout)ComponentUtil.createComponent("org.apache.myfaces.tobago.GridLayout", "GridLayout", null);
            int depth = ((DefaultMutableTreeNode)this.getValue()).getDepth();
            int defaultColumnCount = ThemeConfig.getValue(FacesContext.getCurrentInstance(), (UIComponent)this, "defaultColumnCount");
            if (defaultColumnCount < depth) {
                depth = defaultColumnCount;
            }
            StringBuilder columns = new StringBuilder("1*");
            for (int i = 1; i < depth; ++i) {
                columns.append(";1*");
            }
            layout.getAttributes().put("columns", columns.toString());
            this.getFacets().put("layoutDefault", layout);
        }
        return layout;
    }
}

