/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.collections.KeyValue;
import org.apache.commons.collections.list.SetUniqueList;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UIForm;
import org.apache.myfaces.tobago.component.UILayout;
import org.apache.myfaces.tobago.component.UIPanel;
import org.apache.myfaces.tobago.component.UIPopup;
import org.apache.myfaces.tobago.layout.Box;
import org.apache.myfaces.tobago.model.PageState;
import org.apache.myfaces.tobago.model.PageStateImpl;
import org.apache.myfaces.tobago.webapp.TobagoMultipartFormdataRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIPage
extends UIForm {
    private static final Log LOG = LogFactory.getLog(UIPage.class);
    public static final String COMPONENT_TYPE = "org.apache.myfaces.tobago.Page";
    public static final String ENCTYPE_KEY = UIPanel.class.getName() + ".enctype";
    public static final String DEFAULT_STYLE = "style/style.css";
    private static final int DEFAULT_WIDTH = 1024;
    private static final int DEFAULT_HEIGHT = 768;
    private String formId;
    private String focusId;
    private String actionId;
    private Box actionPosition;
    private String defaultActionId;
    private List<KeyValue> postfields;
    private SetUniqueList scriptFiles = SetUniqueList.decorate(new ArrayList());
    private Set<String> scriptBlocks = new ListOrderedSet();
    private Set<String> styleFiles = new ListOrderedSet();
    private Set<String> styleBlocks;
    private Set<String> onloadScripts;
    private Set<String> onunloadScripts;
    private Set<String> onexitScripts;
    private Set<String> onsubmitScripts;
    private Set<UIPopup> popups;
    private Integer width;
    private Integer height;
    private String applicationIcon;

    public UIPage() {
        this.styleFiles.add(DEFAULT_STYLE);
        this.styleBlocks = new ListOrderedSet();
        this.onloadScripts = new ListOrderedSet();
        this.onunloadScripts = new ListOrderedSet();
        this.onexitScripts = new ListOrderedSet();
        this.onsubmitScripts = new ListOrderedSet();
        this.popups = new ListOrderedSet();
    }

    public void encodeBegin(FacesContext facesContext) throws IOException {
        UILayout.getLayout((UIComponent)this).layoutBegin(facesContext, (UIComponent)this);
        super.encodeBegin(facesContext);
    }

    public void encodeChildren(FacesContext context) throws IOException {
    }

    public String getFormId(FacesContext facesContext) {
        if (this.formId == null) {
            this.formId = this.getClientId(facesContext) + "::" + "form";
        }
        return this.formId;
    }

    @Override
    public void processDecodes(FacesContext facesContext) {
        this.checkTobagoRequest(facesContext);
        this.decode(facesContext);
        this.clearScriptsAndPopups();
        this.markSubmittedForm(facesContext);
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            kid.processDecodes(facesContext);
        }
    }

    public void markSubmittedForm(FacesContext facesContext) {
        this.setSubmitted(false);
        String currentActionId = this.getActionId();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("actionId = '" + currentActionId + "'"));
        }
        UIComponent command = null;
        try {
            command = this.findComponent(currentActionId);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (command == null && currentActionId != null && currentActionId.matches(".*:\\d+:.*")) {
            currentActionId = currentActionId.replaceAll(":\\d+:", ":");
            try {
                command = this.findComponent(currentActionId);
                LOG.info((Object)("command = \"" + command + "\""), (Throwable)new Exception());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)currentActionId);
            LOG.trace((Object)command);
            LOG.trace((Object)ComponentUtil.toString((UIComponent)facesContext.getViewRoot(), 0));
        }
        if (command != null) {
            UIForm form = ComponentUtil.findForm(command);
            form.setSubmitted(true);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)form);
                LOG.trace((Object)form.getClientId(facesContext));
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Illegal actionId! Rerender the view.");
            }
            facesContext.renderResponse();
        }
    }

    private void clearScriptsAndPopups() {
        this.getOnloadScripts().clear();
        this.getOnunloadScripts().clear();
        this.getOnexitScripts().clear();
        this.getScriptBlocks().clear();
        this.getPopups().clear();
    }

    private void checkTobagoRequest(FacesContext facesContext) {
        String contentType = (String)facesContext.getExternalContext().getRequestHeaderMap().get("content-type");
        if (contentType != null && contentType.startsWith("multipart/form-data")) {
            ServletRequest wrappedRequest;
            Object request = facesContext.getExternalContext().getRequest();
            boolean okay = false;
            if (request instanceof TobagoMultipartFormdataRequest) {
                okay = true;
            } else if (request instanceof HttpServletRequestWrapper && (wrappedRequest = ((HttpServletRequestWrapper)request).getRequest()) instanceof TobagoMultipartFormdataRequest) {
                okay = true;
            }
            if (!okay) {
                LOG.error((Object)"Can't process multipart/form-data without TobagoRequest. Please check the web.xml and define a TobagoMultipartFormdataFilter. See documentation for <tc:file>");
                facesContext.addMessage(null, new FacesMessage("An error has occured!"));
            }
        }
    }

    public List<KeyValue> getPostfields() {
        if (this.postfields == null) {
            this.postfields = new ArrayList<KeyValue>();
        }
        return this.postfields;
    }

    @Override
    public void processUpdates(FacesContext context) {
        super.processUpdates(context);
    }

    public PageState getPageState(FacesContext facesContext) {
        ValueBinding stateBinding = this.getValueBinding("state");
        if (stateBinding != null) {
            PageState state = (PageState)stateBinding.getValue(facesContext);
            if (state == null) {
                state = new PageStateImpl();
                stateBinding.setValue(facesContext, (Object)state);
            }
            return state;
        }
        return null;
    }

    public String getFocusId() {
        if (this.focusId != null) {
            return this.focusId;
        }
        ValueBinding vb = this.getValueBinding("focusId");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext());
        }
        return null;
    }

    public void setFocusId(String focusId) {
        this.focusId = focusId;
    }

    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public Box getActionPosition() {
        return this.actionPosition;
    }

    public void setActionPosition(Box actionPosition) {
        this.actionPosition = actionPosition;
    }

    public String getDefaultActionId() {
        return this.defaultActionId;
    }

    public void setDefaultActionId(String defaultActionId) {
        this.defaultActionId = defaultActionId;
    }

    public List<String> getScriptFiles() {
        return this.scriptFiles;
    }

    public Set<String> getScriptBlocks() {
        return this.scriptBlocks;
    }

    public Set<String> getStyleFiles() {
        return this.styleFiles;
    }

    public Set<String> getStyleBlocks() {
        return this.styleBlocks;
    }

    public Set<String> getOnloadScripts() {
        return this.onloadScripts;
    }

    public Set<String> getOnunloadScripts() {
        return this.onunloadScripts;
    }

    public Set<String> getOnexitScripts() {
        return this.onexitScripts;
    }

    public Set<String> getOnsubmitScripts() {
        return this.onsubmitScripts;
    }

    public Set<UIPopup> getPopups() {
        return this.popups;
    }

    public Integer getWidth() {
        if (this.width != null) {
            return this.width;
        }
        ValueBinding vb = this.getValueBinding("width");
        if (vb != null) {
            return (Integer)vb.getValue(this.getFacesContext());
        }
        Integer requestWidth = (Integer)FacesContext.getCurrentInstance().getExternalContext().getRequestMap().get("tobago-page-clientDimension-width");
        if (requestWidth != null) {
            return requestWidth;
        }
        return 1024;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        if (this.height != null) {
            return this.height;
        }
        ValueBinding vb = this.getValueBinding("height");
        if (vb != null) {
            return (Integer)vb.getValue(this.getFacesContext());
        }
        Integer requestHeight = (Integer)FacesContext.getCurrentInstance().getExternalContext().getRequestMap().get("tobago-page-clientDimension-height");
        if (requestHeight != null) {
            return requestHeight;
        }
        return 768;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public String getApplicationIcon() {
        if (this.applicationIcon != null) {
            return this.applicationIcon;
        }
        ValueBinding vb = this.getValueBinding("applicationIcon");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext());
        }
        return null;
    }

    public void setApplicationIcon(String applicationIcon) {
        this.applicationIcon = applicationIcon;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.width = (Integer)values[1];
        this.height = (Integer)values[2];
        this.focusId = (String)values[3];
        this.applicationIcon = (String)values[4];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.width, this.height, this.focusId, this.applicationIcon};
        return values;
    }
}

