/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.commons.collections.iterators.SingletonIterator;
import org.apache.myfaces.tobago.util.Deprecation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIMessages
extends javax.faces.component.UIMessages {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.tobago.Messages";
    private FacesMessage.Severity minSeverity;
    private FacesMessage.Severity maxSeverity;
    private Integer maxNumber;
    private OrderBy orderBy;
    private String forValue;
    private Boolean confirmation;

    public List<Item> createMessageList(FacesContext facesContext) {
        List<Item> messages = this.createMessageListInternal(facesContext);
        if (OrderBy.SEVERITY.equals((Object)this.orderBy)) {
            Collections.sort(messages, new ItemComparator());
        }
        return messages;
    }

    public int getMessageListCount(FacesContext facesContext) {
        return this.createMessageListInternal(facesContext).size();
    }

    private List<Item> createMessageListInternal(FacesContext facesContext) {
        Object clientIds = this.isGlobalOnly() ? new SingletonIterator(null) : (this.getFor() != null ? new SingletonIterator((Object)this.getFor()) : facesContext.getClientIdsWithMessages());
        return this.collectMessageList(facesContext, (Iterator)clientIds);
    }

    private List<Item> collectMessageList(FacesContext facesContext, Iterator clientIds) {
        ArrayList<Item> messages = new ArrayList<Item>();
        while (clientIds.hasNext()) {
            String clientId = (String)clientIds.next();
            Iterator i = facesContext.getMessages(clientId);
            while (i.hasNext()) {
                FacesMessage facesMessage = (FacesMessage)i.next();
                if (this.maxNumber != null && messages.size() >= this.maxNumber) {
                    return messages;
                }
                if (facesMessage.getSeverity().getOrdinal() < this.getMinSeverity().getOrdinal() || facesMessage.getSeverity().getOrdinal() > this.getMaxSeverity().getOrdinal()) continue;
                messages.add(new Item(clientId, facesMessage));
            }
        }
        return messages;
    }

    public FacesMessage.Severity getMinSeverity() {
        if (this.minSeverity != null) {
            return this.minSeverity;
        }
        ValueBinding vb = this.getValueBinding("minSeverity");
        if (vb != null) {
            return (FacesMessage.Severity)vb.getValue(this.getFacesContext());
        }
        return FacesMessage.SEVERITY_INFO;
    }

    public void setMinSeverity(FacesMessage.Severity minSeverity) {
        this.minSeverity = minSeverity;
    }

    public FacesMessage.Severity getMaxSeverity() {
        if (this.maxSeverity != null) {
            return this.maxSeverity;
        }
        ValueBinding vb = this.getValueBinding("maxSeverity");
        if (vb != null) {
            return (FacesMessage.Severity)vb.getValue(this.getFacesContext());
        }
        return FacesMessage.SEVERITY_FATAL;
    }

    public void setMaxSeverity(FacesMessage.Severity maxSeverity) {
        this.maxSeverity = maxSeverity;
    }

    public Integer getMaxNumber() {
        Number number;
        if (this.maxNumber != null) {
            return this.maxNumber;
        }
        ValueBinding vb = this.getValueBinding("maxNumber");
        if (vb != null && (number = (Number)vb.getValue(this.getFacesContext())) != null) {
            return number.intValue();
        }
        return null;
    }

    public void setMaxNumber(Integer maxNumber) {
        this.maxNumber = maxNumber;
    }

    public OrderBy getOrderBy() {
        if (this.orderBy != null) {
            return this.orderBy;
        }
        ValueBinding vb = this.getValueBinding("orderBy");
        if (vb != null) {
            return (OrderBy)((Object)vb.getValue(this.getFacesContext()));
        }
        return OrderBy.OCCURENCE;
    }

    public void setOrderBy(OrderBy orderBy) {
        this.orderBy = orderBy;
    }

    public void setFor(String forValue) {
        this.forValue = forValue;
    }

    public String getFor() {
        if (this.forValue != null) {
            return this.forValue;
        }
        ValueBinding vb = this.getValueBinding("for");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext());
        }
        return null;
    }

    public boolean isConfirmation() {
        if (this.confirmation != null) {
            return this.confirmation;
        }
        ValueBinding vb = this.getValueBinding("confirmation");
        if (vb != null) {
            return Boolean.TRUE.equals(vb.getValue(this.getFacesContext()));
        }
        return false;
    }

    public void setConfirmation(boolean confirmation) {
        this.confirmation = confirmation;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.minSeverity, this.maxSeverity, this.maxNumber, this.orderBy, this.forValue, this.confirmation};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.minSeverity = (FacesMessage.Severity)values[1];
        this.maxSeverity = (FacesMessage.Severity)values[2];
        this.maxNumber = (Integer)values[3];
        this.orderBy = (OrderBy)((Object)values[4]);
        this.forValue = (String)values[5];
        this.confirmation = (Boolean)values[6];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OrderBy {
        OCCURENCE,
        SEVERITY;

        public static final String OCCURENCE_STRING = "occurence";
        public static final String OCCURRENCE_STRING = "occurrence";
        public static final String SEVERITY_STRING = "severity";

        public static OrderBy parse(String key) {
            if (OCCURENCE_STRING.equals(key)) {
                Deprecation.LOG.warn((Object)"Please use 'occurrence' instead of 'occurence'");
            }
            if (OCCURRENCE_STRING.equals(key)) {
                key = OCCURENCE_STRING;
            }
            return OrderBy.valueOf(key.toUpperCase());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ItemComparator
    implements Comparator<Item> {
        @Override
        public int compare(Item item1, Item item2) {
            return item2.getFacesMessage().getSeverity().getOrdinal() - item1.getFacesMessage().getSeverity().getOrdinal();
        }
    }

    public static class Item {
        private String clientId;
        private FacesMessage facesMessage;

        public Item(String clientId, FacesMessage facesMessage) {
            this.clientId = clientId;
            this.facesMessage = facesMessage;
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public FacesMessage getFacesMessage() {
            return this.facesMessage;
        }

        public void setFacesMessage(FacesMessage facesMessage) {
            this.facesMessage = facesMessage;
        }
    }
}

