/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.LayoutProvider;
import org.apache.myfaces.tobago.component.UIDefaultLayout;
import org.apache.myfaces.tobago.renderkit.LayoutRenderer;
import org.apache.myfaces.tobago.util.LayoutUtil;

public abstract class UILayout
extends UIComponentBase {
    private static final Log LOG = LogFactory.getLog(UILayout.class);

    public void layoutBegin(FacesContext facesContext, UIComponent component) {
        UILayout.prepareDimension(facesContext, component);
    }

    public static void prepareDimension(FacesContext facesContext, UIComponent component) {
        UILayout.setInnerWidth(facesContext, component);
        UILayout.setInnerHeight(facesContext, component);
    }

    private static void setInnerWidth(FacesContext facesContext, UIComponent component) {
        Integer layoutWidth = LayoutUtil.getLayoutWidth(component);
        if (layoutWidth != null) {
            int space = layoutWidth;
            int innerSpace = LayoutUtil.getInnerSpace(facesContext, component, space, true);
            component.getAttributes().put("innerWidth", innerSpace);
        }
    }

    private static void setInnerHeight(FacesContext facesContext, UIComponent component) {
        Integer layoutHeight = LayoutUtil.getLayoutHeight(component);
        if (layoutHeight != null) {
            int space = layoutHeight;
            int innerSpace = LayoutUtil.getInnerSpace(facesContext, component, space, false);
            component.getAttributes().put("innerHeight", innerSpace);
        }
    }

    public void encodeChildrenOfComponent(FacesContext facesContext, UIComponent component) throws IOException {
        ((LayoutRenderer)this.getRenderer(facesContext)).encodeChildrenOfComponent(facesContext, component);
    }

    public static UILayout getLayout(UIComponent component) {
        UILayout layout = (UILayout)component.getFacet("layout");
        if (layout == null) {
            layout = component instanceof LayoutProvider ? ((LayoutProvider)component).provideLayout() : UIDefaultLayout.getInstance();
        }
        return layout;
    }
}

