/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.commons.fileupload.FileItem;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.util.MessageFactory;

public class UIFileInput
extends UIInput {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.tobago.FileInput";
    private Integer tabIndex;

    public void setParent(UIComponent uiComponent) {
        super.setParent(uiComponent);
        UIPage form = ComponentUtil.findPage(this.getFacesContext(), uiComponent);
        if (form != null) {
            form.getAttributes().put("enctype", "multipart/form-data");
        } else {
            FacesContext.getCurrentInstance().getExternalContext().getRequestMap().put(UIPage.ENCTYPE_KEY, "multipart/form-data");
        }
    }

    public void validate(FacesContext facesContext) {
        if (this.isRequired()) {
            if (this.getSubmittedValue() instanceof FileItem) {
                FileItem file = (FileItem)this.getSubmittedValue();
                if (file == null || file.getName().length() == 0) {
                    this.addErrorMessage(facesContext);
                    this.setValid(false);
                }
            } else {
                this.addErrorMessage(facesContext);
                this.setValid(false);
            }
        }
        super.validate(facesContext);
    }

    private void addErrorMessage(FacesContext facesContext) {
        FacesMessage facesMessage = MessageFactory.createFacesMessage(facesContext, "javax.faces.component.UIInput.REQUIRED", FacesMessage.SEVERITY_ERROR);
        facesContext.addMessage(this.getClientId(facesContext), facesMessage);
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.tabIndex = (Integer)values[1];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.tabIndex};
        return values;
    }

    public Integer getTabIndex() {
        Number number;
        if (this.tabIndex != null) {
            return this.tabIndex;
        }
        ValueBinding vb = this.getValueBinding("tabIndex");
        if (vb != null && (number = (Number)vb.getValue(this.getFacesContext())) != null) {
            return number.intValue();
        }
        return null;
    }

    public void setTabIndex(Integer tabIndex) {
        this.tabIndex = tabIndex;
    }
}

