/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.component.UIOutput;
import javax.faces.component.UIParameter;
import javax.faces.component.UISelectItems;
import javax.faces.component.UISelectOne;
import javax.faces.component.UIViewRoot;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.PhaseId;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.jsp.JspException;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.SupportsMarkup;
import org.apache.myfaces.tobago.component.UIColumn;
import org.apache.myfaces.tobago.component.UICommand;
import org.apache.myfaces.tobago.component.UIData;
import org.apache.myfaces.tobago.component.UIForm;
import org.apache.myfaces.tobago.component.UIInput;
import org.apache.myfaces.tobago.component.UIMenuSelectOne;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.component.UIPopup;
import org.apache.myfaces.tobago.component.UISelectItem;
import org.apache.myfaces.tobago.component.UISelectMany;
import org.apache.myfaces.tobago.context.TransientStateHolder;
import org.apache.myfaces.tobago.el.ConstantMethodBinding;
import org.apache.myfaces.tobago.event.PopupActionListener;
import org.apache.myfaces.tobago.event.SheetStateChangeEvent;
import org.apache.myfaces.tobago.renderkit.LayoutableRendererBase;
import org.apache.myfaces.tobago.renderkit.html.StyleClasses;
import org.apache.myfaces.tobago.util.Callback;
import org.apache.myfaces.tobago.util.RangeParser;
import org.apache.myfaces.tobago.util.TobagoCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentUtil {
    private static final Log LOG = LogFactory.getLog(ComponentUtil.class);
    private static final String RENDER_KEY_PREFIX = "org.apache.myfaces.tobago.component.ComponentUtil.RendererKeyPrefix_";
    public static final Class[] ACTION_ARGS = new Class[0];
    public static final Class[] ACTION_LISTENER_ARGS = new Class[]{ActionEvent.class};
    public static final Class[] VALUE_CHANGE_LISTENER_ARGS = new Class[]{ValueChangeEvent.class};
    public static final Class[] VALIDATOR_ARGS = new Class[]{FacesContext.class, UIComponent.class, Object.class};

    private ComponentUtil() {
    }

    public static boolean hasErrorMessages(FacesContext context) {
        Iterator iter = context.getMessages();
        while (iter.hasNext()) {
            FacesMessage message = (FacesMessage)iter.next();
            if (FacesMessage.SEVERITY_ERROR.compareTo((Object)message.getSeverity()) > 0) continue;
            return true;
        }
        return false;
    }

    public static boolean containsPopupActionListener(javax.faces.component.UICommand command) {
        ActionListener[] actionListeners;
        for (ActionListener actionListener : actionListeners = command.getActionListeners()) {
            if (!(actionListener instanceof PopupActionListener)) continue;
            return true;
        }
        return false;
    }

    public static String getFacesMessageAsString(FacesContext facesContext, UIComponent component) {
        Iterator messages = facesContext.getMessages(component.getClientId(facesContext));
        StringBuilder stringBuffer = new StringBuilder();
        while (messages.hasNext()) {
            FacesMessage message = (FacesMessage)messages.next();
            stringBuffer.append(message.getDetail());
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        return null;
    }

    public static boolean isInPopup(UIComponent component) {
        while (component != null) {
            if (component instanceof UIPopup) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    public static void resetPage(FacesContext context) {
        UIViewRoot view = context.getViewRoot();
        if (view != null) {
            view.getAttributes().remove("org.apache.myfaces.tobago.Page");
        }
    }

    public static UIPage findPage(FacesContext context, UIComponent component) {
        UIViewRoot view = context.getViewRoot();
        if (view != null) {
            TransientStateHolder stateHolder = (TransientStateHolder)view.getAttributes().get("org.apache.myfaces.tobago.Page");
            if (stateHolder == null || stateHolder.isEmpty()) {
                UIPage page = ComponentUtil.findPage(component);
                stateHolder = new TransientStateHolder((Object)page);
                context.getViewRoot().getAttributes().put("org.apache.myfaces.tobago.Page", stateHolder);
            }
            return (UIPage)((Object)stateHolder.get());
        }
        return ComponentUtil.findPage(component);
    }

    public static UIPage findPage(UIComponent component) {
        while (component != null) {
            if (component instanceof UIPage) {
                return (UIPage)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static void addStyles(UIComponent component, String[] styles) {
        UIPage uiPage = ComponentUtil.findPage(component);
        uiPage.getStyleFiles().addAll(Arrays.asList(styles));
    }

    public static void addScripts(UIComponent component, String[] scripts) {
        UIPage uiPage = ComponentUtil.findPage(component);
        uiPage.getScriptFiles().addAll(Arrays.asList(scripts));
    }

    public static void addOnloadCommands(UIComponent component, String[] cmds) {
        UIPage uiPage = ComponentUtil.findPage(component);
        uiPage.getOnloadScripts().addAll(Arrays.asList(cmds));
    }

    public static UIPage findPage(FacesContext facesContext) {
        return ComponentUtil.findPageBreadthFirst((UIComponent)facesContext.getViewRoot());
    }

    private static UIPage findPageBreadthFirst(UIComponent component) {
        UIComponent child;
        for (Object o : component.getChildren()) {
            child = (UIComponent)o;
            if (!(child instanceof UIPage)) continue;
            return (UIPage)child;
        }
        for (Object o : component.getChildren()) {
            child = (UIComponent)o;
            UIPage result = ComponentUtil.findPageBreadthFirst(child);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static UIForm findForm(UIComponent component) {
        while (component != null) {
            if (component instanceof UIForm) {
                return (UIForm)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static List<UIForm> findSubForms(UIComponent component) {
        ArrayList<UIForm> collect = new ArrayList<UIForm>();
        ComponentUtil.findSubForms(collect, component);
        return collect;
    }

    private static void findSubForms(List<UIForm> collect, UIComponent component) {
        Iterator kids = component.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent child = (UIComponent)kids.next();
            if (child instanceof UIForm) {
                collect.add((UIForm)child);
                continue;
            }
            ComponentUtil.findSubForms(collect, child);
        }
    }

    public static <T extends UIComponent> T findDescendant(UIComponent component, Class<T> type) {
        for (UIComponent child : component.getChildren()) {
            if (child.getClass().equals(type)) {
                return (T)child;
            }
            T descendant = ComponentUtil.findDescendant(child, type);
            if (descendant == null) continue;
            return descendant;
        }
        return null;
    }

    public static String findClientIdFor(UIComponent component, FacesContext facesContext) {
        UIComponent forComponent = ComponentUtil.findFor(component);
        if (forComponent != null) {
            String clientId = forComponent.getClientId(facesContext);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("found clientId: '" + clientId + "'"));
            }
            return clientId;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"found no clientId");
        }
        return null;
    }

    public static UIComponent findFor(UIComponent component) {
        String forValue = (String)component.getAttributes().get("for");
        if (forValue == null) {
            return component.getParent();
        }
        return component.findComponent(forValue);
    }

    public static boolean isInActiveForm(UIComponent component) {
        while (component != null) {
            UIForm form;
            if (component instanceof UIForm && (form = (UIForm)component).isSubmitted()) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    public static FacesMessage.Severity getMaximumSeverity(UIComponent component) {
        boolean invalid = component instanceof javax.faces.component.UIInput && !((javax.faces.component.UIInput)component).isValid();
        FacesMessage.Severity max = invalid ? FacesMessage.SEVERITY_ERROR : null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Iterator messages = facesContext.getMessages(component.getClientId(facesContext));
        while (messages.hasNext()) {
            FacesMessage message = (FacesMessage)messages.next();
            if (max != null && message.getSeverity().getOrdinal() <= max.getOrdinal()) continue;
            max = message.getSeverity();
        }
        return max;
    }

    public static boolean isError(javax.faces.component.UIInput uiInput) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return !uiInput.isValid() || facesContext.getMessages(uiInput.getClientId(facesContext)).hasNext();
    }

    public static boolean isError(UIComponent component) {
        if (component instanceof UIInput) {
            return ComponentUtil.isError((UIInput)component);
        }
        return false;
    }

    public static boolean isOutputOnly(UIComponent component) {
        return ComponentUtil.getBooleanAttribute(component, "disabled") || ComponentUtil.getBooleanAttribute(component, "readonly");
    }

    public static boolean mayValidate(UIComponent component) {
        return !ComponentUtil.isOutputOnly(component) && ComponentUtil.isInActiveForm(component);
    }

    public static boolean mayUpdateModel(UIComponent component) {
        return ComponentUtil.mayValidate(component);
    }

    public static boolean getBooleanAttribute(UIComponent component, String name) {
        Object bool = component.getAttributes().get(name);
        if (bool == null) {
            return false;
        }
        if (bool instanceof ValueBinding) {
            bool = ((ValueBinding)bool).getValue(FacesContext.getCurrentInstance());
        }
        if (bool instanceof Boolean) {
            return (Boolean)bool;
        }
        if (bool instanceof String) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Searching for a boolean, but find a String. Should not happen. attribute: '" + name + "' id: '" + component.getClientId(FacesContext.getCurrentInstance()) + "' comp: '" + component + "'"));
            }
            return Boolean.valueOf((String)bool);
        }
        LOG.warn((Object)("Unknown type '" + bool.getClass().getName() + "' for boolean attribute: " + name + " id: " + component.getClientId(FacesContext.getCurrentInstance()) + " comp: " + component));
        return false;
    }

    public static void setRenderedPartially(UICommand command, String renderers) {
        if (renderers != null) {
            if (UIComponentTag.isValueReference((String)renderers)) {
                command.setValueBinding("renderedPartially", ComponentUtil.createValueBinding(renderers));
            } else {
                String[] components = StringUtils.split((String)renderers, (String)",");
                command.setRenderedPartially(components);
            }
        }
    }

    public static void setStyleClasses(UIComponent component, String styleClasses) {
        if (styleClasses != null) {
            if (UIComponentTag.isValueReference((String)styleClasses)) {
                component.setValueBinding("styleClass", ComponentUtil.createValueBinding(styleClasses));
            } else {
                String[] classes = StringUtils.split((String)styleClasses, (String)", ");
                if (classes.length > 0) {
                    StyleClasses styles = StyleClasses.ensureStyleClasses(component);
                    for (String clazz : classes) {
                        styles.addFullQualifiedClass(clazz);
                    }
                }
            }
        }
    }

    public static void setMarkup(UIComponent markupComponent, String markup) {
        if (markup != null) {
            if (markupComponent instanceof SupportsMarkup) {
                if (UIComponentTag.isValueReference((String)markup)) {
                    markupComponent.setValueBinding("markup", ComponentUtil.createValueBinding(markup));
                } else {
                    String[] markups = StringUtils.split((String)markup, (String)",");
                    ((SupportsMarkup)markupComponent).setMarkup(markups);
                }
            } else {
                LOG.error((Object)("Component did not support Markup " + markupComponent.getClass().getName()));
            }
        }
    }

    public static Object getAttribute(UIComponent component, String name) {
        Object value = component.getAttributes().get(name);
        if (value instanceof ValueBinding) {
            value = ((ValueBinding)value).getValue(FacesContext.getCurrentInstance());
        }
        return value;
    }

    public static String getStringAttribute(UIComponent component, String name) {
        return (String)ComponentUtil.getAttribute(component, name);
    }

    public static int getIntAttribute(UIComponent component, String name) {
        return ComponentUtil.getIntAttribute(component, name, 0);
    }

    public static int getIntAttribute(UIComponent component, String name, int defaultValue) {
        Object integer = component.getAttributes().get(name);
        if (integer instanceof Number) {
            return ((Number)integer).intValue();
        }
        if (integer instanceof String) {
            try {
                return Integer.parseInt((String)integer);
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("Can't parse number from string : \"" + integer + "\"!"));
                return defaultValue;
            }
        }
        if (integer == null) {
            return defaultValue;
        }
        LOG.warn((Object)("Unknown type '" + integer.getClass().getName() + "' for integer attribute: " + name + " comp: " + component));
        return defaultValue;
    }

    @Deprecated
    public static Character getCharakterAttribute(UIComponent component, String name) {
        return ComponentUtil.getCharacterAttribute(component, name);
    }

    public static Character getCharacterAttribute(UIComponent component, String name) {
        Object character = component.getAttributes().get(name);
        if (character == null) {
            return null;
        }
        if (character instanceof Character) {
            return (Character)character;
        }
        if (character instanceof String) {
            String asString = (String)character;
            return asString.length() > 0 ? Character.valueOf(asString.charAt(0)) : null;
        }
        LOG.warn((Object)("Unknown type '" + character.getClass().getName() + "' for integer attribute: " + name + " comp: " + component));
        return null;
    }

    public static boolean isFacetOf(UIComponent component, UIComponent parent) {
        for (Object o : parent.getFacets().keySet()) {
            UIComponent facet = parent.getFacet((String)o);
            if (!component.equals(facet)) continue;
            return true;
        }
        return false;
    }

    public static LayoutableRendererBase getRenderer(FacesContext facesContext, UIComponent component) {
        return ComponentUtil.getRenderer(facesContext, component.getFamily(), component.getRendererType());
    }

    public static LayoutableRendererBase getRenderer(FacesContext facesContext, String family, String rendererType) {
        if (rendererType == null) {
            return null;
        }
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        LayoutableRendererBase renderer = (LayoutableRendererBase)requestMap.get(RENDER_KEY_PREFIX + rendererType);
        if (renderer == null) {
            RenderKitFactory rkFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
            RenderKit renderKit = rkFactory.getRenderKit(facesContext, facesContext.getViewRoot().getRenderKitId());
            Renderer myRenderer = renderKit.getRenderer(family, rendererType);
            if (myRenderer instanceof LayoutableRendererBase) {
                requestMap.put(RENDER_KEY_PREFIX + rendererType, myRenderer);
                renderer = (LayoutableRendererBase)myRenderer;
            } else {
                return null;
            }
        }
        return renderer;
    }

    public static String currentValue(UIComponent component) {
        String currentValue = null;
        if (component instanceof ValueHolder) {
            Object value;
            if (component instanceof EditableValueHolder && (value = ((EditableValueHolder)component).getSubmittedValue()) != null) {
                return (String)value;
            }
            value = ((ValueHolder)component).getValue();
            if (value != null) {
                Converter converter = ((ValueHolder)component).getConverter();
                if (converter == null) {
                    FacesContext context = FacesContext.getCurrentInstance();
                    converter = context.getApplication().createConverter(value.getClass());
                }
                currentValue = converter != null ? converter.getAsString(FacesContext.getCurrentInstance(), component, value) : value.toString();
            }
        }
        return currentValue;
    }

    public static List<SelectItem> getSelectItems(UIComponent component) {
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        for (Object o1 : component.getChildren()) {
            Object value;
            UIComponent kid = (UIComponent)o1;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("kid " + kid));
                LOG.debug((Object)("kid " + kid.getClass().getName()));
            }
            if (kid instanceof javax.faces.component.UISelectItem) {
                value = ((javax.faces.component.UISelectItem)kid).getValue();
                if (value == null) {
                    javax.faces.component.UISelectItem item = (javax.faces.component.UISelectItem)kid;
                    if (kid instanceof UISelectItem) {
                        list.add(new org.apache.myfaces.tobago.model.SelectItem((UISelectItem)kid));
                        continue;
                    }
                    list.add(new SelectItem(item.getItemValue() == null ? "" : item.getItemValue(), item.getItemLabel() != null ? item.getItemLabel() : item.getItemValue().toString(), item.getItemDescription()));
                    continue;
                }
                if (value instanceof SelectItem) {
                    list.add((SelectItem)value);
                    continue;
                }
                throw new IllegalArgumentException("TYPE ERROR: value NOT instanceof SelectItem. type=" + value.getClass().getName());
            }
            if (!(kid instanceof UISelectItems)) continue;
            value = ((UISelectItems)kid).getValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("value " + value));
                if (value != null) {
                    LOG.debug((Object)("value " + value.getClass().getName()));
                }
            }
            if (value == null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)"value is null");
                continue;
            }
            if (value instanceof SelectItem) {
                list.add((SelectItem)value);
                continue;
            }
            if (value instanceof SelectItem[]) {
                SelectItem[] items = (SelectItem[])value;
                list.addAll(Arrays.asList(items));
                continue;
            }
            if (value instanceof Collection) {
                for (Object o : (Collection)value) {
                    list.add((SelectItem)o);
                }
                continue;
            }
            if (value instanceof Map) {
                for (Object key : ((Map)value).keySet()) {
                    Object val;
                    if (key == null || (val = ((Map)value).get(key)) == null) continue;
                    list.add(new SelectItem((Object)val.toString(), key.toString(), null));
                }
                continue;
            }
            throw new IllegalArgumentException("TYPE ERROR: value NOT instanceof SelectItem, SelectItem[], Collection, Map. type=" + value.getClass().getName());
        }
        return list;
    }

    public static Object findParameter(UIComponent component, String name) {
        for (Object o : component.getChildren()) {
            UIComponent child = (UIComponent)o;
            if (!(child instanceof UIParameter)) continue;
            UIParameter parameter = (UIParameter)child;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Select name='" + parameter.getName() + "'"));
                LOG.debug((Object)("Select value='" + parameter.getValue() + "'"));
            }
            if (!name.equals(parameter.getName())) continue;
            return parameter.getValue();
        }
        return null;
    }

    public static String toString(UIComponent component, int offset) {
        return ComponentUtil.toString(component, offset, false);
    }

    private static String toString(UIComponent component, int offset, boolean asFacet) {
        StringBuilder result = new StringBuilder();
        if (component == null) {
            result.append("null");
        } else {
            Map facets;
            result.append('\n');
            if (!asFacet) {
                result.append(ComponentUtil.spaces(offset));
                result.append(ComponentUtil.toString(component));
            }
            if ((facets = component.getFacets()).size() > 0) {
                for (Map.Entry entry : facets.entrySet()) {
                    UIComponent facet = (UIComponent)entry.getValue();
                    result.append('\n');
                    result.append(ComponentUtil.spaces(offset + 1));
                    result.append('\"');
                    result.append((String)entry.getKey());
                    result.append("\" = ");
                    result.append(ComponentUtil.toString(facet));
                    result.append(ComponentUtil.toString(facet, offset + 1, true));
                }
            }
            for (Map.Entry o : component.getChildren()) {
                result.append(ComponentUtil.toString((UIComponent)o, offset + 1, false));
            }
        }
        return result.toString();
    }

    private static String toString(UIComponent component) {
        StringBuilder buf = new StringBuilder(component.getClass().getName());
        buf.append('@');
        buf.append(Integer.toHexString(component.hashCode()));
        buf.append(" ");
        buf.append(component.getRendererType());
        buf.append(" ");
        if (component instanceof UIViewRoot) {
            buf.append(((UIViewRoot)component).getViewId());
        } else {
            buf.append(component.getId());
            buf.append(" ");
            buf.append(component.getClientId(FacesContext.getCurrentInstance()));
        }
        return buf.toString();
    }

    private static String spaces(int n) {
        StringBuilder buffer = new StringBuilder(n * 2);
        for (int i = 0; i < n; ++i) {
            buffer.append("  ");
        }
        return buffer.toString();
    }

    public static ActionListener createActionListener(String type) throws JspException {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = type.getClass().getClassLoader();
            }
            Class<?> clazz = classLoader.loadClass(type);
            return (ActionListener)clazz.newInstance();
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("type=" + type), (Throwable)e);
            }
            throw new JspException((Throwable)e);
        }
    }

    public static UIGraphic getFirstGraphicChild(UIComponent component) {
        UIGraphic graphic = null;
        for (Object o : component.getChildren()) {
            UIComponent uiComponent = (UIComponent)o;
            if (!(uiComponent instanceof UIGraphic)) continue;
            graphic = (UIGraphic)uiComponent;
            break;
        }
        return graphic;
    }

    public static boolean isHoverEnabled(UIComponent component) {
        return ComponentUtil.getBooleanAttribute(component, "hover");
    }

    public static UIOutput getFirstNonGraphicChild(UIComponent component) {
        UIOutput output = null;
        for (Object o : component.getChildren()) {
            UIComponent uiComponent = (UIComponent)o;
            if (!(uiComponent instanceof UIOutput) || uiComponent instanceof UIGraphic) continue;
            output = (UIOutput)uiComponent;
            break;
        }
        return output;
    }

    public static void setIntegerSizeProperty(UIComponent component, String name, String value) {
        if (value != null) {
            if (UIComponentTag.isValueReference((String)value)) {
                component.setValueBinding(name, ComponentUtil.createValueBinding(value));
            } else {
                value = ComponentUtil.removePx(value);
                component.getAttributes().put(name, new Integer(value));
            }
        }
    }

    public static String removePx(String value) {
        if (value != null && value.endsWith("px")) {
            value = value.substring(0, value.length() - 2);
        }
        return value;
    }

    public static void setIntegerProperty(UIComponent component, String name, String value) {
        if (value != null) {
            if (UIComponentTag.isValueReference((String)value)) {
                component.setValueBinding(name, ComponentUtil.createValueBinding(value));
            } else {
                component.getAttributes().put(name, new Integer(value));
            }
        }
    }

    public static void setBooleanProperty(UIComponent component, String name, String value) {
        if (value != null) {
            if (UIComponentTag.isValueReference((String)value)) {
                component.setValueBinding(name, ComponentUtil.createValueBinding(value));
            } else {
                component.getAttributes().put(name, Boolean.valueOf(value));
            }
        }
    }

    public static void setStringProperty(UIComponent component, String name, String value) {
        if (value != null) {
            if (UIComponentTag.isValueReference((String)value)) {
                component.setValueBinding(name, ComponentUtil.createValueBinding(value));
            } else {
                component.getAttributes().put(name, value);
            }
        }
    }

    public static void setValueForValueBinding(String name, Object value) {
        FacesContext context = FacesContext.getCurrentInstance();
        ValueBinding valueBinding = context.getApplication().createValueBinding(name);
        valueBinding.setValue(context, value);
    }

    public static ValueBinding createValueBinding(String value) {
        return FacesContext.getCurrentInstance().getApplication().createValueBinding(value);
    }

    public static String getValueFromEl(String script) {
        if (UIComponentTag.isValueReference((String)script)) {
            ValueBinding valueBinding = ComponentUtil.createValueBinding(script);
            script = (String)valueBinding.getValue(FacesContext.getCurrentInstance());
        }
        return script;
    }

    @Deprecated
    public static UIComponent createComponent(String componentType, String rendererType) {
        return ComponentUtil.createComponent(componentType, rendererType, null);
    }

    public static UIComponent createComponent(String componentType, String rendererType, String id) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return ComponentUtil.createComponent(facesContext, componentType, rendererType, id);
    }

    @Deprecated
    public static UIComponent createComponent(FacesContext facesContext, String componentType, String rendererType) {
        return ComponentUtil.createComponent(facesContext, componentType, rendererType, null);
    }

    public static UIComponent createComponent(FacesContext facesContext, String componentType, String rendererType, String id) {
        UIComponent component = facesContext.getApplication().createComponent(componentType);
        component.setRendererType(rendererType);
        component.setId(id);
        return component;
    }

    @Deprecated
    public static UIColumn createTextColumn(String label, String sortable, String align, String value) {
        return ComponentUtil.createTextColumn(label, sortable, align, value, null);
    }

    public static UIColumn createTextColumn(String label, String sortable, String align, String value, String id) {
        UIComponent text = ComponentUtil.createComponent("javax.faces.Output", "Out", id + "_t");
        ComponentUtil.setStringProperty(text, "value", value);
        ComponentUtil.setBooleanProperty(text, "createSpan", "false");
        ComponentUtil.setBooleanProperty(text, "escape", "false");
        return ComponentUtil.createColumn(label, sortable, align, text, id);
    }

    @Deprecated
    public static UIColumn createColumn(String label, String sortable, String align, UIComponent child) {
        return ComponentUtil.createColumn(label, sortable, align, child, null);
    }

    public static UIColumn createColumn(String label, String sortable, String align, UIComponent child, String id) {
        UIColumn column = ComponentUtil.createColumn(label, sortable, align, id);
        column.getChildren().add(child);
        return column;
    }

    private static UIColumn createColumn(String label, String sortable, String align, String id) {
        UIColumn column = (UIColumn)ComponentUtil.createComponent("org.apache.myfaces.tobago.Column", null, id);
        ComponentUtil.setStringProperty((UIComponent)column, "label", label);
        ComponentUtil.setBooleanProperty((UIComponent)column, "sortable", sortable);
        ComponentUtil.setStringProperty((UIComponent)column, "align", align);
        return column;
    }

    @Deprecated
    public static UIMenuSelectOne createUIMenuSelectOneFacet(FacesContext facesContext, javax.faces.component.UICommand command) {
        return ComponentUtil.createUIMenuSelectOneFacet(facesContext, command, null);
    }

    public static UIMenuSelectOne createUIMenuSelectOneFacet(FacesContext facesContext, javax.faces.component.UICommand command, String id) {
        UIMenuSelectOne radio = null;
        ValueBinding valueBinding = command.getValueBinding("value");
        if (valueBinding != null) {
            radio = (UIMenuSelectOne)ComponentUtil.createComponent(facesContext, "org.apache.myfaces.tobago.MenuSelectOne", "SelectOneRadio", id);
            command.getFacets().put("items", radio);
            radio.setValueBinding("value", valueBinding);
        }
        return radio;
    }

    public static boolean hasSelectedValue(List<SelectItem> items, Object value) {
        for (SelectItem item : items) {
            if (!ObjectUtils.equals((Object)item.getValue(), (Object)value)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static UIComponent createUISelectBooleanFacet(FacesContext facesContext, javax.faces.component.UICommand command) {
        return ComponentUtil.createUISelectBooleanFacet(facesContext, command, null);
    }

    public static UIComponent createUISelectBooleanFacet(FacesContext facesContext, javax.faces.component.UICommand command, String id) {
        UIComponent checkbox = ComponentUtil.createComponent(facesContext, "org.apache.myfaces.tobago.SelectBoolean", "SelectBooleanCheckbox", id);
        command.getFacets().put("items", checkbox);
        ValueBinding valueBinding = command.getValueBinding("value");
        if (valueBinding != null) {
            checkbox.setValueBinding("value", valueBinding);
        } else {
            checkbox.getAttributes().put("value", command.getAttributes().get("value"));
        }
        return checkbox;
    }

    public static int getIntValue(ValueBinding valueBinding) {
        return ComponentUtil.getAsInt(valueBinding.getValue(FacesContext.getCurrentInstance()));
    }

    private static int getAsInt(Object value) {
        int result;
        if (value instanceof Number) {
            result = ((Number)value).intValue();
        } else if (value instanceof String) {
            result = Integer.parseInt((String)value);
        } else {
            throw new IllegalArgumentException("Can't convert " + value + " to int!");
        }
        return result;
    }

    public static String createPickerId(FacesContext facesContext, UIComponent component, String postfix) {
        String id = ComponentUtil.getComponentId(facesContext, component);
        return id + "_picker" + postfix;
    }

    public static String getComponentId(FacesContext facesContext, UIComponent component) {
        String id = component.getId();
        return id;
    }

    public static UIComponent provideLabel(FacesContext facesContext, UIComponent component) {
        UIComponent label = component.getFacet("label");
        if (label == null) {
            Map attributes = component.getAttributes();
            Object labelText = component.getValueBinding("label");
            if (labelText == null) {
                labelText = attributes.get("label");
            }
            if (labelText != null) {
                Application application = FacesContext.getCurrentInstance().getApplication();
                label = application.createComponent("javax.faces.Output");
                label.setRendererType("Label");
                String idprefix = ComponentUtil.getComponentId(facesContext, component);
                label.setId(idprefix + "_" + "label");
                label.setRendered(true);
                if (labelText instanceof ValueBinding) {
                    label.setValueBinding("value", labelText);
                } else {
                    label.getAttributes().put("value", labelText);
                }
                component.getFacets().put("label", label);
            }
        }
        return label;
    }

    public static List<SelectItem> getItemsToRender(UISelectOne component) {
        return ComponentUtil.getItems((javax.faces.component.UIInput)component);
    }

    public static List<SelectItem> getItemsToRender(javax.faces.component.UISelectMany component) {
        return ComponentUtil.getItems((javax.faces.component.UIInput)component);
    }

    private static List<SelectItem> getItems(javax.faces.component.UIInput component) {
        List<SelectItem> selectItems = ComponentUtil.getSelectItems((UIComponent)component);
        String renderRange = (String)component.getAttributes().get("renderRangeExtern");
        if (renderRange == null) {
            renderRange = (String)component.getAttributes().get("renderRange");
        }
        if (renderRange == null) {
            return selectItems;
        }
        int[] indices = RangeParser.getIndices(renderRange);
        ArrayList<SelectItem> items = new ArrayList<SelectItem>(indices.length);
        if (selectItems.size() != 0) {
            for (int indice : indices) {
                items.add(selectItems.get(indice));
            }
        } else {
            LOG.warn((Object)"No items found! rendering dummys instead!");
            for (int i = 0; i < indices.length; ++i) {
                items.add(new SelectItem((Object)Integer.toString(i), "Item " + i, ""));
            }
        }
        return items;
    }

    public static void setValidator(EditableValueHolder editableValueHolder, String validator) {
        if (validator != null && editableValueHolder.getValidator() == null && UIComponentTag.isValueReference((String)validator)) {
            MethodBinding methodBinding = FacesContext.getCurrentInstance().getApplication().createMethodBinding(validator, VALIDATOR_ARGS);
            editableValueHolder.setValidator(methodBinding);
        }
    }

    @Deprecated
    public static void setConverter(UIComponent component, String converterId) {
        if (component instanceof ValueHolder) {
            ComponentUtil.setConverter((ValueHolder)component, converterId);
        }
    }

    public static void setConverter(ValueHolder valueHolder, String converterId) {
        if (converterId != null && valueHolder.getConverter() == null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            Application application = facesContext.getApplication();
            if (UIComponentTag.isValueReference((String)converterId)) {
                ValueBinding valueBinding = application.createValueBinding(converterId);
                if (valueHolder instanceof UIComponent) {
                    ((UIComponent)valueHolder).setValueBinding("converter", valueBinding);
                }
            } else {
                Converter converter = application.createConverter(converterId);
                valueHolder.setConverter(converter);
            }
        }
    }

    @Deprecated
    public static void setAction(UIComponent component, String type, String action) {
        if (component instanceof javax.faces.component.UICommand) {
            ComponentUtil.setAction((javax.faces.component.UICommand)component, type, action);
        }
    }

    public static void setAction(javax.faces.component.UICommand component, String type, String action) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        String commandType = type != null && UIComponentTag.isValueReference((String)type) ? (String)application.createValueBinding(type).getValue(facesContext) : type;
        if (commandType != null && (commandType.equals("navigate") || commandType.equals("reset") || commandType.equals("script"))) {
            if (commandType.equals("navigate")) {
                ComponentUtil.setStringProperty((UIComponent)component, "link", action);
            } else if (commandType.equals("script")) {
                ComponentUtil.setStringProperty((UIComponent)component, "onclick", action);
            } else {
                LOG.warn((Object)"Type reset is not supported");
            }
        } else if (action != null) {
            if (UIComponentTag.isValueReference((String)action)) {
                MethodBinding binding = application.createMethodBinding(action, null);
                component.setAction(binding);
            } else {
                component.setAction((MethodBinding)new ConstantMethodBinding(action));
            }
        }
    }

    @Deprecated
    public static void setSuggestMethodBinding(UIComponent component, String suggestMethod) {
        if (component instanceof UIInput) {
            ComponentUtil.setSuggestMethodBinding((UIInput)component, suggestMethod);
        }
    }

    public static void setSuggestMethodBinding(UIInput component, String suggestMethod) {
        if (suggestMethod != null) {
            if (UIComponentTag.isValueReference((String)suggestMethod)) {
                MethodBinding methodBinding = FacesContext.getCurrentInstance().getApplication().createMethodBinding(suggestMethod, new Class[]{String.class});
                component.setSuggestMethod(methodBinding);
            } else {
                throw new IllegalArgumentException("Must be a valueReference (suggestMethod): " + suggestMethod);
            }
        }
    }

    public static void setActionListener(ActionSource command, String actionListener) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        if (actionListener != null) {
            if (UIComponentTag.isValueReference((String)actionListener)) {
                MethodBinding binding = application.createMethodBinding(actionListener, ACTION_LISTENER_ARGS);
                command.setActionListener(binding);
            } else {
                throw new IllegalArgumentException("Must be a valueReference (actionListener): " + actionListener);
            }
        }
    }

    public static void setValueChangeListener(EditableValueHolder valueHolder, String valueChangeListener) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        if (valueChangeListener != null) {
            if (UIComponentTag.isValueReference((String)valueChangeListener)) {
                MethodBinding binding = application.createMethodBinding(valueChangeListener, VALUE_CHANGE_LISTENER_ARGS);
                valueHolder.setValueChangeListener(binding);
            } else {
                throw new IllegalArgumentException("Must be a valueReference (valueChangeListener): " + valueChangeListener);
            }
        }
    }

    public static void setSortActionListener(UIData data, String actionListener) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        if (actionListener != null) {
            if (UIComponentTag.isValueReference((String)actionListener)) {
                MethodBinding binding = application.createMethodBinding(actionListener, ACTION_LISTENER_ARGS);
                data.setSortActionListener(binding);
            } else {
                throw new IllegalArgumentException("Must be a valueReference (sortActionListener): " + actionListener);
            }
        }
    }

    public static void setValueBinding(UIComponent component, String name, String state) {
        if (state != null && UIComponentTag.isValueReference((String)state)) {
            ValueBinding valueBinding = ComponentUtil.createValueBinding(state);
            component.setValueBinding(name, valueBinding);
        }
    }

    public static void setStateChangeListener(UIData data, String stateChangeListener) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        if (stateChangeListener != null) {
            if (UIComponentTag.isValueReference((String)stateChangeListener)) {
                Class[] arguments = new Class[]{SheetStateChangeEvent.class};
                MethodBinding binding = application.createMethodBinding(stateChangeListener, arguments);
                data.setStateChangeListener(binding);
            } else {
                throw new IllegalArgumentException("Must be a valueReference (actionListener): " + stateChangeListener);
            }
        }
    }

    public static String[] getMarkupBinding(FacesContext facesContext, SupportsMarkup component) {
        ValueBinding vb = ((UIComponent)component).getValueBinding("markup");
        if (vb != null) {
            Object markups = vb.getValue(facesContext);
            if (markups instanceof String[]) {
                return (String[])markups;
            }
            if (markups instanceof String) {
                String[] strings = StringUtils.split((String)((String)markups), (String)", ");
                ArrayList<String> result = new ArrayList<String>(strings.length);
                for (String string : strings) {
                    if (string.trim().length() == 0) continue;
                    result.add(string.trim());
                }
                return result.toArray(new String[result.size()]);
            }
            if (markups == null) {
                return new String[0];
            }
            return new String[]{markups.toString()};
        }
        return new String[0];
    }

    public static UIComponent findComponent(UIComponent from, String relativeId) {
        int colonCount;
        int idLength = relativeId.length();
        for (colonCount = 0; colonCount < idLength && relativeId.charAt(colonCount) == ':'; ++colonCount) {
        }
        if (colonCount > 1) {
            relativeId = relativeId.substring(colonCount);
            for (int j = 1; j < colonCount; ++j) {
                while (from.getParent() != null && !((from = from.getParent()) instanceof NamingContainer)) {
                }
            }
        }
        return from.findComponent(relativeId);
    }

    public static void invokeOnComponent(FacesContext facesContext, String clientId, UIComponent component, Callback callback) {
        ArrayList<UIComponent> list = new ArrayList<UIComponent>();
        while (component != null) {
            list.add(component);
            component = component.getParent();
        }
        Collections.reverse(list);
        ComponentUtil.invokeOrPrepare(facesContext, list, clientId, callback);
        facesContext.getExternalContext().getRequestMap().remove("zIndex");
    }

    private static void invokeOrPrepare(FacesContext facesContext, List<UIComponent> list, String clientId, Callback callback) {
        if (list.size() == 1) {
            callback.execute(facesContext, list.get(0));
        } else if (list.get(0) instanceof UIData) {
            ComponentUtil.prepareOnUIData(facesContext, list, clientId, callback);
        } else if (list.get(0) instanceof UIForm) {
            ComponentUtil.prepareOnUIForm(facesContext, list, clientId, callback);
        } else if (list.get(0) instanceof UIPopup) {
            ComponentUtil.prepareOnUIPopup(facesContext, list, clientId, callback);
        } else {
            ComponentUtil.prepareOnUIComponent(facesContext, list, clientId, callback);
        }
    }

    private static void prepareOnUIForm(FacesContext facesContext, List<UIComponent> list, String clientId, Callback callback) {
        UIComponent currentComponent = list.remove(0);
        if (!(currentComponent instanceof UIForm)) {
            throw new IllegalStateException(currentComponent.getClass().getName());
        }
        if (callback instanceof TobagoCallback && PhaseId.APPLY_REQUEST_VALUES.equals(((TobagoCallback)callback).getPhaseId())) {
            currentComponent.decode(facesContext);
        }
        UIForm uiForm = (UIForm)currentComponent;
        facesContext.getExternalContext().getRequestMap().put("org.apache.myfaces.tobago.Form.InSubmitted", uiForm.isSubmitted());
        ComponentUtil.invokeOrPrepare(facesContext, list, clientId, callback);
    }

    private static void prepareOnUIComponent(FacesContext facesContext, List<UIComponent> list, String clientId, Callback callback) {
        list.remove(0);
        ComponentUtil.invokeOrPrepare(facesContext, list, clientId, callback);
    }

    private static void prepareOnUIPopup(FacesContext facesContext, List<UIComponent> list, String clientId, Callback callback) {
        if (callback instanceof TobagoCallback && PhaseId.RENDER_RESPONSE.equals(((TobagoCallback)callback).getPhaseId())) {
            Integer zIndex = (Integer)facesContext.getExternalContext().getRequestMap().get("zIndex");
            zIndex = zIndex == null ? Integer.valueOf(0) : Integer.valueOf(zIndex + 10);
            facesContext.getExternalContext().getRequestMap().put("zIndex", zIndex);
        }
        list.remove(0);
        ComponentUtil.invokeOrPrepare(facesContext, list, clientId, callback);
    }

    private static void prepareOnUIData(FacesContext facesContext, List<UIComponent> list, String clientId, Callback callback) {
        UIComponent currentComponent = list.remove(0);
        if (!(currentComponent instanceof UIData)) {
            throw new IllegalStateException(currentComponent.getClass().getName());
        }
        javax.faces.component.UIData uiData = (javax.faces.component.UIData)currentComponent;
        int oldRowIndex = uiData.getRowIndex();
        String sheetId = uiData.getClientId(facesContext);
        String idRemainder = clientId.substring(sheetId.length());
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("idRemainder = \"" + idRemainder + "\""));
        }
        if (idRemainder.startsWith(String.valueOf(':'))) {
            String firstPart;
            int idx = (idRemainder = idRemainder.substring(1)).indexOf(58);
            if (idx > 0 && NumberUtils.isDigits((String)(firstPart = idRemainder.substring(0, idx)))) {
                try {
                    int rowIndex = Integer.parseInt(firstPart);
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("set rowIndex = \"" + rowIndex + "\""));
                    }
                    uiData.setRowIndex(rowIndex);
                }
                catch (NumberFormatException e) {
                    LOG.error((Object)("idRemainder = \"" + idRemainder + "\""), (Throwable)e);
                }
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info((Object)"no match for \"^:\\d+:.*\"");
        }
        ComponentUtil.invokeOrPrepare(facesContext, list, clientId, callback);
        uiData.setRowIndex(oldRowIndex);
    }

    public static Object getConvertedValue(FacesContext facesContext, javax.faces.component.UIInput component, String stringValue) {
        try {
            Class valueType;
            ValueBinding vb;
            LayoutableRendererBase renderer = ComponentUtil.getRenderer(facesContext, (UIComponent)component);
            if (renderer != null) {
                if (component instanceof UISelectMany) {
                    Object converted = renderer.getConvertedValue(facesContext, (UIComponent)component, new String[]{stringValue});
                    return ((Object[])converted)[0];
                }
                return renderer.getConvertedValue(facesContext, (UIComponent)component, stringValue);
            }
            Converter converter = component.getConverter();
            if (converter == null && (vb = component.getValueBinding("value")) != null && (valueType = vb.getType(facesContext)) != null) {
                converter = facesContext.getApplication().createConverter(valueType);
            }
            if (converter != null) {
                converter.getAsObject(facesContext, (UIComponent)component, stringValue);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Can't convert string value '" + stringValue + "'"), (Throwable)e);
        }
        return stringValue;
    }
}

