/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.webapp;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.config.ThemeConfig;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.config.TobagoConfigParser;
import org.apache.myfaces.tobago.context.ResourceManagerFactory;
import org.apache.myfaces.tobago.util.LayoutUtil;

public class TobagoServletContextListener
implements ServletContextListener {
    private static final Log LOG;
    static /* synthetic */ Class class$org$apache$myfaces$tobago$webapp$TobagoServletContextListener;

    public void contextInitialized(ServletContextEvent event) {
        block4: {
            ServletContext servletContext = event.getServletContext();
            if (servletContext.getAttribute("org.apache.myfaces.tobago.config.TobagoConfig") != null) {
                LOG.warn((Object)"Tobago has been already initialized. Do nothing. (This may happen when there is a TobagoServletContextListener configured manually.)");
                return;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"*** contextInitialized ***");
            }
            try {
                TobagoConfig tobagoConfig = new TobagoConfigParser().parse(servletContext);
                servletContext.setAttribute("org.apache.myfaces.tobago.config.TobagoConfig", (Object)tobagoConfig);
                ResourceManagerFactory.init(servletContext, tobagoConfig);
                LayoutUtil.setFixLayoutTransparency(tobagoConfig.isFixLayoutTransparency());
                tobagoConfig.resolveThemes();
                ThemeConfig.init(servletContext);
            }
            catch (Throwable e) {
                if (!LOG.isFatalEnabled()) break block4;
                String error = "Error while deploy process. Tobago can't be initialized! Application will not run!";
                LOG.fatal((Object)error, e);
                throw new RuntimeException(error, e);
            }
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        if (servletContext.getAttribute("org.apache.myfaces.tobago.config.TobagoConfig") == null) {
            LOG.warn((Object)"Tobago is not initialized. Do nothing. (This may happen when there is a TobagoServletContextListener configured manually.)");
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"*** contextDestroyed ***\n--- snip -----------------------------------------------------------------------");
        }
        servletContext.removeAttribute("org.apache.myfaces.tobago.config.TobagoConfig");
        ResourceManagerFactory.release(servletContext);
        ThemeConfig.shutdown(servletContext);
        LogFactory.releaseAll();
    }

    static {
        Class<?> clazz = class$org$apache$myfaces$tobago$webapp$TobagoServletContextListener;
        if (clazz == null) {
            clazz = class$org$apache$myfaces$tobago$webapp$TobagoServletContextListener = new TobagoServletContextListener[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
    }
}

