/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.webapp;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.FacesException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import net.sf.retrotranslator.runtime.java.util._Arrays;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TobagoMultipartFormdataRequest
extends HttpServletRequestWrapper {
    private static final Log LOG;
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_GB = 0x40000000L;
    private Map<String, String[]> parameters;
    private Map<String, FileItem> fileItems;
    static /* synthetic */ Class class$org$apache$myfaces$tobago$webapp$TobagoMultipartFormdataRequest;

    public TobagoMultipartFormdataRequest(HttpServletRequest request) {
        this(request, System.getProperty("java.io.tmpdir"), 0x100000L);
    }

    public TobagoMultipartFormdataRequest(HttpServletRequest request, String repositoryPath, long maxSize) {
        super(request);
        this.init(request, repositoryPath, maxSize);
    }

    private void init(HttpServletRequest request, String repositoryPath, long maxSize) {
        List itemList;
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            String errorText = "contentType is not multipart/form-data but '" + request.getContentType() + "'";
            LOG.error((Object)errorText);
            throw new FacesException(errorText);
        }
        this.parameters = new HashMap<String, String[]>();
        this.fileItems = new HashMap<String, FileItem>();
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setRepository(new File(repositoryPath));
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setSizeMax(maxSize);
        if (upload.getHeaderEncoding() != null) {
            upload.setHeaderEncoding("utf-8");
        }
        try {
            itemList = upload.parseRequest(request);
        }
        catch (FileUploadException e) {
            throw new FacesException((Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("parametercount = " + itemList.size() + " + " + request.getParameterMap().size()));
        }
        Iterator i$ = itemList.iterator();
        while (i$.hasNext()) {
            FileItem item = (FileItem)i$.next();
            String key = item.getFieldName();
            if (LOG.isDebugEnabled()) {
                String value = item.getString();
                if (value.length() > 100) {
                    value = value.substring(0, 100) + " [...]";
                }
                LOG.debug((Object)("Parameter: '" + key + "'='" + value + "' isFormField=" + item.isFormField() + " contentType='" + item.getContentType() + "'"));
            }
            if (item.isFormField()) {
                String newValue;
                try {
                    newValue = item.getString("utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    LOG.error((Object)("Caught: " + e.getMessage()), (Throwable)e);
                    newValue = item.getString();
                }
                this.addParameter(key, newValue);
                continue;
            }
            this.fileItems.put(key, item);
        }
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Object[] newValues = request.getParameterValues(name);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Parameter: '" + name + "'='" + _Arrays.toString((Object[])newValues) + "' (GET)"));
            }
            Object[] arr$ = newValues;
            int len$ = arr$.length;
            for (int i$2 = 0; i$2 < len$; ++i$2) {
                Object newValue = arr$[i$2];
                this.addParameter(name, (String)newValue);
            }
        }
    }

    private void addParameter(String key, String newValue) {
        String[] values;
        String[] inStock = this.parameters.get(key);
        if (inStock == null) {
            values = new String[]{newValue};
        } else {
            values = new String[inStock.length + 1];
            System.arraycopy(inStock, 0, values, 0, inStock.length);
            values[inStock.length] = newValue;
        }
        this.parameters.put(key, values);
    }

    public FileItem getFileItem(String key) {
        if (this.fileItems != null) {
            return this.fileItems.get(key);
        }
        return null;
    }

    public String getParameter(String key) {
        String parameter = null;
        String[] values = this.parameters.get(key);
        if (values != null) {
            parameter = values[0];
        }
        return parameter;
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String key) {
        return this.parameters.get(key);
    }

    public Map getParameterMap() {
        return this.parameters;
    }

    public static long getMaxSize(String param) {
        if (param != null) {
            String number = param.toLowerCase(Locale.ENGLISH);
            long factor = 1L;
            if (number.endsWith("g")) {
                factor = 0x40000000L;
                number = number.substring(0, number.length() - 1);
            } else if (number.endsWith("m")) {
                factor = 0x100000L;
                number = number.substring(0, number.length() - 1);
            } else if (number.endsWith("k")) {
                factor = 1024L;
                number = number.substring(0, number.length() - 1);
            }
            try {
                return Long.parseLong(number.trim()) * factor;
            }
            catch (NumberFormatException e) {
                StringBuffer stringBuffer = new StringBuffer().append("Given max file size for ");
                Class<?> clazz = class$org$apache$myfaces$tobago$webapp$TobagoMultipartFormdataRequest;
                if (clazz == null) {
                    clazz = class$org$apache$myfaces$tobago$webapp$TobagoMultipartFormdataRequest = new TobagoMultipartFormdataRequest[0].getClass().getComponentType();
                }
                LOG.error((Object)stringBuffer.append(clazz.getName()).append(" ").append(param).append(" couldn't parsed to a number").toString());
            }
        }
        return 0x100000L;
    }

    static {
        Class<?> clazz = class$org$apache$myfaces$tobago$webapp$TobagoMultipartFormdataRequest;
        if (clazz == null) {
            clazz = class$org$apache$myfaces$tobago$webapp$TobagoMultipartFormdataRequest = new TobagoMultipartFormdataRequest[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
    }
}

