/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.webapp;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.webapp.TobagoMultipartFormdataRequest;
import org.apache.myfaces.tobago.webapp.TobagoResponse;

public class TobagoMultipartFormdataFilter
implements Filter {
    private static final Log LOG;
    private String repositoryPath = System.getProperty("java.io.tmpdir");
    private long maxSize = 0x100000L;
    static /* synthetic */ Class class$org$apache$myfaces$tobago$webapp$TobagoMultipartFormdataFilter;

    public void init(FilterConfig filterConfig) throws ServletException {
        String repositoryPath = filterConfig.getInitParameter("uploadRepositoryPath");
        if (repositoryPath != null) {
            File file = new File(repositoryPath);
            if (!file.exists()) {
                LOG.error((Object)("Given repository Path for " + this.getClass().getName() + " " + repositoryPath + " doesn't exists"));
            } else if (!file.isDirectory()) {
                LOG.error((Object)("Given repository Path for " + this.getClass().getName() + " " + repositoryPath + " is not a directory"));
            } else {
                this.repositoryPath = repositoryPath;
            }
        }
        LOG.info((Object)("Configure uploadRepositryPath for " + this.getClass().getName() + " to " + this.repositoryPath));
        this.maxSize = TobagoMultipartFormdataRequest.getMaxSize(filterConfig.getInitParameter("uploadMaxFileSize"));
        LOG.info((Object)("Configure uploadMaxFileSize for " + this.getClass().getName() + " to " + this.maxSize));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object wrapper;
        if (request instanceof HttpServletRequest) {
            if (request instanceof TobagoMultipartFormdataRequest) {
                wrapper = request;
            } else {
                String contentType = request.getContentType();
                if (contentType != null && contentType.toLowerCase(Locale.ENGLISH).startsWith("multipart/form-data")) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Wrapping " + request.getClass().getName() + " with ContentType=\"" + contentType + "\" " + "into TobagoMultipartFormdataRequest"));
                    }
                    wrapper = new TobagoMultipartFormdataRequest((HttpServletRequest)request, this.repositoryPath, this.maxSize);
                } else {
                    wrapper = request;
                }
            }
        } else {
            LOG.error((Object)"Not implemented for non HttpServletRequest");
            wrapper = request;
        }
        Object wrappedResponse = response instanceof HttpServletResponse ? new TobagoResponse((HttpServletResponse)response) : response;
        chain.doFilter(wrapper, wrappedResponse);
    }

    public void destroy() {
    }

    static {
        Class<?> clazz = class$org$apache$myfaces$tobago$webapp$TobagoMultipartFormdataFilter;
        if (clazz == null) {
            clazz = class$org$apache$myfaces$tobago$webapp$TobagoMultipartFormdataFilter = new TobagoMultipartFormdataFilter[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
    }
}

