/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.taglib.component;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.webapp.UIComponentTag;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UIMessages;
import org.apache.myfaces.tobago.taglib.component.MessagesTagDeclaration;
import org.apache.myfaces.tobago.taglib.component.TobagoTag;

public class MessagesTag
extends TobagoTag
implements MessagesTagDeclaration {
    private String forComponent;
    private String showSummary;
    private String showDetail;
    private String globalOnly;
    private String minSeverity;
    private String maxSeverity;
    private String maxNumber;
    private String orderBy;
    private String confirmation;

    public String getComponentType() {
        return "org.apache.myfaces.tobago.Messages";
    }

    protected void setProperties(UIComponent component) {
        super.setProperties(component);
        ComponentUtil.setStringProperty(component, "for", this.forComponent);
        ComponentUtil.setBooleanProperty(component, "globalOnly", this.globalOnly);
        ComponentUtil.setBooleanProperty(component, "showSummary", this.showSummary);
        ComponentUtil.setBooleanProperty(component, "showDetail", this.showDetail);
        this.setSeverityProperty(component, "minSeverity", this.minSeverity);
        this.setSeverityProperty(component, "maxSeverity", this.maxSeverity);
        ComponentUtil.setIntegerProperty(component, "maxNumber", this.maxNumber);
        this.setOrderByProperty(component, "orderBy", this.orderBy);
        ComponentUtil.setBooleanProperty(component, "confirmation", this.confirmation);
    }

    private void setSeverityProperty(UIComponent component, String name, String value) {
        if (value != null) {
            if (UIComponentTag.isValueReference((String)value)) {
                component.setValueBinding(name, ComponentUtil.createValueBinding(value));
            } else {
                component.getAttributes().put(name, FacesMessage.VALUES_MAP.get(value));
            }
        }
    }

    private void setOrderByProperty(UIComponent component, String name, String value) {
        if (value != null) {
            if (UIComponentTag.isValueReference((String)value)) {
                component.setValueBinding(name, ComponentUtil.createValueBinding(value));
            } else {
                component.getAttributes().put(name, UIMessages.OrderBy.parse(value));
            }
        }
    }

    public void release() {
        super.release();
        this.forComponent = null;
        this.showSummary = null;
        this.showDetail = null;
        this.minSeverity = null;
        this.maxSeverity = null;
        this.maxNumber = null;
        this.orderBy = null;
    }

    public String getFor() {
        return this.forComponent;
    }

    public void setFor(String forComponent) {
        this.forComponent = forComponent;
    }

    public void setGlobalOnly(String globalOnly) {
        this.globalOnly = globalOnly;
    }

    public void setShowSummary(String showSummary) {
        this.showSummary = showSummary;
    }

    public void setShowDetail(String showDetail) {
        this.showDetail = showDetail;
    }

    public void setMinSeverity(String minSeverity) {
        this.minSeverity = minSeverity;
    }

    public void setMaxSeverity(String maxSeverity) {
        this.maxSeverity = maxSeverity;
    }

    public void setMaxNumber(String maxNumber) {
        this.maxNumber = maxNumber;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public void setConfirmation(String confirmation) {
        this.confirmation = confirmation;
    }
}

