/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.util.MimeTypeUtils;

public class ResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = -4491419290205206466L;
    private static final Log LOG;
    private Long expires;
    static /* synthetic */ Class class$org$apache$myfaces$tobago$servlet$ResourceServlet;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        String expiresString = servletConfig.getInitParameter("expires");
        this.expires = null;
        if (expiresString != null) {
            try {
                this.expires = new Long(expiresString);
            }
            catch (NumberFormatException e) {
                LOG.error((Object)("Caught: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        InputStream inputStream;
        block6: {
            String contentType;
            String requestURI = request.getRequestURI();
            String resource = requestURI.substring(request.getContextPath().length() + 1);
            if (this.expires != null) {
                response.setHeader("Cache-Control", "max-age=" + this.expires);
                response.setDateHeader("Expires", new Date().getTime() + this.expires * 1000L);
            }
            if ((contentType = MimeTypeUtils.getMimeTypeForFile(requestURI)) == null) {
                String message = "Unsupported mime type of resource='" + resource + "'";
                LOG.warn((Object)(message + " (because of security reasons)"));
                response.sendError(403, message);
                return;
            }
            response.setContentType(contentType);
            inputStream = null;
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                inputStream = classLoader.getResourceAsStream("META-INF/resources/" + resource);
                if (inputStream == null) {
                    inputStream = classLoader.getResourceAsStream(resource);
                }
                if (inputStream != null) {
                    IOUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
                    break block6;
                }
                String message = "Resource '" + resource + "' not found!";
                LOG.warn((Object)message);
                response.sendError(404, message);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    static {
        Class<?> clazz = class$org$apache$myfaces$tobago$servlet$ResourceServlet;
        if (clazz == null) {
            clazz = class$org$apache$myfaces$tobago$servlet$ResourceServlet = new ResourceServlet[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
    }
}

