/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html;

import java.net.URLDecoder;
import java.util.Iterator;
import javax.faces.application.Application;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.ValueHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionListener;
import net.sf.retrotranslator.runtime.java.lang.Enum_;
import net.sf.retrotranslator.runtime.java.lang._String;
import net.sf.retrotranslator.runtime.java.util._Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UICommand;
import org.apache.myfaces.tobago.component.UIPopup;
import org.apache.myfaces.tobago.context.ClientProperties;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.event.PopupActionListener;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;

public class CommandRendererHelper {
    private static final Log LOG;
    private String onclick;
    private boolean disabled;
    private String href;
    private String target;
    static /* synthetic */ Class class$org$apache$myfaces$tobago$renderkit$html$CommandRendererHelper;

    public CommandRendererHelper(FacesContext facesContext, javax.faces.component.UICommand component) {
        this.initOnclick(facesContext, component, null);
    }

    public CommandRendererHelper(FacesContext facesContext, javax.faces.component.UICommand component, Tag tag) {
        this.initOnclick(facesContext, component, tag);
    }

    private void initOnclick(FacesContext facesContext, javax.faces.component.UICommand command, Tag tag) {
        this.disabled = ComponentUtil.getBooleanAttribute((UIComponent)command, "disabled");
        this.href = this.getEmptyHref(facesContext);
        if (this.disabled) {
            this.onclick = "";
            this.href = "";
        } else {
            UIPopup popup = (UIPopup)command.getFacet("popup");
            if (popup != null && !ComponentUtil.containsPopupActionListener(command)) {
                command.addActionListener((ActionListener)new PopupActionListener(popup));
            }
            String clientId = command.getClientId(facesContext);
            boolean defaultCommand = ComponentUtil.getBooleanAttribute((UIComponent)command, "defaultCommand");
            boolean transition = ComponentUtil.getBooleanAttribute((UIComponent)command, "transition");
            if (command.getAttributes().get("link") != null || command.getAttributes().get("resource") != null) {
                String url = this.generateUrl(facesContext, (UIComponent)command);
                if (tag == Tag.ANCHOR) {
                    this.onclick = null;
                    this.href = url;
                    this.target = ComponentUtil.getStringAttribute((UIComponent)command, "target");
                } else {
                    this.onclick = "Tobago.navigateToUrl('" + url + "');";
                }
            } else if (command.getAttributes().get("onclick") != null) {
                this.onclick = this.prepareOnClick(facesContext, (UIComponent)command);
            } else if (command instanceof UICommand && ((UICommand)command).getRenderedPartially().length > 0) {
                Object[] componentId = ((UICommand)command).getRenderedPartially();
                if (componentId != null && componentId.length == 1) {
                    boolean popupAction = ComponentUtil.containsPopupActionListener(command);
                    this.onclick = popupAction ? "Tobago.openPopupWithAction2(this, '" + HtmlRendererUtil.getComponentId(facesContext, (UIComponent)command, (String)componentId[0]) + "', '" + clientId + "', null)" : "Tobago.reloadComponent2(this, '" + HtmlRendererUtil.getComponentId(facesContext, (UIComponent)command, (String)componentId[0]) + "','" + clientId + "', {});";
                } else {
                    LOG.error((Object)("more than one partially rendered component is currently not supported " + _Arrays.toString((Object[])componentId)));
                    this.onclick = "Tobago.submitAction2(this, '" + clientId + "', " + transition + ", null);";
                }
            } else if (defaultCommand) {
                ComponentUtil.findPage(facesContext, (UIComponent)command).setDefaultActionId(clientId);
                this.onclick = null;
            } else {
                String target = ComponentUtil.getStringAttribute((UIComponent)command, "target");
                this.onclick = target == null ? "Tobago.submitAction2(this, '" + clientId + "', " + transition + ", null);" : "Tobago.submitAction2(this, '" + clientId + "', " + transition + ", '" + target + "');";
            }
            if (command.getAttributes().get("popupClose") != null && ComponentUtil.isInPopup((UIComponent)command)) {
                String value = (String)command.getAttributes().get("popupClose");
                if (value.equals("immediate")) {
                    this.onclick = "Tobago.closePopup(this);";
                } else if (value.equals("afterSubmit") && command instanceof UICommand && ((UICommand)command).getRenderedPartially().length > 0) {
                    this.onclick = this.onclick + "Tobago.closePopup(this);";
                }
            }
            this.onclick = this.appendConfirmationScript(this.onclick, (UIComponent)command);
        }
    }

    private String getEmptyHref(FacesContext facesContext) {
        ClientProperties clientProperties = ClientProperties.getInstance(facesContext);
        return clientProperties.getUserAgent().isMsie() ? "#" : "javascript:;";
    }

    private String prepareOnClick(FacesContext facesContext, UIComponent component) {
        String onclick = (String)component.getAttributes().get("onclick");
        if (_String.contains((String)onclick, (CharSequence)"@autoId")) {
            onclick = StringUtils.replace((String)onclick, (String)"@autoId", (String)component.getClientId(facesContext));
        }
        return onclick;
    }

    private String appendConfirmationScript(String onclick, UIComponent component) {
        ValueHolder confirmation = (ValueHolder)component.getFacet("confirmation");
        if (confirmation != null) {
            StringBuffer script = new StringBuffer();
            script.append("return confirm('");
            script.append(confirmation.getValue());
            script.append("')");
            if (onclick != null) {
                script.append(" && ");
                script.append(onclick);
            }
            onclick = script.toString();
        }
        return onclick;
    }

    private String generateUrl(FacesContext facesContext, UIComponent component) {
        String url;
        Application application = facesContext.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        ExternalContext externalContext = facesContext.getExternalContext();
        if (component.getAttributes().get("resource") != null) {
            String resource = (String)component.getAttributes().get("resource");
            boolean jsfResource = ComponentUtil.getBooleanAttribute(component, "jsfResource");
            url = ResourceManagerUtil.getPageWithoutContextPath(facesContext, resource);
            if (url != null) {
                if (jsfResource) {
                    url = viewHandler.getActionURL(facesContext, url);
                    url = externalContext.encodeActionURL(url);
                } else {
                    url = viewHandler.getResourceURL(facesContext, url);
                    url = externalContext.encodeResourceURL(url);
                }
            } else {
                url = "";
            }
        } else if (component.getAttributes().get("link") != null) {
            String link = (String)component.getAttributes().get("link");
            url = link.startsWith("/") ? externalContext.encodeResourceURL(externalContext.getRequestContextPath() + link) : (org.apache.myfaces.tobago.util.StringUtils.isUrl(link) ? link : externalContext.encodeResourceURL(link));
            StringBuffer builder = new StringBuffer(url);
            boolean firstParameter = !_String.contains((String)url, (CharSequence)"?");
            Iterator i$ = component.getChildren().iterator();
            while (i$.hasNext()) {
                UIComponent child = (UIComponent)i$.next();
                if (!(child instanceof UIParameter)) continue;
                UIParameter parameter = (UIParameter)child;
                if (firstParameter) {
                    builder.append("?");
                    firstParameter = false;
                } else {
                    builder.append("&");
                }
                builder.append(parameter.getName());
                builder.append("=");
                Object value = parameter.getValue();
                builder.append(value != null ? URLDecoder.decode(value.toString()) : null);
            }
            url = builder.toString();
        } else {
            throw new AssertionError((Object)"Needed link or resource");
        }
        return url;
    }

    public String getOnclick() {
        return this.onclick;
    }

    public String getOnclickDoubleQuoted() {
        return this.onclick.replace('\'', '\"');
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public String getHref() {
        return this.href;
    }

    public String getTarget() {
        return this.target;
    }

    static {
        Class<?> clazz = class$org$apache$myfaces$tobago$renderkit$html$CommandRendererHelper;
        if (clazz == null) {
            clazz = class$org$apache$myfaces$tobago$renderkit$html$CommandRendererHelper = new CommandRendererHelper[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Tag
    extends Enum_<Tag> {
        public static final Tag ANCHOR = new Tag("ANCHOR", 0);
        public static final Tag BUTTON = new Tag("BUTTON", 1);
        private static final /* synthetic */ Tag[] $VALUES;
        static /* synthetic */ Class class$org$apache$myfaces$tobago$renderkit$html$CommandRendererHelper$Tag;

        public static Tag[] values() {
            return (Tag[])$VALUES.clone();
        }

        public static Tag valueOf(String name) {
            Class<?> clazz = class$org$apache$myfaces$tobago$renderkit$html$CommandRendererHelper$Tag;
            if (clazz == null) {
                clazz = class$org$apache$myfaces$tobago$renderkit$html$CommandRendererHelper$Tag = new Tag[0].getClass().getComponentType();
            }
            return (Tag)Enum_.valueOf((Class)clazz, (String)name);
        }

        private Tag() {
            super((String)var1_1, n);
        }

        static {
            $VALUES = new Tag[]{ANCHOR, BUTTON};
            Class<?> clazz = class$org$apache$myfaces$tobago$renderkit$html$CommandRendererHelper$Tag;
            if (clazz == null) {
                clazz = class$org$apache$myfaces$tobago$renderkit$html$CommandRendererHelper$Tag = new Tag[0].getClass().getComponentType();
            }
            Enum_.setEnumConstants((Class)clazz, (Enum_[])Tag.values());
        }
    }
}

