/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit;

import java.io.IOException;
import java.util.Map;
import javax.faces.application.StateManager;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.ResponseStateManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TobagoResponseStateManager
extends ResponseStateManager {
    private static final Log LOG;
    public static final String TREE_PARAM = "jsf_tree";
    private static final String STATE_PARAM = "jsf_state";
    private static final String VIEWID_PARAM = "jsf_viewid";
    static /* synthetic */ Class class$org$apache$myfaces$tobago$renderkit$TobagoResponseStateManager;

    public Object getTreeStructureToRestore(FacesContext facescontext, String viewId) {
        Map requestMap = facescontext.getExternalContext().getRequestParameterMap();
        Object requestViewId = requestMap.get(VIEWID_PARAM);
        if (requestViewId == null || !requestViewId.equals(viewId)) {
            return null;
        }
        return requestMap.get(TREE_PARAM);
    }

    public Object getComponentStateToRestore(FacesContext facesContext) {
        Map requestMap = facesContext.getExternalContext().getRequestParameterMap();
        return requestMap.get(STATE_PARAM);
    }

    public void writeState(FacesContext facesContext, StateManager.SerializedView serializedview) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        Object treeStruct = serializedview.getStructure();
        Object compStates = serializedview.getState();
        if (treeStruct != null) {
            if (treeStruct instanceof String) {
                responseWriter.startElement("input", null);
                responseWriter.writeAttribute("type", (Object)"hidden", null);
                responseWriter.writeAttribute("name", (Object)TREE_PARAM, null);
                responseWriter.writeAttribute("id", (Object)TREE_PARAM, null);
                responseWriter.writeAttribute("value", treeStruct, null);
                responseWriter.endElement("input");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"No tree structure to be saved in client response!");
        }
        if (compStates != null) {
            if (compStates instanceof String) {
                responseWriter.startElement("input", null);
                responseWriter.writeAttribute("type", (Object)"hidden", null);
                responseWriter.writeAttribute("name", (Object)STATE_PARAM, null);
                responseWriter.writeAttribute("id", (Object)STATE_PARAM, null);
                responseWriter.writeAttribute("value", compStates, null);
                responseWriter.endElement("input");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"No component states to be saved in client response!");
        }
        responseWriter.startElement("input", null);
        responseWriter.writeAttribute("type", (Object)"hidden", null);
        responseWriter.writeAttribute("name", (Object)VIEWID_PARAM, null);
        responseWriter.writeAttribute("id", (Object)VIEWID_PARAM, null);
        responseWriter.writeAttribute("value", (Object)facesContext.getViewRoot().getViewId(), null);
        responseWriter.endElement("input");
    }

    static {
        Class<?> clazz = class$org$apache$myfaces$tobago$renderkit$TobagoResponseStateManager;
        if (clazz == null) {
            clazz = class$org$apache$myfaces$tobago$renderkit$TobagoResponseStateManager = new TobagoResponseStateManager[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
    }
}

