/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.lifecycle;

import java.util.ArrayList;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.lifecycle.ApplyRequestValuesExecutor;
import org.apache.myfaces.tobago.lifecycle.InvokeApplicationExecutor;
import org.apache.myfaces.tobago.lifecycle.PhaseExecutor;
import org.apache.myfaces.tobago.lifecycle.PhaseListenerManager;
import org.apache.myfaces.tobago.lifecycle.ProcessValidationsExecutor;
import org.apache.myfaces.tobago.lifecycle.RenderResponseExecutor;
import org.apache.myfaces.tobago.lifecycle.RestoreViewExecutor;
import org.apache.myfaces.tobago.lifecycle.UpdateModelValuesExecutor;
import org.apache.myfaces.tobago.util.RequestUtils;

public class TobagoLifecycle
extends Lifecycle {
    private static final Log LOG;
    public static final String VIEW_ROOT_KEY;
    public static final String FACES_MESSAGES_KEY;
    private PhaseExecutor[] lifecycleExecutors;
    private PhaseExecutor renderExecutor;
    private final List<PhaseListener> phaseListenerList = new ArrayList<PhaseListener>();
    private PhaseListener[] phaseListenerArray = null;
    static /* synthetic */ Class class$org$apache$myfaces$tobago$lifecycle$TobagoLifecycle;

    public TobagoLifecycle() {
        this.lifecycleExecutors = new PhaseExecutor[]{new RestoreViewExecutor(), new ApplyRequestValuesExecutor(), new ProcessValidationsExecutor(), new UpdateModelValuesExecutor(), new InvokeApplicationExecutor()};
        this.renderExecutor = new RenderResponseExecutor();
    }

    public void execute(FacesContext facesContext) throws FacesException {
        PhaseListenerManager phaseListenerMgr = new PhaseListenerManager(this, facesContext, this.getPhaseListeners());
        RequestUtils.ensureEncoding(facesContext);
        PhaseExecutor[] arr$ = this.lifecycleExecutors;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            PhaseExecutor executor = arr$[i$];
            if (!this.executePhase(facesContext, executor, phaseListenerMgr)) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executePhase(FacesContext facesContext, PhaseExecutor executor, PhaseListenerManager phaseListenerMgr) throws FacesException {
        boolean skipFurtherProcessing = false;
        if (LOG.isTraceEnabled()) {
            StringBuffer stringBuffer = new StringBuffer().append("entering ").append(executor.getPhase()).append(" in ");
            Class<?> clazz = class$org$apache$myfaces$tobago$lifecycle$TobagoLifecycle;
            if (clazz == null) {
                clazz = class$org$apache$myfaces$tobago$lifecycle$TobagoLifecycle = new TobagoLifecycle[0].getClass().getComponentType();
            }
            LOG.trace((Object)stringBuffer.append(clazz.getName()).toString());
        }
        try {
            phaseListenerMgr.informPhaseListenersBefore(executor.getPhase());
            if (this.isResponseComplete(facesContext, executor.getPhase(), true)) {
                boolean bl = true;
                return bl;
            }
            if (this.shouldRenderResponse(facesContext, executor.getPhase(), true)) {
                skipFurtherProcessing = true;
            }
            if (executor.execute(facesContext)) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            phaseListenerMgr.informPhaseListenersAfter(executor.getPhase());
        }
        if (this.isResponseComplete(facesContext, executor.getPhase(), false) || this.shouldRenderResponse(facesContext, executor.getPhase(), false)) {
            skipFurtherProcessing = true;
        }
        if (!skipFurtherProcessing && LOG.isTraceEnabled()) {
            StringBuffer stringBuffer = new StringBuffer().append("exiting ").append(executor.getPhase()).append(" in ");
            Class<?> clazz = class$org$apache$myfaces$tobago$lifecycle$TobagoLifecycle;
            if (clazz == null) {
                clazz = class$org$apache$myfaces$tobago$lifecycle$TobagoLifecycle = new TobagoLifecycle[0].getClass().getComponentType();
            }
            LOG.trace((Object)stringBuffer.append(clazz.getName()).toString());
        }
        return skipFurtherProcessing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(FacesContext facesContext) throws FacesException {
        if (this.isResponseComplete(facesContext, this.renderExecutor.getPhase(), true)) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            StringBuffer stringBuffer = new StringBuffer().append("entering ").append(this.renderExecutor.getPhase()).append(" in ");
            Class<?> clazz = class$org$apache$myfaces$tobago$lifecycle$TobagoLifecycle;
            if (clazz == null) {
                clazz = class$org$apache$myfaces$tobago$lifecycle$TobagoLifecycle = new TobagoLifecycle[0].getClass().getComponentType();
            }
            LOG.trace((Object)stringBuffer.append(clazz.getName()).toString());
        }
        PhaseListenerManager phaseListenerMgr = new PhaseListenerManager(this, facesContext, this.getPhaseListeners());
        try {
            phaseListenerMgr.informPhaseListenersBefore(this.renderExecutor.getPhase());
            if (this.isResponseComplete(facesContext, this.renderExecutor.getPhase(), true)) {
                return;
            }
            this.renderExecutor.execute(facesContext);
        }
        finally {
            phaseListenerMgr.informPhaseListenersAfter(this.renderExecutor.getPhase());
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)ComponentUtil.toString((UIComponent)facesContext.getViewRoot(), 0));
        }
        if (LOG.isTraceEnabled()) {
            StringBuffer stringBuffer = new StringBuffer().append("exiting ").append(this.renderExecutor.getPhase()).append(" in ");
            Class<?> clazz = class$org$apache$myfaces$tobago$lifecycle$TobagoLifecycle;
            if (clazz == null) {
                clazz = class$org$apache$myfaces$tobago$lifecycle$TobagoLifecycle = new TobagoLifecycle[0].getClass().getComponentType();
            }
            LOG.trace((Object)stringBuffer.append(clazz.getName()).toString());
        }
    }

    private boolean isResponseComplete(FacesContext facesContext, PhaseId phase, boolean before) {
        boolean flag = false;
        if (facesContext.getResponseComplete()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("exiting from lifecycle.execute in " + phase + " because getResponseComplete is true from one of the " + (before ? "before" : "after") + " listeners"));
            }
            flag = true;
        }
        return flag;
    }

    private boolean shouldRenderResponse(FacesContext facesContext, PhaseId phase, boolean before) {
        boolean flag = false;
        if (facesContext.getRenderResponse()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("exiting from lifecycle.execute in " + phase + " because getRenderResponse is true from one of the " + (before ? "before" : "after") + " listeners"));
            }
            flag = true;
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPhaseListener(PhaseListener phaseListener) {
        if (phaseListener == null) {
            throw new NullPointerException("PhaseListener must not be null.");
        }
        List<PhaseListener> list = this.phaseListenerList;
        synchronized (list) {
            this.phaseListenerList.add(phaseListener);
            this.phaseListenerArray = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePhaseListener(PhaseListener phaseListener) {
        if (phaseListener == null) {
            throw new NullPointerException("PhaseListener must not be null.");
        }
        List<PhaseListener> list = this.phaseListenerList;
        synchronized (list) {
            this.phaseListenerList.remove(phaseListener);
            this.phaseListenerArray = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PhaseListener[] getPhaseListeners() {
        List<PhaseListener> list = this.phaseListenerList;
        synchronized (list) {
            if (this.phaseListenerArray == null) {
                this.phaseListenerArray = this.phaseListenerList.toArray(new PhaseListener[this.phaseListenerList.size()]);
            }
            return this.phaseListenerArray;
        }
    }

    static {
        Class<?> clazz = class$org$apache$myfaces$tobago$lifecycle$TobagoLifecycle;
        if (clazz == null) {
            clazz = class$org$apache$myfaces$tobago$lifecycle$TobagoLifecycle = new TobagoLifecycle[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
        StringBuffer stringBuffer = new StringBuffer();
        Class<?> clazz2 = class$org$apache$myfaces$tobago$lifecycle$TobagoLifecycle;
        if (clazz2 == null) {
            clazz2 = class$org$apache$myfaces$tobago$lifecycle$TobagoLifecycle = new TobagoLifecycle[0].getClass().getComponentType();
        }
        VIEW_ROOT_KEY = stringBuffer.append(clazz2.getName()).append(".VIEW_ROOT_KEY").toString();
        StringBuffer stringBuffer2 = new StringBuffer();
        Class<?> clazz3 = class$org$apache$myfaces$tobago$lifecycle$TobagoLifecycle;
        if (clazz3 == null) {
            clazz3 = class$org$apache$myfaces$tobago$lifecycle$TobagoLifecycle = new TobagoLifecycle[0].getClass().getComponentType();
        }
        FACES_MESSAGES_KEY = stringBuffer2.append(clazz3.getName()).append(".FACES_MESSAGES_KEY").toString();
    }
}

