/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.context.ClientProperties;
import org.apache.myfaces.tobago.context.ResourceManagerImpl;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIViewRoot
extends javax.faces.component.UIViewRoot {
    private static final Log LOG;
    private static final String EVENT_LIST_KEY;
    public static final int ANY_PHASE_ORDINAL;
    private ResourceManagerImpl.CacheKey rendererCacheKey;
    private ClientProperties clientProperties;
    static /* synthetic */ Class class$org$apache$myfaces$tobago$component$UIViewRoot;

    public UIViewRoot() {
        this.updateRendererCachePrefix();
    }

    public ClientProperties getClientProperties() {
        return this.clientProperties;
    }

    public void setClientProperties(ClientProperties clientProperties) {
        this.clientProperties = clientProperties;
        this.updateRendererCachePrefix();
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.updateRendererCachePrefix();
    }

    public ResourceManagerImpl.CacheKey getRendererCacheKey() {
        return this.rendererCacheKey;
    }

    public void updateRendererCachePrefix() {
        this.rendererCacheKey = ResourceManagerImpl.getRendererCacheKey(this.clientProperties != null ? this.clientProperties.getId() : "null", this.getLocale());
    }

    public void broadcastEventsForPhase(FacesContext context, PhaseId phaseId) {
        this.broadcastForPhase(phaseId);
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents(context);
        }
    }

    public void queueEvent(FacesEvent event) {
        if (event == null) {
            throw new NullPointerException("event");
        }
        this.getEvents(FacesContext.getCurrentInstance(), true).add(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastForPhase(PhaseId phaseId) {
        List<FacesEvent> events = this.getEvents(FacesContext.getCurrentInstance(), false);
        if (events == null) {
            return;
        }
        boolean abort = false;
        int phaseIdOrdinal = phaseId.getOrdinal();
        ListIterator<FacesEvent> listiterator = events.listIterator();
        while (listiterator.hasNext()) {
            FacesEvent event = listiterator.next();
            int ordinal = event.getPhaseId().getOrdinal();
            if (ordinal != ANY_PHASE_ORDINAL && ordinal != phaseIdOrdinal) continue;
            UIComponent source = event.getComponent();
            try {
                source.broadcast(event);
            }
            catch (FacesException e) {
                for (Throwable fe = e; fe != null; fe = fe.getCause()) {
                    if (!(fe instanceof AbortProcessingException)) continue;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)"AbortProcessingException caught!");
                    }
                    abort = true;
                    break;
                }
                if (abort) break;
                throw e;
            }
            finally {
                listiterator.remove();
            }
        }
        if (abort) {
            this.clearEvents(FacesContext.getCurrentInstance());
        }
    }

    private void clearEvents(FacesContext context) {
        context.getExternalContext().getRequestMap().remove(EVENT_LIST_KEY);
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        super.processDecodes(context);
        this.broadcastForPhase(PhaseId.APPLY_REQUEST_VALUES);
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents(context);
        }
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        super.processValidators(context);
        this.broadcastForPhase(PhaseId.PROCESS_VALIDATIONS);
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents(context);
        }
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        super.processUpdates(context);
        this.broadcastForPhase(PhaseId.UPDATE_MODEL_VALUES);
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents(context);
        }
    }

    public void processApplication(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.broadcastForPhase(PhaseId.INVOKE_APPLICATION);
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents(context);
        }
    }

    private List<FacesEvent> getEvents(FacesContext context, boolean create) {
        Map requestMap = context.getExternalContext().getRequestMap();
        ArrayList events = (ArrayList)requestMap.get(EVENT_LIST_KEY);
        if (events == null && create) {
            events = new ArrayList();
            requestMap.put(EVENT_LIST_KEY, events);
        }
        return events;
    }

    static {
        Class<?> clazz = class$org$apache$myfaces$tobago$component$UIViewRoot;
        if (clazz == null) {
            clazz = class$org$apache$myfaces$tobago$component$UIViewRoot = new UIViewRoot[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
        StringBuffer stringBuffer = new StringBuffer();
        Class<?> clazz2 = class$org$apache$myfaces$tobago$component$UIViewRoot;
        if (clazz2 == null) {
            clazz2 = class$org$apache$myfaces$tobago$component$UIViewRoot = new UIViewRoot[0].getClass().getComponentType();
        }
        EVENT_LIST_KEY = stringBuffer.append(clazz2.getName()).append(".EventList").toString();
        ANY_PHASE_ORDINAL = PhaseId.ANY_PHASE.getOrdinal();
    }
}

