/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import net.sf.retrotranslator.runtime.java.lang._Integer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.ajax.api.AjaxComponent;
import org.apache.myfaces.tobago.ajax.api.AjaxUtils;
import org.apache.myfaces.tobago.component.UILayout;
import org.apache.myfaces.tobago.component.UIPanelBase;
import org.apache.myfaces.tobago.component.UITab;
import org.apache.myfaces.tobago.event.TabChangeEvent;
import org.apache.myfaces.tobago.event.TabChangeListener;
import org.apache.myfaces.tobago.event.TabChangeSource;

public class UITabGroup
extends UIPanelBase
implements TabChangeSource,
AjaxComponent {
    private static final Log LOG;
    public static final String COMPONENT_TYPE = "org.apache.myfaces.tobago.TabGroup";
    private Integer selectedIndex;
    private int renderedIndex;
    private String switchType;
    private Boolean immediate;
    private Boolean showNavigationBar;
    private MethodBinding tabChangeListener = null;
    public static final String SWITCH_TYPE_CLIENT = "client";
    public static final String SWITCH_TYPE_RELOAD_PAGE = "reloadPage";
    public static final String SWITCH_TYPE_RELOAD_TAB = "reloadTab";
    static /* synthetic */ Class class$org$apache$myfaces$tobago$event$TabChangeListener;
    static /* synthetic */ Class class$org$apache$myfaces$tobago$component$UITabGroup;

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext facesContext) throws IOException {
        super.encodeBegin(facesContext);
        if (SWITCH_TYPE_CLIENT.equals(this.switchType)) {
            Iterator i$ = this.getChildren().iterator();
            while (i$.hasNext()) {
                UIComponent tab = (UIComponent)i$.next();
                if (!(tab instanceof UITab)) continue;
                UILayout.getLayout(tab).layoutBegin(facesContext, tab);
            }
        } else {
            UIPanelBase tab = this.getRenderedTab();
            UILayout.getLayout((UIComponent)tab).layoutBegin(facesContext, (UIComponent)tab);
        }
    }

    public void setImmediate(boolean immediate) {
        this.immediate = immediate;
    }

    public boolean isImmediate() {
        if (this.immediate != null) {
            return this.immediate;
        }
        ValueBinding vb = this.getValueBinding("immediate");
        if (vb != null) {
            return !Boolean.FALSE.equals(vb.getValue(this.getFacesContext()));
        }
        return false;
    }

    public boolean isShowNavigationBar() {
        if (this.showNavigationBar != null) {
            return this.showNavigationBar;
        }
        ValueBinding vb = this.getValueBinding("showNavigationBar");
        if (vb != null) {
            return !Boolean.FALSE.equals(vb.getValue(this.getFacesContext()));
        }
        return true;
    }

    public void setShowNavigationBar(boolean showNavigationBar) {
        this.showNavigationBar = showNavigationBar;
    }

    public void queueEvent(FacesEvent event) {
        if (this == event.getSource()) {
            if (this.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
        super.queueEvent(event);
    }

    public void encodeChildren(FacesContext context) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext) throws IOException {
        this.resetTabLayout();
        super.encodeEnd(facesContext);
        this.setRenderedIndex(this.getSelectedIndex());
    }

    private void resetTabLayout() {
        Iterator i$ = this.getChildren().iterator();
        while (i$.hasNext()) {
            UIComponent component = (UIComponent)i$.next();
            component.getAttributes().remove("layoutWidth");
            component.getAttributes().remove("layoutHeight");
        }
    }

    public UIPanelBase[] getTabs() {
        ArrayList<UIPanelBase> tabs = new ArrayList<UIPanelBase>();
        Iterator i$ = this.getChildren().iterator();
        while (i$.hasNext()) {
            Object o = i$.next();
            UIComponent kid = (UIComponent)o;
            if (kid instanceof UIPanelBase) {
                tabs.add((UIPanelBase)kid);
                continue;
            }
            LOG.error((Object)("Invalid component in UITabGroup: " + kid));
        }
        return tabs.toArray(new UIPanelBase[tabs.size()]);
    }

    public UIPanelBase getActiveTab() {
        return this.getTab(this.getSelectedIndex());
    }

    public void processDecodes(FacesContext context) {
        if (!this.isClientType()) {
            if (context == null) {
                throw new NullPointerException("context");
            }
            if (!this.isRendered()) {
                return;
            }
            UIPanelBase renderedTab = this.getRenderedTab();
            renderedTab.processDecodes(context);
            Iterator i$ = this.getFacets().values().iterator();
            while (i$.hasNext()) {
                UIComponent facet = (UIComponent)i$.next();
                facet.processDecodes(context);
            }
            try {
                this.decode(context);
            }
            catch (RuntimeException e) {
                context.renderResponse();
                throw e;
            }
        } else {
            super.processDecodes(context);
        }
    }

    public void processValidators(FacesContext context) {
        if (!this.isClientType()) {
            if (context == null) {
                throw new NullPointerException("context");
            }
            if (!this.isRendered()) {
                return;
            }
            UIPanelBase renderedTab = this.getRenderedTab();
            renderedTab.processValidators(context);
            Iterator i$ = this.getFacets().values().iterator();
            while (i$.hasNext()) {
                UIComponent facet = (UIComponent)i$.next();
                facet.processValidators(context);
            }
        } else {
            super.processValidators(context);
        }
    }

    public void processUpdates(FacesContext context) {
        if (!this.isClientType()) {
            if (context == null) {
                throw new NullPointerException("context");
            }
            if (!this.isRendered()) {
                return;
            }
            UIPanelBase renderedTab = this.getRenderedTab();
            renderedTab.processUpdates(context);
            Iterator i$ = this.getFacets().values().iterator();
            while (i$.hasNext()) {
                UIComponent facet = (UIComponent)i$.next();
                facet.processUpdates(context);
            }
        } else {
            super.processUpdates(context);
        }
    }

    public void broadcast(FacesEvent facesEvent) throws AbortProcessingException {
        super.broadcast(facesEvent);
        if (facesEvent instanceof TabChangeEvent && facesEvent.getComponent() == this) {
            MethodBinding tabChangeListenerBinding = this.getTabChangeListener();
            if (tabChangeListenerBinding != null) {
                try {
                    tabChangeListenerBinding.invoke(this.getFacesContext(), new Object[]{facesEvent});
                }
                catch (EvaluationException e) {
                    Throwable cause = e.getCause();
                    if (cause != null && cause instanceof AbortProcessingException) {
                        throw (AbortProcessingException)cause;
                    }
                    throw e;
                }
            }
            Integer index = _Integer.valueOf((int)((TabChangeEvent)facesEvent).getNewTabIndex());
            ValueBinding vb = this.getValueBinding("selectedIndex");
            if (vb != null) {
                vb.setValue(this.getFacesContext(), (Object)index);
            } else {
                this.setSelectedIndex(index);
            }
            this.getFacesContext().renderResponse();
        }
    }

    public void setTabChangeListener(MethodBinding tabStateChangeListener) {
        this.tabChangeListener = tabStateChangeListener;
    }

    public MethodBinding getTabChangeListener() {
        return this.tabChangeListener;
    }

    public void addTabChangeListener(TabChangeListener listener) {
        if (LOG.isWarnEnabled() && this.isClientType()) {
            LOG.warn((Object)"Adding TabChangeListener to Client side Tabgroup!");
        }
        this.addFacesListener(listener);
    }

    private boolean isClientType() {
        return this.switchType == null || this.switchType.equals(SWITCH_TYPE_CLIENT);
    }

    public void removeTabChangeListener(TabChangeListener listener) {
        this.removeFacesListener(listener);
    }

    public TabChangeListener[] getTabChangeListeners() {
        Class<?> clazz = class$org$apache$myfaces$tobago$event$TabChangeListener;
        if (clazz == null) {
            clazz = class$org$apache$myfaces$tobago$event$TabChangeListener = new TabChangeListener[0].getClass().getComponentType();
        }
        return (TabChangeListener[])this.getFacesListeners(clazz);
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{super.saveState(context), _Integer.valueOf((int)this.renderedIndex), this.selectedIndex, UITabGroup.saveAttachedState((FacesContext)context, (Object)this.tabChangeListener), this.switchType, this.immediate, this.showNavigationBar};
        return state;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.renderedIndex = (Integer)values[1];
        this.selectedIndex = (Integer)values[2];
        this.tabChangeListener = (MethodBinding)UITabGroup.restoreAttachedState((FacesContext)context, (Object)values[3]);
        this.switchType = (String)values[4];
        this.immediate = (Boolean)values[5];
        this.showNavigationBar = (Boolean)values[6];
    }

    public void encodeAjax(FacesContext facesContext) throws IOException {
        this.setRenderedIndex(this.getSelectedIndex());
        AjaxUtils.encodeAjaxComponent(facesContext, (UIComponent)this);
    }

    public int getSelectedIndex() {
        Integer value;
        if (this.selectedIndex != null) {
            return this.selectedIndex;
        }
        ValueBinding vb = this.getValueBinding("selectedIndex");
        if (vb != null && (value = (Integer)vb.getValue(this.getFacesContext())) != null) {
            return value;
        }
        return 0;
    }

    public void setSelectedIndex(int selectedIndex) {
        this.selectedIndex = _Integer.valueOf((int)selectedIndex);
    }

    private void setRenderedIndex(int index) {
        this.renderedIndex = index;
    }

    public int getRenderedIndex() {
        return this.renderedIndex;
    }

    public String getSwitchType() {
        String value = null;
        if (this.switchType != null) {
            value = this.switchType;
        } else {
            ValueBinding vb = this.getValueBinding("switchType");
            if (vb != null) {
                value = (String)vb.getValue(FacesContext.getCurrentInstance());
            }
        }
        if (SWITCH_TYPE_CLIENT.equals(value) || SWITCH_TYPE_RELOAD_PAGE.equals(value) || SWITCH_TYPE_RELOAD_TAB.equals(value)) {
            return value;
        }
        if (value == null) {
            return SWITCH_TYPE_CLIENT;
        }
        LOG.warn((Object)("Illegal value for attribute switchtype : " + this.switchType + " Using default value " + SWITCH_TYPE_CLIENT));
        return SWITCH_TYPE_CLIENT;
    }

    public void setSwitchType(String switchType) {
        this.switchType = switchType;
    }

    private UIPanelBase getTab(int index) {
        int i = 0;
        Iterator i$ = this.getChildren().iterator();
        while (i$.hasNext()) {
            UIComponent component = (UIComponent)i$.next();
            if (component instanceof UIPanelBase) {
                if (i == index) {
                    return (UIPanelBase)component;
                }
                ++i;
                continue;
            }
            LOG.error((Object)("Invalid component in UITabGroup: " + component));
        }
        LOG.error((Object)("Found no component with index: " + index + " childCount: " + this.getChildCount()));
        return null;
    }

    private UIPanelBase getRenderedTab() {
        return this.getTab(this.getRenderedIndex());
    }

    static {
        Class<?> clazz = class$org$apache$myfaces$tobago$component$UITabGroup;
        if (clazz == null) {
            clazz = class$org$apache$myfaces$tobago$component$UITabGroup = new UITabGroup[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
    }
}

