/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.LayoutTokens;
import org.apache.myfaces.tobago.component.UILayout;
import org.apache.myfaces.tobago.util.LayoutUtil;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIGridLayout
extends UILayout {
    private static final Log LOG;
    public static final String COMPONENT_TYPE = "org.apache.myfaces.tobago.GridLayout";
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.tobago.GridLayout";
    public static final Marker FREE;
    public static final String USED = "used";
    private String border;
    private String cellspacing;
    private String margin;
    private String marginTop;
    private String marginRight;
    private String marginBottom;
    private String marginLeft;
    private String columns;
    private String rows;
    private boolean ignoreFree;
    private transient LayoutTokens columnLayout;
    private transient LayoutTokens rowLayout;
    private List<Row> layoutRows;
    static /* synthetic */ Class class$org$apache$myfaces$tobago$component$UIGridLayout;

    public LayoutTokens getRowLayout() {
        if (this.rowLayout == null) {
            this.rowLayout = LayoutTokens.parse(this.getRows());
        }
        return this.rowLayout;
    }

    public LayoutTokens getColumnLayout() {
        if (this.columnLayout == null) {
            this.columnLayout = LayoutTokens.parse(this.getColumns());
        }
        return this.columnLayout;
    }

    public String getMarginTop() {
        if (this.marginTop != null) {
            return this.marginTop;
        }
        ValueBinding vb = this.getValueBinding("marginTop");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext());
        }
        return this.getMargin();
    }

    public String getMarginRight() {
        if (this.marginRight != null) {
            return this.marginRight;
        }
        ValueBinding vb = this.getValueBinding("marginRight");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext());
        }
        return this.getMargin();
    }

    public String getMarginBottom() {
        if (this.marginBottom != null) {
            return this.marginBottom;
        }
        ValueBinding vb = this.getValueBinding("marginBottom");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext());
        }
        return this.getMargin();
    }

    public String getMarginLeft() {
        if (this.marginLeft != null) {
            return this.marginLeft;
        }
        ValueBinding vb = this.getValueBinding("marginLeft");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext());
        }
        return this.getMargin();
    }

    public String getMargin() {
        if (this.margin != null) {
            return this.margin;
        }
        ValueBinding vb = this.getValueBinding("margin");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext());
        }
        return this.margin;
    }

    public String getRows() {
        if (this.rows != null) {
            return this.rows;
        }
        ValueBinding vb = this.getValueBinding("rows");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext());
        }
        return "1*";
    }

    public String getColumns() {
        if (this.columns != null) {
            return this.columns;
        }
        ValueBinding vb = this.getValueBinding("columns");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext());
        }
        return "1*";
    }

    public String getCellspacing() {
        if (this.cellspacing != null) {
            return this.cellspacing;
        }
        ValueBinding vb = this.getValueBinding("cellspacing");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext());
        }
        return this.cellspacing;
    }

    public String getBorder() {
        if (this.border != null) {
            return this.border;
        }
        ValueBinding vb = this.getValueBinding("border");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext());
        }
        return this.border;
    }

    public void setBorder(String border) {
        this.border = border;
    }

    public void setCellspacing(String cellspacing) {
        this.cellspacing = cellspacing;
    }

    public void setMargin(String margin) {
        this.margin = margin;
    }

    public void setMarginTop(String marginTop) {
        this.marginTop = marginTop;
    }

    public void setMarginRight(String marginRight) {
        this.marginRight = marginRight;
    }

    public void setMarginBottom(String marginBottom) {
        this.marginBottom = marginBottom;
    }

    public void setMarginLeft(String marginLeft) {
        this.marginLeft = marginLeft;
    }

    public void setColumns(String columns) {
        this.columns = columns;
    }

    public void setRows(String rows) {
        this.rows = rows;
    }

    public Object saveState(FacesContext context) {
        this.clearRows();
        this.columnLayout = null;
        this.rowLayout = null;
        Object[] saveState = new Object[]{super.saveState(context), this.rows, this.columns, this.margin, this.marginLeft, this.marginRight, this.marginTop, this.marginBottom, this.border, this.cellspacing};
        return saveState;
    }

    public void restoreState(FacesContext context, Object savedState) {
        Object[] values = (Object[])savedState;
        super.restoreState(context, values[0]);
        this.rows = (String)values[1];
        this.columns = (String)values[2];
        this.margin = (String)values[3];
        this.marginLeft = (String)values[4];
        this.marginRight = (String)values[5];
        this.marginTop = (String)values[6];
        this.marginBottom = (String)values[7];
        this.border = (String)values[8];
        this.cellspacing = (String)values[9];
    }

    public String getFamily() {
        return "org.apache.myfaces.tobago.GridLayout";
    }

    public boolean getRendersChildren() {
        return false;
    }

    public void encodeChildren(FacesContext context) throws IOException {
    }

    @Override
    public void encodeChildrenOfComponent(FacesContext facesContext, UIComponent component) throws IOException {
        super.encodeChildrenOfComponent(facesContext, component);
        this.clearRows();
        this.columnLayout = null;
        this.rowLayout = null;
    }

    private void clearRows() {
        this.layoutRows = null;
    }

    public int getColumnCount() {
        return this.getColumnLayout().getSize();
    }

    public List<Row> ensureRows() {
        if (this.layoutRows == null) {
            this.layoutRows = this.createRows();
        }
        return this.layoutRows;
    }

    private List<Row> createRows() {
        ArrayList<Row> rows = new ArrayList<Row>();
        int columnCount = this.getColumnCount();
        List<UIComponent> children = LayoutUtil.addChildren(new ArrayList<UIComponent>(), this.getParent());
        for (UIComponent component : children) {
            int spanX = UIGridLayout.getSpanX(component);
            int spanY = UIGridLayout.getSpanY(component);
            int r = this.nextFreeRow(rows);
            if (r == rows.size()) {
                rows.add(new Row(columnCount));
            }
            int c = ((Row)rows.get(r)).nextFreeColumn();
            ((Row)rows.get(r)).addControl(component, spanX);
            ((Row)rows.get(r)).fill(c + 1, c + spanX, component.isRendered());
            for (int i = r + 1; i < r + spanY; ++i) {
                if (i == rows.size()) {
                    rows.add(new Row(columnCount));
                }
                ((Row)rows.get(i)).fill(c, c + spanX, component.isRendered());
            }
        }
        return rows;
    }

    private int nextFreeRow(List rows) {
        int i;
        for (i = 0; i < rows.size(); ++i) {
            if (((Row)rows.get(i)).nextFreeColumn() == -1) continue;
            return i;
        }
        return i;
    }

    public static int getSpanX(UIComponent component) {
        return ComponentUtil.getIntAttribute(component, "spanX", 1);
    }

    public static int getSpanY(UIComponent component) {
        return ComponentUtil.getIntAttribute(component, "spanY", 1);
    }

    public boolean isIgnoreFree() {
        return this.ignoreFree;
    }

    public void setIgnoreFree(boolean ignoreFree) {
        this.ignoreFree = ignoreFree;
    }

    static {
        Class<?> clazz = class$org$apache$myfaces$tobago$component$UIGridLayout;
        if (clazz == null) {
            clazz = class$org$apache$myfaces$tobago$component$UIGridLayout = new UIGridLayout[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
        FREE = new Marker("free");
    }

    public static class Marker
    implements Serializable {
        private static final long serialVersionUID = 2505999420762504893L;
        private final String name;
        private boolean rendered;

        private Marker(String name) {
            this.name = name;
        }

        public Marker(String name, boolean rendered) {
            this.name = name;
            this.rendered = rendered;
        }

        public String toString() {
            return this.name;
        }

        public boolean isRendered() {
            return this.rendered;
        }
    }

    public static class Row
    implements Serializable {
        private static final long serialVersionUID = 1511693677519052045L;
        private int columns;
        private List cells;
        private boolean hidden;

        public Row(int columns) {
            this.setColumns(columns);
        }

        private void addControl(UIComponent component, int spanX) {
            int i = this.nextFreeColumn();
            this.cells.set(i, component);
            this.fill(i + 1, i + spanX, component.isRendered());
        }

        private void fill(int start, int end, boolean rendered) {
            if (end > this.columns) {
                LOG.error((Object)"Error in Jsp (end > columns). Try to insert more spanX as possible.");
                LOG.error((Object)("start:   " + start));
                LOG.error((Object)("end:     " + end));
                LOG.error((Object)("columns: " + this.columns));
                LOG.error((Object)"Actual cells:");
                Iterator i$ = this.cells.iterator();
                while (i$.hasNext()) {
                    Object component = i$.next();
                    if (component instanceof UIComponent) {
                        LOG.error((Object)("Cell-ID: " + ((UIComponent)component).getId() + " " + ((UIComponent)component).getRendererType()));
                        continue;
                    }
                    LOG.error((Object)("Cell:    " + component));
                }
                end = this.columns;
            }
            for (int i = start; i < end; ++i) {
                this.cells.set(i, new Marker(UIGridLayout.USED, rendered));
            }
        }

        private int nextFreeColumn() {
            for (int i = 0; i < this.columns; ++i) {
                if (!FREE.equals(this.cells.get(i))) continue;
                return i;
            }
            return -1;
        }

        public List getElements() {
            return this.cells;
        }

        public int getColumns() {
            return this.columns;
        }

        private void setColumns(int columns) {
            this.columns = columns;
            this.cells = new ArrayList(columns);
            for (int i = 0; i < columns; ++i) {
                this.cells.add(FREE);
            }
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public void setHidden(boolean hidden) {
            this.hidden = hidden;
        }
    }
}

