/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.ajax.api;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.ajax.api.AjaxUtils;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.util.FastStringWriter;
import org.apache.myfaces.tobago.util.RequestUtils;
import org.apache.myfaces.tobago.util.ResponseUtils;

public class AjaxPhaseListener
implements PhaseListener {
    private static final Log LOG;
    public static final String AJAX_COMPONENT_ID = "affectedAjaxComponent";
    public static final String CODE_SUCCESS = "<status code=\"200\"/>";
    public static final String CODE_NOT_MODIFIED = "<status code=\"304\"/>";
    public static final String CODE_RELOAD_REQUIRED = "<status code=\"309\"/>";
    public static final String TOBAGO_AJAX_STATUS_CODE = "org.apache.myfaces.tobago.StatusCode";
    static /* synthetic */ Class class$org$apache$myfaces$tobago$ajax$api$AjaxPhaseListener;

    public static Object getValueForComponent(FacesContext facesContext, UIComponent component) {
        String possibleClientId = component.getClientId(facesContext);
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        if (requestParameterMap.containsKey(possibleClientId)) {
            return requestParameterMap.get(possibleClientId);
        }
        possibleClientId = (String)requestParameterMap.get(AJAX_COMPONENT_ID);
        UIViewRoot root = facesContext.getViewRoot();
        UIComponent ajaxComponent = root.findComponent(possibleClientId);
        if (ajaxComponent == component) {
            return requestParameterMap.get(possibleClientId);
        }
        LOG.error((Object)("No value found for this component : " + possibleClientId));
        return null;
    }

    public void afterPhase(PhaseEvent event) {
        if (event.getPhaseId().getOrdinal() != PhaseId.APPLY_REQUEST_VALUES.getOrdinal()) {
            return;
        }
        FacesContext facesContext = event.getFacesContext();
        ExternalContext externalContext = facesContext.getExternalContext();
        if (externalContext.getRequestParameterMap().containsKey(AJAX_COMPONENT_ID)) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("AJAX: componentID found :" + externalContext.getRequestParameterMap().get(AJAX_COMPONENT_ID)));
                }
                RequestUtils.ensureEncoding(facesContext);
                ResponseUtils.ensureNoCacheHeader(externalContext);
                UIViewRoot viewRoot = facesContext.getViewRoot();
                FastStringWriter content = new FastStringWriter(10240);
                RenderKitFactory renderFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
                RenderKit renderKit = renderFactory.getRenderKit(facesContext, viewRoot.getRenderKitId());
                ResponseWriter contentWriter = renderKit.createResponseWriter((Writer)content, null, null);
                facesContext.setResponseWriter(contentWriter);
                AjaxUtils.processAjax(facesContext, (UIComponent)viewRoot);
                FastStringWriter jsfState = new FastStringWriter();
                ResponseWriter jsfStateWriter = contentWriter.cloneWithWriter((Writer)jsfState);
                facesContext.setResponseWriter(jsfStateWriter);
                StateManager stateManager = facesContext.getApplication().getStateManager();
                StateManager.SerializedView serializedView = stateManager.saveSerializedView(facesContext);
                stateManager.writeState(facesContext, serializedView);
                String stateValue = jsfState.toString();
                if (stateValue.length() > 0) {
                    contentWriter.startElement("script", null);
                    contentWriter.writeAttribute("type", (Object)"text/javascript", null);
                    contentWriter.flush();
                    contentWriter.write("Tobago.replaceJsfState(\"");
                    contentWriter.write(StringUtils.replace((String)StringUtils.replace((String)stateValue, (String)"\"", (String)"\\\""), (String)"\n", (String)""));
                    contentWriter.write("\");");
                    contentWriter.endElement("script");
                }
                this.writeAjaxResponse(facesContext, content.toString());
                facesContext.responseComplete();
            }
            catch (IOException e) {
                LOG.error((Object)"Exception while processing Ajax", (Throwable)e);
            }
        }
    }

    private void writeAjaxResponse(FacesContext facesContext, String content) throws IOException {
        ExternalContext externalContext = facesContext.getExternalContext();
        StringBuffer buf = new StringBuffer(content);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Size of AjaxResponse:\n" + buf.length() + " = 0x" + Integer.toHexString(buf.length())));
        }
        if (facesContext.getExternalContext().getRequestMap().containsKey(TOBAGO_AJAX_STATUS_CODE)) {
            buf.insert(0, facesContext.getExternalContext().getRequestMap().get(TOBAGO_AJAX_STATUS_CODE));
        } else {
            buf.insert(0, CODE_SUCCESS);
        }
        buf.insert(0, Integer.toHexString(buf.length()) + "\r\n");
        buf.append("\r\n0\r\n\r\n");
        if (externalContext.getResponse() instanceof HttpServletResponse) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)externalContext.getResponse();
            httpServletResponse.addHeader("Transfer-Encoding", "chunked");
            PrintWriter responseWriter = httpServletResponse.getWriter();
            responseWriter.print(buf.toString());
            responseWriter.flush();
            responseWriter.close();
        }
    }

    public void beforePhase(PhaseEvent event) {
        if (event.getPhaseId().getOrdinal() != PhaseId.RENDER_RESPONSE.getOrdinal()) {
            return;
        }
        try {
            FacesContext facesContext = event.getFacesContext();
            ExternalContext externalContext = facesContext.getExternalContext();
            Map requestParameterMap = externalContext.getRequestParameterMap();
            if (requestParameterMap.containsKey(AJAX_COMPONENT_ID)) {
                LOG.error((Object)"Ignoring AjaxRequest without valid component tree!");
                String message = ResourceManagerUtil.getPropertyNotNull(facesContext, "tobago", "tobago.ajax.response.error");
                this.writeAjaxResponse(facesContext, message);
                facesContext.responseComplete();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Exception while processing Ajax", (Throwable)e);
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    static {
        Class<?> clazz = class$org$apache$myfaces$tobago$ajax$api$AjaxPhaseListener;
        if (clazz == null) {
            clazz = class$org$apache$myfaces$tobago$ajax$api$AjaxPhaseListener = new AjaxPhaseListener[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
    }
}

