/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.component.UITreeListbox;
import org.apache.myfaces.tobago.component.UITreeOldNode;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag.TreeOldRenderer;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class TreeListboxRenderer
extends TreeOldRenderer {
    private static final Log LOG = LogFactory.getLog(TreeListboxRenderer.class);

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        UITreeListbox tree = (UITreeListbox)component;
        tree.createSelectionPath();
        String clientId = tree.getClientId(facesContext);
        UITreeOldNode root = tree.getRoot();
        UIPage page = ComponentUtil.findPage((FacesContext)facesContext, (UIComponent)tree);
        if (LOG.isDebugEnabled()) {
            page.getOnloadScripts().add("tbgTreeStates('" + clientId + "')");
        }
        TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter((FacesContext)facesContext);
        writer.startElement("div", (UIComponent)tree);
        writer.writeClassAttribute();
        writer.writeStyleAttribute();
        StringBuilder value = new StringBuilder(";");
        List expandPath = tree.getExpandPath();
        for (UITreeOldNode node : expandPath) {
            value.append(this.nodeStateId(facesContext, node));
            value.append(";");
        }
        writer.startElement("input", (UIComponent)tree);
        writer.writeAttribute("type", "hidden", false);
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(clientId);
        writer.writeAttribute("value", value.toString(), true);
        writer.endElement("input");
        Set selection = tree.getState().getSelection();
        value = new StringBuilder(";");
        for (DefaultMutableTreeNode node : selection) {
            value.append(this.nodeStateId(facesContext, tree.findUITreeNode(root, (TreeNode)node)));
            value.append(";");
        }
        writer.startElement("input", (UIComponent)tree);
        writer.writeAttribute("type", "hidden", false);
        writer.writeNameAttribute(clientId + "-selectState");
        writer.writeIdAttribute(clientId + "-selectState");
        writer.writeAttribute("value", value.toString(), true);
        writer.endElement("input");
        String scriptText = this.createJavascript(facesContext, clientId, tree, root);
        String[] scripts = new String[]{"script/tree.js"};
        List scriptFiles = ComponentUtil.findPage((FacesContext)facesContext, (UIComponent)tree).getScriptFiles();
        for (String script : scripts) {
            scriptFiles.add(script);
        }
        if (!TobagoConfig.getInstance((FacesContext)facesContext).isAjaxEnabled()) {
            writer.writeJavascript(scriptText);
        } else {
            HtmlRendererUtil.writeScriptLoader((FacesContext)facesContext, (String[])scripts, (String[])new String[]{scriptText.replace('\n', ' ')});
        }
    }

    private String createJavascript(FacesContext facesContext, String clientId, UITreeListbox tree, UITreeOldNode root) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        sb.append("  var treeResourcesHelp = new Object();\n");
        sb.append("  treeResourcesHelp.getImage = function (name) {\n");
        sb.append("    return \"");
        sb.append(ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)"image/blank.gif"));
        sb.append("\";\n");
        sb.append("  };;\n");
        sb.append(this.getTreeNodeCommandVar(facesContext, (UIComponent)tree));
        sb.append(this.getNodesAsJavascript(facesContext, root));
        sb.append("  var hidden =   document.getElementById('");
        sb.append(clientId);
        sb.append("'); \n");
        sb.append("  hidden.rootNode = ");
        String rootNode = TreeListboxRenderer.createJavascriptVariable(root.getClientId(facesContext));
        sb.append(rootNode);
        sb.append(";\n");
        sb.append("}\n");
        return sb.toString();
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.endElement("div");
    }
}

