/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.DateTimeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.component.UITimeInput;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.renderkit.InputRendererBase;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.renderkit.html.StyleClasses;
import org.apache.myfaces.tobago.util.DateFormatUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class TimeRenderer
extends InputRendererBase {
    private static final Log LOG = LogFactory.getLog(TimeRenderer.class);
    private static final String[] SCRIPTS = new String[]{"script/calendar.js", "script/dateConverter.js"};

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        String pattern;
        Converter converter;
        if (!(component instanceof UITimeInput)) {
            LOG.error((Object)("Wrong type: Need " + UITimeInput.class.getName() + ", but was " + component.getClass().getName()));
            return;
        }
        UIPage page = ComponentUtil.findPage((FacesContext)facesContext, (UIComponent)component);
        page.getScriptFiles().addAll(Arrays.asList(SCRIPTS));
        UITimeInput input = (UITimeInput)component;
        String title = HtmlRendererUtil.getTitleFromTipAndMessages((FacesContext)facesContext, (UIComponent)input);
        String currentValue = this.getCurrentValue(facesContext, (UIComponent)input);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("currentValue = '" + currentValue + "'"));
        }
        String converterPattern = "HH:mm";
        if (input.getConverter() != null && (converter = input.getConverter()) instanceof DateTimeConverter && (pattern = DateFormatUtils.findPattern((DateTimeConverter)((DateTimeConverter)converter))) != null && pattern.indexOf(115) > -1) {
            converterPattern = converterPattern + ":ss";
        }
        boolean hasSeconds = converterPattern.indexOf(115) > -1;
        Object value = input.getValue();
        Date date = value instanceof Date ? (Date)value : (value instanceof Calendar ? ((Calendar)value).getTime() : new Date());
        String hour = new SimpleDateFormat("HH").format(date);
        String minute = new SimpleDateFormat("mm").format(date);
        String second = new SimpleDateFormat("ss").format(date);
        String id = input.getClientId(facesContext);
        String idPrefix = id + "::";
        TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter((FacesContext)facesContext);
        writer.startElement("div", (UIComponent)input);
        writer.writeClassAttribute();
        writer.startElement("div", (UIComponent)input);
        writer.writeAttribute("id", idPrefix + "borderDiv", false);
        writer.writeClassAttribute("tobago-time-borderDiv" + (hasSeconds ? " tobago-time-borderDiv-seconds" : ""));
        this.writeInput(writer, input, idPrefix + "hour", hour, true, title);
        this.writeInputSeparator(writer, ":");
        this.writeInput(writer, input, idPrefix + "minute", minute, false, title);
        if (hasSeconds) {
            this.writeInputSeparator(writer, ":");
            this.writeInput(writer, input, idPrefix + "second", second, false, title);
        }
        writer.endElement("div");
        String imageId = idPrefix + "inc";
        String imageSrc = "image/timeIncrement.gif";
        HtmlRendererUtil.addImageSources((FacesContext)facesContext, (TobagoResponseWriter)writer, (String)imageSrc, (String)imageId);
        writer.startElement("img", null);
        writer.writeIdAttribute(imageId);
        writer.writeClassAttribute("tobago-time-inc-image" + (hasSeconds ? " tobago-time-image-seconds" : ""));
        writer.writeAttribute("src", ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)imageSrc), true);
        writer.writeAttribute("alt", "", false);
        if (!ComponentUtil.getBooleanAttribute((UIComponent)input, (String)"disabled") && !ComponentUtil.getBooleanAttribute((UIComponent)input, (String)"readonly")) {
            writer.writeAttribute("onclick", "tbgIncTime(this)", false);
            writer.writeAttribute("onmouseover", (Object)("Tobago.imageMouseover('" + imageId + "')"), null);
            writer.writeAttribute("onmouseout", (Object)("Tobago.imageMouseout('" + imageId + "')"), null);
        }
        writer.endElement("img");
        imageId = idPrefix + "dec";
        imageSrc = "image/timeDecrement.gif";
        HtmlRendererUtil.addImageSources((FacesContext)facesContext, (TobagoResponseWriter)writer, (String)imageSrc, (String)imageId);
        writer.startElement("img", null);
        writer.writeIdAttribute(imageId);
        writer.writeClassAttribute("tobago-time-dec-image" + (hasSeconds ? " tobago-time-image-seconds" : ""));
        writer.writeAttribute("src", ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)imageSrc), true);
        writer.writeAttribute("alt", "", false);
        if (!ComponentUtil.getBooleanAttribute((UIComponent)input, (String)"disabled") && !ComponentUtil.getBooleanAttribute((UIComponent)input, (String)"readonly")) {
            writer.writeAttribute("onclick", "tbgDecTime(this)", false);
            writer.writeAttribute("onmouseover", (Object)("Tobago.imageMouseover('" + imageId + "')"), null);
            writer.writeAttribute("onmouseout", (Object)("Tobago.imageMouseout('" + imageId + "')"), null);
        }
        writer.endElement("img");
        writer.startElement("input", (UIComponent)input);
        writer.writeAttribute("type", "hidden", false);
        writer.writeIdAttribute(id + ":converterPattern");
        writer.writeAttribute("value", converterPattern, true);
        writer.endElement("input");
        writer.startElement("input", (UIComponent)input);
        writer.writeAttribute("type", "hidden", false);
        writer.writeIdAttribute(id);
        writer.writeNameAttribute(id);
        writer.writeAttribute("value", hour + ":" + minute + ":" + second, false);
        writer.endElement("input");
        String dateTextBoxId = (String)input.getAttributes().get("CalendarDateInputId");
        if (dateTextBoxId != null) {
            String[] cmds = new String[]{"tbgInitTimeParse('" + id + "', '" + dateTextBoxId + "');"};
            HtmlRendererUtil.writeScriptLoader((FacesContext)facesContext, (String[])SCRIPTS, (String[])cmds);
        }
        writer.endElement("div");
    }

    private void writeInputSeparator(TobagoResponseWriter writer, String sep) throws IOException {
        writer.startElement("span", null);
        writer.writeClassAttribute("tobago-time-sep");
        writer.writeText(sep);
        writer.endElement("span");
    }

    private void writeInput(TobagoResponseWriter writer, UITimeInput input, String id, String hour, boolean hourMode, String title) throws IOException {
        Integer tabIndex = input.getTabIndex();
        writer.startElement("input", null);
        writer.writeAttribute("type", "text", false);
        writer.writeIdAttribute(id);
        if (tabIndex != null) {
            writer.writeAttribute("tabindex", tabIndex.intValue());
        }
        writer.writeAttribute("title", title, true);
        StyleClasses styleClasses = new StyleClasses();
        styleClasses.addClass("time", "input");
        writer.writeClassAttribute(styleClasses);
        writer.writeAttribute("readonly", ComponentUtil.getBooleanAttribute((UIComponent)input, (String)"readonly"));
        writer.writeAttribute("disabled", ComponentUtil.getBooleanAttribute((UIComponent)input, (String)"disabled"));
        if (!ComponentUtil.getBooleanAttribute((UIComponent)input, (String)"disabled") && !ComponentUtil.getBooleanAttribute((UIComponent)input, (String)"readonly")) {
            writer.writeAttribute("onfocus", "tbgTimerInputFocus(this, " + hourMode + ")", false);
            writer.writeAttribute("onblur", "tbgTimerInputBlur(this)", false);
            writer.writeAttribute("onkeyup", "tbgTimerKeyUp(this, event)", false);
        }
        writer.writeAttribute("value", hour, true);
        writer.endElement("input");
    }
}

