/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.validator.LengthValidator;
import javax.faces.validator.Validator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.ajax.api.AjaxPhaseListener;
import org.apache.myfaces.tobago.ajax.api.AjaxRenderer;
import org.apache.myfaces.tobago.ajax.api.AjaxUtils;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.renderkit.InputRendererBase;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.renderkit.html.StyleClasses;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class InRenderer
extends InputRendererBase
implements AjaxRenderer {
    private static final Log LOG = LogFactory.getLog(InRenderer.class);

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        if (!(component instanceof org.apache.myfaces.tobago.component.UIInput)) {
            LOG.error((Object)("Wrong type: Need " + org.apache.myfaces.tobago.component.UIInput.class.getName() + ", but was " + component.getClass().getName()));
            return;
        }
        org.apache.myfaces.tobago.component.UIInput input = (org.apache.myfaces.tobago.component.UIInput)component;
        String title = HtmlRendererUtil.getTitleFromTipAndMessages((FacesContext)facesContext, (UIComponent)input);
        boolean password = ComponentUtil.getBooleanAttribute((UIComponent)input, (String)"password");
        String currentValue = this.getCurrentValue(facesContext, (UIComponent)input);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("currentValue = '" + (password && currentValue != null ? StringUtils.leftPad((String)"", (int)currentValue.length(), (char)'*') : currentValue) + "'"));
        }
        String type = password ? "password" : "text";
        boolean renderAjaxSuggest = input.getSuggestMethod() != null;
        String id = input.getClientId(facesContext);
        TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter((FacesContext)facesContext);
        writer.startElement("input", (UIComponent)input);
        writer.writeAttribute("type", type, false);
        writer.writeNameAttribute(id);
        writer.writeIdAttribute(id);
        if (currentValue != null) {
            writer.writeAttribute("value", currentValue, true);
        }
        if (title != null) {
            writer.writeAttribute("title", title, true);
        }
        int maxLength = 0;
        for (Validator validator : input.getValidators()) {
            if (!(validator instanceof LengthValidator)) continue;
            LengthValidator lengthValidator = (LengthValidator)validator;
            maxLength = lengthValidator.getMaximum();
        }
        if (maxLength > 0) {
            writer.writeAttribute("maxlength", maxLength);
        }
        writer.writeAttribute("readonly", ComponentUtil.getBooleanAttribute((UIComponent)input, (String)"readonly"));
        writer.writeAttribute("disabled", ComponentUtil.getBooleanAttribute((UIComponent)input, (String)"disabled"));
        Integer tabIndex = input.getTabIndex();
        if (tabIndex != null) {
            writer.writeAttribute("tabindex", tabIndex.intValue());
        }
        writer.writeStyleAttribute();
        if (currentValue != null && currentValue.length() > 0 && ComponentUtil.getBooleanAttribute((UIComponent)input, (String)"required")) {
            StyleClasses styleClasses = StyleClasses.ensureStyleClasses((UIComponent)input);
            String rendererName = HtmlRendererUtil.getRendererName((FacesContext)facesContext, (UIComponent)input);
            styleClasses.removeAspectClass(rendererName, StyleClasses.Aspect.REQUIRED);
        }
        writer.writeClassAttribute();
        if (renderAjaxSuggest) {
            writer.writeAttribute("autocomplete", "off", false);
        }
        writer.endElement("input");
        this.checkForCommandFacet((UIComponent)input, facesContext, writer);
        if (ComponentUtil.getBooleanAttribute((UIComponent)input, (String)"required")) {
            String rendererName = HtmlRendererUtil.getRendererName((FacesContext)facesContext, (UIComponent)input);
            String[] cmds = new String[]{"new Tobago.In(\"" + id + "\", true ,\"" + "tobago-" + rendererName + "\"  );"};
            HtmlRendererUtil.writeScriptLoader((FacesContext)facesContext, null, (String[])cmds);
        }
        HtmlRendererUtil.renderFocusId((FacesContext)facesContext, (UIInput)input);
        if (renderAjaxSuggest) {
            String popupId = id + "::" + "ajaxPopup";
            UIPage page = ComponentUtil.findPage((FacesContext)facesContext, (UIComponent)input);
            page.getScriptFiles().add("script/effects.js");
            page.getScriptFiles().add("script/dragdrop.js");
            page.getScriptFiles().add("script/controls.js");
            page.getScriptFiles().add("script/inputSuggest.js");
            writer.startElement("div", null);
            writer.writeClassAttribute("tobago-in-suggest-popup");
            writer.writeStyleAttribute("display: none;");
            writer.writeIdAttribute(popupId);
            writer.endElement("div");
            String[] scripts = new String[]{"script/effects.js", "script/dragdrop.js", "script/controls.js", "script/inputSuggest.js"};
            String[] cmds = new String[]{"new Tobago.Autocompleter(", "    '" + id + "',", "    '" + page.getClientId(facesContext) + "',", "    { method:       'post',", "      asynchronous: true,", "      parameters: ''", "    });"};
            HtmlRendererUtil.writeScriptLoader((FacesContext)facesContext, (String[])scripts, (String[])cmds);
        }
    }

    public void encodeAjax(FacesContext context, UIComponent component) throws IOException {
        if (!(component instanceof org.apache.myfaces.tobago.component.UIInput)) {
            LOG.error((Object)("Wrong type: Need " + org.apache.myfaces.tobago.component.UIInput.class.getName() + ", but was " + component.getClass().getName()));
            return;
        }
        AjaxUtils.checkParamValidity((FacesContext)context, (UIComponent)component, org.apache.myfaces.tobago.component.UIInput.class);
        org.apache.myfaces.tobago.component.UIInput input = (org.apache.myfaces.tobago.component.UIInput)component;
        MethodBinding o = input.getSuggestMethod();
        if (!(o instanceof MethodBinding)) {
            return;
        }
        MethodBinding mb = o;
        TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter((FacesContext)context);
        int maxSuggestedCount = 25;
        List suggestedList = (List)mb.invoke(context, new Object[]{AjaxPhaseListener.getValueForComponent((FacesContext)context, (UIComponent)component)});
        writer.startElement("ul", null);
        int i = 0;
        for (Object value : suggestedList) {
            writer.startElement("li", null);
            writer.writeText(value, null);
            writer.endElement("li");
            if (++i < maxSuggestedCount) continue;
            break;
        }
        writer.endElement("ul");
        if (suggestedList.size() > maxSuggestedCount) {
            writer.startElement("div", null);
            writer.writeAttribute("title", ResourceManagerUtil.getPropertyNotNull((FacesContext)context, (String)"tobago", (String)"tobago.in.inputSuggest.moreElements"), true);
            writer.writeText("\u2026");
            writer.endElement("div");
        }
        context.responseComplete();
    }
}

