/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.renderkit.LayoutableRendererBase;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class ImageRenderer
extends LayoutableRendererBase {
    private static final Log LOG = LogFactory.getLog(ImageRenderer.class);

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        String alt;
        String border;
        TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter((FacesContext)facesContext);
        UIGraphic graphic = (UIGraphic)component;
        String value = graphic.getUrl();
        String src = value;
        if (src != null && !ResourceManagerUtil.isAbsoluteResource((String)src)) {
            src = null;
            if (this.isDisabled(graphic)) {
                src = ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)HtmlRendererUtil.createSrc((String)value, (String)"Disabled"), (boolean)true);
            }
            if (src == null) {
                src = ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)value);
            }
            HtmlRendererUtil.addImageSources((FacesContext)facesContext, (TobagoResponseWriter)writer, (String)graphic.getUrl(), (String)graphic.getClientId(facesContext));
        }
        if ((border = (String)graphic.getAttributes().get("border")) == null) {
            border = "0";
        }
        if ((alt = (String)graphic.getAttributes().get("alt")) == null) {
            alt = "";
        }
        writer.startElement("img", (UIComponent)graphic);
        String clientId = graphic.getClientId(facesContext);
        writer.writeIdAttribute(clientId);
        if (ComponentUtil.isHoverEnabled((UIComponent)graphic) && !this.isDisabled(graphic)) {
            writer.writeAttribute("onmouseover", "Tobago.imageMouseover('" + clientId + "')", false);
            writer.writeAttribute("onmouseout", "Tobago.imageMouseout('" + clientId + "')", false);
        }
        if (src != null) {
            writer.writeAttribute("src", src, true);
        }
        writer.writeAttribute("alt", alt, true);
        HtmlRendererUtil.renderTip((UIComponent)graphic, (TobagoResponseWriter)writer);
        writer.writeAttribute("border", border, false);
        writer.writeAttributeFromComponent("height", "height");
        writer.writeStyleAttribute();
        writer.writeClassAttribute();
        writer.endElement("img");
    }

    private String createSrc(String src, String ext) {
        int dot = src.lastIndexOf(46);
        if (dot == -1) {
            LOG.warn((Object)("Image src without extension: '" + src + "'"));
            return src;
        }
        return src.substring(0, dot) + ext + src.substring(dot);
    }

    private boolean isDisabled(UIGraphic graphic) {
        boolean disabled = ComponentUtil.getBooleanAttribute((UIComponent)graphic, (String)"disabled");
        if (!disabled && graphic.getParent() instanceof UICommand) {
            disabled = ComponentUtil.getBooleanAttribute((UIComponent)graphic.getParent(), (String)"disabled");
        }
        return disabled;
    }
}

