/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.FixedLayoutToken;
import org.apache.myfaces.tobago.component.HideLayoutToken;
import org.apache.myfaces.tobago.component.LayoutToken;
import org.apache.myfaces.tobago.component.LayoutTokens;
import org.apache.myfaces.tobago.component.MinimumLayoutToken;
import org.apache.myfaces.tobago.component.PixelLayoutToken;
import org.apache.myfaces.tobago.component.RelativeLayoutToken;
import org.apache.myfaces.tobago.component.UICell;
import org.apache.myfaces.tobago.component.UIForm;
import org.apache.myfaces.tobago.component.UIGridLayout;
import org.apache.myfaces.tobago.component.UIHiddenInput;
import org.apache.myfaces.tobago.component.UILayout;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.renderkit.LayoutableRendererBase;
import org.apache.myfaces.tobago.renderkit.RenderUtil;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.renderkit.html.HtmlStyleMap;
import org.apache.myfaces.tobago.renderkit.html.StyleClasses;
import org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag.DefaultLayoutRenderer;
import org.apache.myfaces.tobago.util.LayoutInfo;
import org.apache.myfaces.tobago.util.LayoutUtil;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridLayoutRenderer
extends DefaultLayoutRenderer {
    private static final Log LOG = LogFactory.getLog(GridLayoutRenderer.class);

    public int getFixedHeight(FacesContext facesContext, UIComponent component) {
        int height = this.calculateLayoutHeight(facesContext, component, false);
        LayoutableRendererBase containerRenderer = ComponentUtil.getRenderer((FacesContext)facesContext, (UIComponent)component);
        height += containerRenderer.getHeaderHeight(facesContext, component);
        return height += containerRenderer.getPaddingHeight(facesContext, component);
    }

    public int getFixedWidth(FacesContext facesContext, UIComponent component) {
        int width = this.calculateLayoutWidth(facesContext, component, false);
        LayoutableRendererBase containerRenderer = ComponentUtil.getRenderer((FacesContext)facesContext, (UIComponent)component);
        return width += containerRenderer.getPaddingWidth(facesContext, component);
    }

    private int calculateLayoutHeight(FacesContext facesContext, UIComponent component, boolean minimum) {
        UIGridLayout layout = (UIGridLayout)UILayout.getLayout((UIComponent)component);
        List rows = layout.ensureRows();
        LayoutTokens layoutTokens = layout.getRowLayout();
        if (layoutTokens == null && !minimum && LOG.isDebugEnabled()) {
            LOG.debug((Object)("No rowLayout found using " + (minimum ? "'minimum'" : "'fixed'") + " for all " + rows.size() + " rows." + " (clientId='" + layout.getClientId(facesContext) + "')"));
        }
        if (rows.size() != layoutTokens.getSize()) {
            LOG.warn((Object)("Unbalanced layout: rows.size()=" + rows.size() + " != layoutTokens.length=" + layoutTokens.getSize() + " rowLayout='" + layoutTokens + "'" + " (clientId='" + layout.getClientId(facesContext) + "')"));
            layoutTokens.ensureSize(rows.size(), (LayoutToken)new RelativeLayoutToken(1));
        }
        int size = Math.min(rows.size(), layoutTokens.getSize());
        int height = 0;
        height += this.getMarginAsInt(layout.getMarginTop());
        height += this.getMarginAsInt(layout.getMarginBottom());
        boolean first = true;
        for (int i = 0; i < size; ++i) {
            if (!this.rowIsRendered((UIGridLayout.Row)rows.get(i))) continue;
            height += this.getCellPadding(facesContext, (UIComponent)layout, first);
            first = false;
            LayoutToken token = layoutTokens.get(i);
            if (token instanceof PixelLayoutToken) {
                height += ((PixelLayoutToken)token).getPixel();
                continue;
            }
            if (token instanceof FixedLayoutToken) {
                height += this.getMaxHeight(facesContext, (UIGridLayout.Row)rows.get(i), false);
                continue;
            }
            if (token instanceof MinimumLayoutToken) {
                height += this.getMaxHeight(facesContext, (UIGridLayout.Row)rows.get(i), true);
                continue;
            }
            if (!minimum && LOG.isWarnEnabled() && layout.getRows() != null) {
                LOG.warn((Object)("Unable to calculate Height for token '" + token + "'! using " + (minimum ? "'minimum'" : "'fixed'") + " , component-id=" + component.getClientId(facesContext) + " is " + component.getRendererType()));
            }
            height += this.getMaxHeight(facesContext, (UIGridLayout.Row)rows.get(i), minimum);
        }
        return height;
    }

    public int calculateLayoutWidth(FacesContext facesContext, UIComponent component, boolean minimum) {
        UIGridLayout layout = (UIGridLayout)UILayout.getLayout((UIComponent)component);
        List rows = layout.ensureRows();
        UIGridLayout.Row row = (UIGridLayout.Row)rows.get(0);
        LayoutTokens layoutTokens = layout.getColumnLayout();
        if (layoutTokens == null && !minimum && LOG.isDebugEnabled()) {
            LOG.debug((Object)("No rowLayout found using " + (minimum ? "'minimum'" : "'fixed'") + " for all " + rows.size() + " rows of " + layout.getClientId(facesContext) + " !"));
        }
        if (row.getColumns() != layoutTokens.getSize()) {
            LOG.warn((Object)("Unbalanced layout: rows.size()=" + rows.size() + " != layoutTokens.length=" + layoutTokens.getSize() + " columnLayout='" + layoutTokens + "'" + " (clientId='" + layout.getClientId(facesContext) + "')"));
            layoutTokens.ensureSize(row.getColumns(), (LayoutToken)new FixedLayoutToken());
        }
        int size = Math.min(rows.size(), layoutTokens.getSize());
        int width = 0;
        width += this.getMarginAsInt(layout.getMarginLeft());
        width += this.getMarginAsInt(layout.getMarginRight());
        boolean first = true;
        for (int i = 0; i < size; ++i) {
            if (!this.columnIsRendered(rows, i)) continue;
            width += this.getCellPadding(facesContext, (UIComponent)layout, first);
            first = false;
            LayoutToken token = layoutTokens.get(i);
            if (token instanceof PixelLayoutToken) {
                width += ((PixelLayoutToken)token).getPixel();
                continue;
            }
            if (token instanceof FixedLayoutToken) {
                width += this.getMaxWidth(facesContext, rows, i, false);
                continue;
            }
            if (token instanceof MinimumLayoutToken) {
                width += this.getMaxWidth(facesContext, rows, i, true);
                continue;
            }
            if (!minimum && LOG.isWarnEnabled()) {
                LOG.warn((Object)("Unable to calculate Width for token '" + token + "'! using " + (minimum ? "'minimum'" : "'fixed'") + " , component-id=" + component.getClientId(facesContext) + " is " + component.getRendererType()));
            }
            width += this.getMaxWidth(facesContext, rows, i, minimum);
        }
        return width;
    }

    private boolean columnIsRendered(List<UIGridLayout.Row> rows, int column) {
        for (UIGridLayout.Row row : rows) {
            Object object = row.getElements().get(column);
            if (object instanceof UIComponent) {
                UICell cell;
                if (object instanceof UICell && (cell = (UICell)object).getSpanX() > 1) {
                    return false;
                }
                UIComponent component = (UIComponent)object;
                if (!component.isRendered()) continue;
                return true;
            }
            if (!"used".equals(object)) continue;
            return true;
        }
        return false;
    }

    private boolean rowIsRendered(UIGridLayout.Row row) {
        for (Object element : row.getElements()) {
            UIComponent component;
            if (!(element instanceof UIComponent) || !(component = (UIComponent)element).isRendered()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void encodeChildrenOfComponent(FacesContext facesContext, UIComponent component) throws IOException {
        UIGridLayout layout = (UIGridLayout)UILayout.getLayout((UIComponent)component);
        HtmlRendererUtil.prepareRender((FacesContext)facesContext, (UIComponent)layout);
        this.layoutEnd(facesContext, (UIComponent)layout);
        this.layoutMargins(layout);
        Map attributes = layout.getAttributes();
        List columnWidths = (List)attributes.get("widthList");
        TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter((FacesContext)facesContext);
        writer.startElement("table", (UIComponent)layout);
        writer.writeAttributeFromComponent("border", "border");
        writer.writeClassAttribute();
        writer.writeStyleAttribute();
        writer.writeAttribute("cellspacing", 0);
        writer.writeAttribute("cellpadding", 0);
        writer.writeAttribute("summary", "", false);
        boolean first = true;
        if (columnWidths != null) {
            writer.startElement("colgroup", null);
            for (int i = 0; i < columnWidths.size(); ++i) {
                int cellWidth = (Integer)columnWidths.get(i);
                if (cellWidth == -2) continue;
                first = false;
                writer.startElement("col", null);
                writer.writeAttribute("width", cellWidth += this.getCellPadding(facesContext, (UIComponent)layout, first));
                writer.endElement("col");
            }
            writer.endElement("colgroup");
        }
        List rows = layout.ensureRows();
        boolean firstRenderedRow = true;
        for (int rowIndex = 0; rowIndex < rows.size(); ++rowIndex) {
            UIGridLayout.Row row = (UIGridLayout.Row)rows.get(rowIndex);
            if (row.isHidden()) continue;
            writer.startElement("tr", null);
            List cells = row.getElements();
            boolean firstRenderedColum = true;
            for (int columnIndex = 0; columnIndex < cells.size(); ++columnIndex) {
                boolean hide = false;
                if (columnWidths != null) {
                    Integer columWidth = (Integer)columnWidths.get(columnIndex);
                    boolean bl = hide = columWidth == -2;
                }
                if (hide) continue;
                Object object = cells.get(columnIndex);
                if (object.toString().equals("used")) {
                    firstRenderedColum = false;
                    continue;
                }
                if (object.equals(UIGridLayout.FREE)) {
                    if (LOG.isWarnEnabled() && !layout.isIgnoreFree()) {
                        LOG.warn((Object)("There are free blocks in the layout: id='" + layout.getClientId(facesContext) + "'"));
                    }
                    firstRenderedColum = false;
                    continue;
                }
                UIComponent cell = (UIComponent)object;
                int spanX = UIGridLayout.getSpanX((UIComponent)cell);
                int spanY = UIGridLayout.getSpanY((UIComponent)cell);
                StyleClasses classes = StyleClasses.ensureStyleClassesCopy((UIComponent)layout);
                if (firstRenderedRow) {
                    classes.addClass("gridLayout", "first-row");
                }
                if (firstRenderedColum) {
                    classes.addClass("gridLayout", "first-column");
                }
                int cellWidth = -1;
                if (columnWidths != null) {
                    cellWidth = 0;
                    for (int i = columnIndex; i < columnIndex + spanX && i < columnWidths.size(); ++i) {
                        cellWidth += (Integer)columnWidths.get(i) + this.getCellPadding(facesContext, (UIComponent)layout, firstRenderedColum);
                        if (!firstRenderedColum) continue;
                        firstRenderedColum = false;
                    }
                }
                int cellHeight = -1;
                try {
                    Integer layoutHeight = LayoutUtil.getLayoutHeight((UIComponent)cell);
                    if (layoutHeight != null) {
                        cellHeight = layoutHeight;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                int topPadding = this.getCellPadding(facesContext, (UIComponent)layout, firstRenderedRow);
                String cellStyle = (cellWidth != -1 ? "width: " + cellWidth + "px;" : "") + (cellHeight != -1 ? " height: " + (cellHeight + topPadding) + "px;" : "");
                cellStyle = cellStyle + this.getOverflow(cell);
                writer.startElement("td", null);
                writer.writeClassAttribute("tobago-gridLayout-cell-td");
                writer.writeAttribute("style", cellStyle, false);
                if (spanX > 1) {
                    writer.writeAttribute("colspan", spanX);
                }
                if (spanY > 1) {
                    writer.writeAttribute("rowspan", spanY);
                }
                writer.flush();
                if (ComponentUtil.getAttribute((UIComponent)layout, (String)"cellspacing") != null) {
                    cellStyle = cellStyle + " padding: " + this.getCellSpacing(facesContext, (UIComponent)layout) + "px;";
                }
                writer.startElement("div", null);
                writer.writeClassAttribute(classes);
                writer.writeAttribute("style", cellStyle, false);
                writer.flush();
                RenderUtil.encode((FacesContext)facesContext, (UIComponent)cell);
                writer.endElement("div");
                writer.endElement("td");
                firstRenderedColum = false;
                HtmlRendererUtil.removeStyleClasses((UIComponent)cell);
            }
            writer.endElement("tr");
            firstRenderedRow = false;
        }
        writer.endElement("table");
        if (TobagoConfig.getInstance((FacesContext)facesContext).isFixLayoutTransparency()) {
            for (UIComponent child : layout.getParent().getChildren()) {
                if (!(child instanceof UIHiddenInput)) continue;
                RenderUtil.encode((FacesContext)facesContext, (UIComponent)child);
            }
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        if (component.getParent() instanceof UIPage) {
            LOG.error((Object)"XXXXXXXXXXXXXXXXXXXXXXX  never XXXXXXXXXXXXXXXXXXXXXX", (Throwable)new Exception());
        } else {
            this.encodeChildrenOfComponent(facesContext, component.getParent());
        }
    }

    private String getOverflow(UIComponent cell) {
        String overflow = "";
        String scrollbars = (String)cell.getAttributes().get("scrollbars");
        if (scrollbars != null) {
            if (scrollbars.equals("false")) {
                overflow = " overflow: hidden;";
            } else if (scrollbars.equals("true")) {
                overflow = " overflow: scroll;";
            } else if (scrollbars.equals("auto")) {
                overflow = " overflow: auto;";
            } else if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Illegal value for attribute 'scrollbars' : " + scrollbars));
            }
        }
        return overflow;
    }

    private int getCellPadding(FacesContext facesContext, UIComponent component, boolean first) {
        return first ? 0 : this.getCellSpacing(facesContext, component);
    }

    private int getBorder(UIComponent component) {
        int border;
        block3: {
            border = 0;
            String borderWidth = (String)component.getAttributes().get("border");
            try {
                if (borderWidth != null) {
                    border = Integer.parseInt(borderWidth);
                }
            }
            catch (NumberFormatException e) {
                if (!LOG.isWarnEnabled()) break block3;
                LOG.warn((Object)"Can't parse border, using 0!");
            }
        }
        return border;
    }

    private int getSpacingSum(UIComponent component, FacesContext facesContext, int count) {
        int space = 0;
        int border = this.getBorder(component);
        int cellSpacing = this.getCellSpacing(facesContext, component);
        if (border != 0) {
            space = border * 2 + count * 2;
        }
        space += (count - 1) * cellSpacing;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("extra count =" + count + ",  space = " + space));
        }
        return space;
    }

    private int getWidthSpacingSum(UIGridLayout component, FacesContext facesContext, int renderedColumnCount) {
        int spacingSum = this.getSpacingSum((UIComponent)component, facesContext, renderedColumnCount);
        return spacingSum += this.getComponentExtraWidth(facesContext, (UIComponent)component);
    }

    private int getCellSpacing(FacesContext facesContext, UIComponent component) {
        block3: {
            String cellspacing = (String)component.getAttributes().get("cellspacing");
            if (cellspacing != null) {
                try {
                    return Integer.parseInt(cellspacing);
                }
                catch (NumberFormatException e) {
                    if (!LOG.isWarnEnabled()) break block3;
                    LOG.warn((Object)("Illegal value for cellspacing : " + cellspacing + " using default"));
                }
            }
        }
        return this.getConfiguredValue(facesContext, component, "cellSpacing");
    }

    private void layoutEnd(FacesContext facesContext, UIComponent component) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"doLayout end");
        }
        UIGridLayout layout = (UIGridLayout)component;
        Map attributes = layout.getParent().getAttributes();
        boolean needVerticalScrollbar = false;
        Integer innerHeight = (Integer)attributes.get("innerHeight");
        if (innerHeight != null && innerHeight > 0) {
            int value = innerHeight;
            int minimum = this.calculateLayoutHeight(facesContext, layout.getParent(), true);
            if (minimum > value) {
                value = minimum;
                needVerticalScrollbar = true;
            }
            this.layoutHeight(value, layout, facesContext);
        } else {
            this.calculateHiddenForRows(layout.ensureRows());
        }
        Integer innerWidth = (Integer)attributes.get("innerWidth");
        if (innerWidth != null && innerWidth != -1) {
            int value = innerWidth;
            if (needVerticalScrollbar) {
                HtmlRendererUtil.replaceStyleAttribute((UIComponent)layout, (String)"width", (int)(value -= this.getConfiguredValue(facesContext, component, "scrollbarWidth")));
            }
            this.layoutWidth(value, layout, facesContext);
        }
    }

    private int getHeightSpacingSum(UIGridLayout layout, FacesContext facesContext, int renderedRowCount) {
        int spacingSum = this.getSpacingSum((UIComponent)layout, facesContext, renderedRowCount);
        return spacingSum += this.getComponentExtraHeight(facesContext, (UIComponent)layout);
    }

    private void layoutWidth(Integer innerWidth, UIGridLayout layout, FacesContext facesContext) {
        List rows = layout.ensureRows();
        LayoutTokens layoutTokens = layout.getColumnLayout();
        int renderedColumnCount = 0;
        if (!rows.isEmpty()) {
            UIGridLayout.Row row = (UIGridLayout.Row)rows.get(0);
            List cells = row.getElements();
            renderedColumnCount = cells.size();
            for (int i = 0; i < cells.size(); ++i) {
                Object cell = cells.get(i);
                boolean hidden = false;
                if (this.isHidden(cell)) {
                    hidden = true;
                    for (int j = 1; j < rows.size(); ++j) {
                        hidden &= this.isHidden(((UIGridLayout.Row)rows.get(j)).getElements().get(i));
                    }
                }
                if (!hidden) continue;
                layoutTokens.set(i, (LayoutToken)new HideLayoutToken());
                --renderedColumnCount;
            }
        }
        innerWidth = innerWidth - this.getWidthSpacingSum(layout, facesContext, renderedColumnCount);
        LayoutInfo layoutInfo = new LayoutInfo(layoutTokens.getSize(), innerWidth.intValue(), layoutTokens, layout.getClientId(facesContext), layout.isIgnoreFree());
        this.parseFixedWidth(layoutInfo, layout, facesContext);
        layoutInfo.parseColumnLayout(innerWidth.doubleValue(), this.getCellSpacing(facesContext, (UIComponent)layout));
        this.setColumnWidths(layout, layoutInfo, facesContext);
        layout.getAttributes().put("widthList", layoutInfo.getSpaceList());
    }

    private boolean isHidden(Object cell) {
        return cell instanceof UIComponent && !((UIComponent)cell).isRendered() || cell instanceof UIGridLayout.Marker && !((UIGridLayout.Marker)cell).isRendered();
    }

    private void layoutHeight(Integer innerHeight, UIGridLayout layout, FacesContext facesContext) {
        List rows = layout.ensureRows();
        LayoutTokens layoutTokens = layout.getRowLayout();
        layoutTokens.ensureSize(rows.size(), (LayoutToken)(rows.size() == 1 ? new RelativeLayoutToken(1) : new FixedLayoutToken()));
        this.calculateHiddenForRows(rows);
        int renderedRowCount = rows.size();
        for (int i = 0; i < rows.size(); ++i) {
            if (!((UIGridLayout.Row)rows.get(i)).isHidden()) continue;
            layoutTokens.set(i, (LayoutToken)new HideLayoutToken());
            --renderedRowCount;
        }
        innerHeight = innerHeight - this.getHeightSpacingSum(layout, facesContext, renderedRowCount);
        LayoutInfo layoutInfo = new LayoutInfo(rows.size(), innerHeight.intValue(), layoutTokens, layout.getClientId(facesContext));
        if (!layoutTokens.isEmpty()) {
            this.parseFixedHeight(layoutInfo, layout, facesContext);
            layoutInfo.parseColumnLayout(innerHeight.doubleValue(), this.getCellSpacing(facesContext, (UIComponent)layout));
        }
        this.setColumnHeights(layout, layoutInfo, facesContext);
    }

    private void calculateHiddenForRows(List<UIGridLayout.Row> rows) {
        for (int i = 0; i < rows.size(); ++i) {
            boolean hidden = true;
            UIGridLayout.Row row = rows.get(i);
            List cells = row.getElements();
            for (Object cell : cells) {
                hidden &= this.isHidden(cell);
            }
            row.setHidden(hidden);
        }
    }

    private void parseFixedWidth(LayoutInfo layoutInfo, UIGridLayout layout, FacesContext facesContext) {
        this.parseFixedSpace(layoutInfo, layout, true, facesContext);
    }

    private void parseFixedHeight(LayoutInfo layoutInfo, UIGridLayout layout, FacesContext facesContext) {
        this.parseFixedSpace(layoutInfo, layout, false, facesContext);
    }

    public void parseFixedSpace(LayoutInfo layoutInfo, UIGridLayout layout, LayoutTokens layoutTokens, boolean width, FacesContext facesContext) {
        for (int i = 0; i < layoutTokens.getSize(); ++i) {
            LayoutToken token = layoutTokens.get(i);
            if (!(token instanceof FixedLayoutToken)) continue;
            int max = 0;
            List rows = layout.ensureRows();
            if (!rows.isEmpty()) {
                if (width) {
                    max = this.getMaxWidth(facesContext, rows, i, false);
                } else if (i < rows.size()) {
                    UIGridLayout.Row row = (UIGridLayout.Row)rows.get(i);
                    max = this.getMaxHeight(facesContext, row, false);
                } else {
                    layoutInfo.update(0, i);
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)("More LayoutTokens found than rows! skipping! tokens = " + token + "  components = " + rows.size()));
                    }
                }
                layoutInfo.update(max, i);
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("set column " + i + " from fixed to with " + max));
        }
    }

    private void parseFixedSpace(LayoutInfo layoutInfo, UIGridLayout layout, boolean width, FacesContext facesContext) {
        LayoutTokens tokens = layoutInfo.getLayoutTokens();
        for (int i = 0; i < tokens.getSize(); ++i) {
            LayoutToken token = tokens.get(i);
            if (!(token instanceof FixedLayoutToken)) continue;
            int max = 0;
            List rows = layout.ensureRows();
            if (!rows.isEmpty()) {
                if (width) {
                    max = this.getMaxWidth(facesContext, rows, i, false);
                } else if (i < rows.size()) {
                    UIGridLayout.Row row = (UIGridLayout.Row)rows.get(i);
                    max = this.getMaxHeight(facesContext, row, false);
                } else {
                    layoutInfo.update(0, i);
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)("More LayoutTokens found than rows! skipping! tokens = " + token + "  components = " + rows.size()));
                    }
                }
                layoutInfo.update(max, i);
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("set column " + i + " from fixed to with " + max));
        }
    }

    private int getMaxHeight(FacesContext facesContext, UIGridLayout.Row row, boolean minimum) {
        int maxHeight = 0;
        List cells = row.getElements();
        for (Object cell : cells) {
            if (cell instanceof UIComponent) {
                UIComponent component = (UIComponent)cell;
                int height = -1;
                if (minimum) {
                    height = (int)LayoutUtil.getMinimumSize((FacesContext)facesContext, (UIComponent)component).getHeight();
                } else {
                    LayoutableRendererBase renderer = ComponentUtil.getRenderer((FacesContext)facesContext, (UIComponent)component);
                    if (renderer != null) {
                        height = renderer.getFixedHeight(facesContext, component);
                    }
                }
                maxHeight = Math.max(maxHeight, height);
                continue;
            }
            if (cell instanceof UIGridLayout.Marker) continue;
            LOG.error((Object)("Object is not instanceof UIComponent " + cell.getClass().getName()));
        }
        return maxHeight;
    }

    private int getMaxWidth(FacesContext facesContext, List<UIGridLayout.Row> rows, int column, boolean minimum) {
        int maxWidth = 0;
        for (UIGridLayout.Row row : rows) {
            if (column >= row.getElements().size()) continue;
            Object object = row.getElements().get(column);
            if (object instanceof UIComponent) {
                UIComponent component = (UIComponent)object;
                if (component instanceof UICell && ((UICell)component).getSpanX() > 1) continue;
                int max = -1;
                if (minimum) {
                    max = (int)LayoutUtil.getMinimumSize((FacesContext)facesContext, (UIComponent)component).getWidth();
                } else {
                    LayoutableRendererBase renderer = ComponentUtil.getRenderer((FacesContext)facesContext, (UIComponent)component);
                    if (renderer != null) {
                        max = renderer.getFixedWidth(facesContext, component);
                    }
                }
                maxWidth = Math.max(maxWidth, max);
                continue;
            }
            if (object instanceof UIGridLayout.Marker) continue;
            LOG.error((Object)("Object is not instanceof UIComponent " + object.getClass().getName()));
        }
        return maxWidth;
    }

    private void setColumnWidths(UIGridLayout layout, LayoutInfo layoutInfo, FacesContext facesContext) {
        List rows = layout.ensureRows();
        for (UIGridLayout.Row row : rows) {
            List cells = row.getElements();
            int columnCount = layout.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                if (!(cells.get(i) instanceof UIComponent)) continue;
                UIComponent cell = (UIComponent)cells.get(i);
                int spanX = UIGridLayout.getSpanX((UIComponent)cell);
                int cellWidth = 0;
                for (int j = i; j < i + spanX; ++j) {
                    cellWidth += layoutInfo.getSpaceForColumn(j);
                }
                if (spanX > 1 && this.getBorder((UIComponent)layout) > 0) {
                    cellWidth += (spanX - 1) * 2;
                }
                LayoutUtil.maybeSetLayoutAttribute((UIComponent)cell, (String)"layoutWidth", (Integer)(cellWidth += (spanX - 1) * this.getCellSpacing(facesContext, (UIComponent)layout)));
            }
        }
    }

    private void setColumnHeights(UIGridLayout layout, LayoutInfo layoutInfo, FacesContext facesContext) {
        List rows = layout.ensureRows();
        for (int i = 0; i < rows.size(); ++i) {
            UIGridLayout.Row row = (UIGridLayout.Row)rows.get(i);
            List cells = row.getElements();
            int columnCount = layout.getColumnCount();
            for (int j = 0; j < columnCount; ++j) {
                if (!(cells.get(j) instanceof UIComponent)) continue;
                UIComponent cell = (UIComponent)cells.get(j);
                int spanY = UIGridLayout.getSpanY((UIComponent)cell);
                int cellHeight = 0;
                for (int k = i; k < i + spanY; ++k) {
                    cellHeight += layoutInfo.getSpaceForColumn(k);
                }
                if (spanY > 1 && this.getBorder((UIComponent)layout) > 0) {
                    cellHeight += (spanY - 1) * 2;
                }
                cellHeight += (spanY - 1) * this.getCellSpacing(facesContext, (UIComponent)layout);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("set height of " + cellHeight + "px to " + cell.getRendererType() + " layoutInfo " + layoutInfo.toString()));
                }
                cell.getAttributes().put("layoutHeight", cellHeight);
                cell.getAttributes().remove("innerHeight");
                if (!(cell instanceof UICell) && !(cell instanceof UIForm)) continue;
                List children = LayoutUtil.addChildren(new ArrayList(), (UIComponent)cell);
                for (UIComponent component : children) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("set height of " + cellHeight + "px to " + component.getRendererType()));
                    }
                    component.getAttributes().put("layoutHeight", cellHeight);
                    component.getAttributes().remove("innerHeight");
                }
            }
        }
    }

    public void layoutBegin(FacesContext facesContext, UIComponent component) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"############################## layoutBegin +++++++++++++++++++++++++++++++++++++++++");
        }
        HtmlRendererUtil.layoutSpace((FacesContext)facesContext, (UIComponent)component, (boolean)true);
        HtmlRendererUtil.layoutSpace((FacesContext)facesContext, (UIComponent)component, (boolean)false);
        if (component instanceof UIGridLayout) {
            this.layoutMargins((UIGridLayout)component);
        }
    }

    private void layoutMargins(UIGridLayout layout) {
        HtmlStyleMap style = (HtmlStyleMap)layout.getAttributes().get("style");
        if (style != null) {
            Integer width;
            int marginTop = this.getMarginAsInt(layout.getMarginTop());
            int marginRight = this.getMarginAsInt(layout.getMarginRight());
            int marginBottom = this.getMarginAsInt(layout.getMarginBottom());
            int marginLeft = this.getMarginAsInt(layout.getMarginLeft());
            if (marginTop > 0) {
                style.put("margin-top", (Object)marginTop);
            }
            if (marginRight > 0) {
                style.put("margin-right", (Object)marginRight);
                width = style.getInt((Object)"width");
                if (width != null) {
                    width = width - marginRight;
                    style.put("width", (Object)width);
                }
            }
            if (marginBottom > 0) {
                style.put("margin-bottom", (Object)marginBottom);
            }
            if (marginLeft > 0) {
                style.put("margin-left", (Object)marginLeft);
                width = style.getInt((Object)"width");
                if (width != null) {
                    width = width - marginLeft;
                    style.put("width", (Object)width);
                }
            }
        }
    }

    public int getComponentExtraWidth(FacesContext facesContext, UIComponent component) {
        int extra = 0;
        UIGridLayout layout = (UIGridLayout)component;
        extra += this.getMarginAsInt(layout.getMarginRight());
        return extra += this.getMarginAsInt(layout.getMarginLeft());
    }

    public int getComponentExtraHeight(FacesContext facesContext, UIComponent component) {
        int extra = 0;
        UIGridLayout layout = (UIGridLayout)component;
        extra += this.getMarginAsInt(layout.getMarginTop());
        return extra += this.getMarginAsInt(layout.getMarginBottom());
    }

    private int getMarginAsInt(String margin) {
        block3: {
            if (margin != null) {
                margin = this.removePx(margin);
                try {
                    return Integer.parseInt(margin);
                }
                catch (NumberFormatException e) {
                    if (!LOG.isWarnEnabled()) break block3;
                    LOG.warn((Object)("Illegal Margin : " + margin + " exception : " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return 0;
    }

    private String removePx(String margin) {
        if (margin != null && margin.endsWith("px")) {
            margin = margin.substring(0, margin.length() - 2);
        }
        return margin;
    }
}

