/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.model.CalendarModel;
import org.apache.myfaces.tobago.model.DateModel;
import org.apache.myfaces.tobago.renderkit.LayoutableRendererBase;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class CalendarRenderer
extends LayoutableRendererBase {
    private static final Log LOG = LogFactory.getLog(CalendarRenderer.class);
    private static final String[] SCRIPTS = new String[]{"script/calendar.js", "script/dateConverter.js"};

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Calendar calendar;
        UIOutput output = (UIOutput)component;
        UIPage page = ComponentUtil.findPage((FacesContext)facesContext, (UIComponent)output);
        for (String script : SCRIPTS) {
            page.getScriptFiles().add(script);
        }
        String id = output.getClientId(facesContext);
        String dateTextBoxId = (String)component.getAttributes().get("CalendarDateInputId");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("dateTextBoxId = '" + dateTextBoxId + "'"));
        }
        Locale locale = facesContext.getViewRoot().getLocale();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMMMM yyyy", locale);
        Object value = output.getValue();
        if (value instanceof Calendar) {
            calendar = (Calendar)value;
        } else {
            calendar = new GregorianCalendar();
            if (value instanceof Date) {
                calendar.setTime((Date)value);
            }
        }
        CalendarModel model = new CalendarModel(calendar);
        TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter((FacesContext)facesContext);
        writer.startElement("table", component);
        writer.writeIdAttribute(id);
        writer.writeClassAttribute();
        writer.writeAttribute("cellspacing", 0);
        writer.writeAttribute("cellpadding", 3);
        writer.writeAttribute("summary", "", false);
        writer.startElement("tr", null);
        writer.writeClassAttribute("tobago-calendar-header-tr");
        writer.startElement("th", null);
        writer.writeAttribute("colspan", 7);
        writer.startElement("table", null);
        writer.writeAttribute("summary", "", false);
        writer.writeClassAttribute("tobago-calendar-header");
        writer.startElement("tr", null);
        writer.startElement("td", null);
        writer.writeAttribute("align", "left", false);
        writer.startElement("img", null);
        writer.writeClassAttribute("tobago-calendar-header");
        writer.writeAttribute("alt", "", false);
        writer.writeAttribute("src", ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)"image/calendarFastPrev.gif"), false);
        writer.writeAttribute("onclick", "addMonth('" + id + "', -12)", false);
        writer.endElement("img");
        writer.endElement("td");
        writer.startElement("td", null);
        writer.writeAttribute("align", "left", false);
        writer.startElement("img", null);
        writer.writeClassAttribute("tobago-calendar-header");
        writer.writeAttribute("alt", "", false);
        writer.writeAttribute("src", ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)"image/calendarPrev.gif"), false);
        writer.writeAttribute("onclick", "addMonth('" + id + "', -1)", false);
        writer.endElement("img");
        writer.endElement("td");
        writer.startElement("th", null);
        writer.writeClassAttribute("tobago-calendar-header-center");
        writer.writeAttribute("align", "center", false);
        writer.writeIdAttribute(id + ":title");
        writer.writeText(dateFormat.format(calendar.getTime()));
        writer.endElement("th");
        writer.startElement("td", null);
        writer.writeAttribute("align", "right", false);
        writer.startElement("img", null);
        writer.writeClassAttribute("tobago-calendar-header");
        writer.writeAttribute("alt", "", false);
        writer.writeAttribute("src", ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)"image/calendarNext.gif"), false);
        writer.writeAttribute("onclick", "addMonth('" + id + "', 1)", false);
        writer.endElement("img");
        writer.endElement("td");
        writer.startElement("td", null);
        writer.writeAttribute("align", "right", false);
        writer.startElement("img", null);
        writer.writeClassAttribute("tobago-calendar-header");
        writer.writeAttribute("alt", "", false);
        writer.writeAttribute("src", ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)"image/calendarFastNext.gif"), false);
        writer.writeAttribute("onclick", "addMonth('" + id + "', 12)", false);
        writer.endElement("img");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        writer.endElement("th");
        writer.endElement("tr");
        writer.startElement("tr", null);
        dateFormat = new SimpleDateFormat("E", locale);
        for (int dayIt = 0; dayIt < 7; ++dayIt) {
            DateModel date = model.getDate(0, dayIt);
            String dayName = dateFormat.format(date.getCalendar().getTime());
            dayName = StringUtils.substring((String)dayName, (int)0, (int)2);
            writer.startElement("th", null);
            writer.writeClassAttribute("tobago-calendar-inner-header");
            writer.writeText(dayName);
            writer.endElement("th");
        }
        writer.endElement("tr");
        for (int week = 0; week < 6; ++week) {
            writer.startElement("tr", null);
            writer.writeIdAttribute(id + ":" + week);
            for (int dayIt = 0; dayIt < 7; ++dayIt) {
                DateModel date = model.getDate(week, dayIt);
                String dayDescription = String.valueOf(date.getDay());
                String onclick = "selectDay('" + id + "', " + week + " , " + dayIt + ");";
                writer.startElement("td", null);
                writer.writeAttribute("onclick", onclick, true);
                writer.writeIdAttribute(id + ":" + week + ":" + dayIt);
                writer.writeClassAttribute(this.getClass(date, model));
                writer.writeText(dayDescription);
                writer.endElement("td");
            }
            writer.endElement("tr");
        }
        writer.endElement("table");
        this.writeInputHidden(writer, "/" + id + "/year", id + ":year", Integer.toString(calendar.get(1)));
        this.writeInputHidden(writer, "/" + id + "/month", id + ":month", Integer.toString(1 + calendar.get(2)));
        this.writeInputHidden(writer, "/" + id + "/day", id + ":day", Integer.toString(calendar.get(5)));
        this.writeInputHidden(writer, id + ":firstDayOfWeek", Integer.toString(calendar.getFirstDayOfWeek()));
        this.writeInputHidden(writer, id + ":monthNames", this.getMonthNames(locale));
        this.writeInputHidden(writer, id + ":fieldId", "");
        String[] cmd = new String[]{"document.calendar = new Object();", dateTextBoxId != null ? "initCalendarParse('" + id + "', '" + dateTextBoxId + "');" : ""};
        HtmlRendererUtil.writeScriptLoader((FacesContext)facesContext, (String[])SCRIPTS, (String[])cmd);
    }

    private void writeInputHidden(TobagoResponseWriter writer, String id, String value) throws IOException {
        this.writeInputHidden(writer, null, id, value);
    }

    private void writeInputHidden(TobagoResponseWriter writer, String name, String id, String value) throws IOException {
        writer.startElement("input", null);
        writer.writeAttribute("type", "hidden", false);
        if (name != null) {
            writer.writeNameAttribute(name);
        }
        writer.writeIdAttribute(id);
        writer.writeAttribute("value", value, true);
        writer.endElement("input");
    }

    private String getClass(DateModel date, CalendarModel model) {
        return date.getMonth() == model.getMonth() ? "tobago-calendar-day" : "tobago-calendar-day-disabled";
    }

    private String getMonthNames(Locale locale) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMMMM", locale);
        StringBuilder buffer = new StringBuilder();
        Calendar calendar = Calendar.getInstance();
        calendar.set(2000, 0, 1);
        for (int month = 0; month < 12; ++month) {
            if (month > 0) {
                buffer.append(',');
            }
            buffer.append(dateFormat.format(calendar.getTime()));
            calendar.add(2, 1);
        }
        return buffer.toString();
    }
}

