/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UIButtonCommand;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.renderkit.CommandRendererBase;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.RenderUtil;
import org.apache.myfaces.tobago.renderkit.html.CommandRendererHelper;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.util.AccessKeyMap;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class ButtonRenderer
extends CommandRendererBase {
    private static final Log LOG = LogFactory.getLog(ButtonRenderer.class);

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        if (!(component instanceof UICommand)) {
            LOG.error((Object)("Wrong type: Need " + UICommand.class.getName() + ", but was " + component.getClass().getName()));
            return;
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        if (!(component instanceof UICommand)) {
            return;
        }
        UICommand command = (UICommand)component;
        String clientId = command.getClientId(facesContext);
        CommandRendererHelper helper = new CommandRendererHelper(facesContext, command, CommandRendererHelper.Tag.BUTTON);
        TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter((FacesContext)facesContext);
        LabelWithAccessKey label = new LabelWithAccessKey((UIComponent)command);
        writer.startElement("button", (UIComponent)command);
        writer.writeAttribute("type", this.createButtonType((UIComponent)command), false);
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(clientId);
        HtmlRendererUtil.renderTip((UIComponent)command, (TobagoResponseWriter)writer);
        writer.writeAttribute("disabled", helper.isDisabled());
        Integer tabIndex = null;
        if (command instanceof UIButtonCommand) {
            tabIndex = ((UIButtonCommand)command).getTabIndex();
        }
        if (tabIndex != null) {
            writer.writeAttribute("tabindex", tabIndex.intValue());
        }
        if (helper.getOnclick() != null) {
            writer.writeAttribute("onclick", helper.getOnclick(), true);
        }
        writer.writeStyleAttribute();
        writer.writeClassAttribute();
        writer.flush();
        String image = (String)command.getAttributes().get("image");
        if (image != null) {
            if (!ResourceManagerUtil.isAbsoluteResource((String)image)) {
                image = ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)image, (CommandRendererHelper)helper);
            }
            writer.startElement("img", null);
            writer.writeAttribute("src", image, true);
            HtmlRendererUtil.renderImageTip((UIComponent)component, (TobagoResponseWriter)writer);
            writer.endElement("img");
        }
        if (label.getText() != null) {
            if (image != null) {
                writer.writeText(" ");
            }
            HtmlRendererUtil.writeLabelWithAccessKey((TobagoResponseWriter)writer, (LabelWithAccessKey)label);
        }
        writer.endElement("button");
        if (label.getAccessKey() != null) {
            if (LOG.isInfoEnabled() && !AccessKeyMap.addAccessKey((FacesContext)facesContext, (Character)label.getAccessKey())) {
                LOG.info((Object)("duplicated accessKey : " + label.getAccessKey()));
            }
            HtmlRendererUtil.addClickAcceleratorKey((FacesContext)facesContext, (String)command.getClientId(facesContext), (char)label.getAccessKey().charValue());
        }
        if (ComponentUtil.getBooleanAttribute((UIComponent)component, (String)"defaultCommand")) {
            boolean transition = ComponentUtil.getBooleanAttribute((UIComponent)command, (String)"transition");
            HtmlRendererUtil.setDefaultTransition((FacesContext)facesContext, (boolean)transition);
            HtmlRendererUtil.writeScriptLoader((FacesContext)facesContext, null, (String[])new String[]{"Tobago.setDefaultAction('" + command.getClientId(facesContext) + "')"});
        }
    }

    private String createButtonType(UIComponent component) {
        boolean defaultCommand = ComponentUtil.getBooleanAttribute((UIComponent)component, (String)"defaultCommand");
        return defaultCommand ? "submit" : "button";
    }

    public int getFixedWidth(FacesContext facesContext, UIComponent component) {
        LabelWithAccessKey label;
        int width = 0;
        String imageName = (String)component.getAttributes().get("image");
        if (imageName != null) {
            width = this.getConfiguredValue(facesContext, component, "imageWidth");
        }
        if ((label = new LabelWithAccessKey(component)).getText() != null) {
            width += RenderUtil.calculateStringWidth((FacesContext)facesContext, (UIComponent)component, (String)label.getText());
        }
        int padding = this.getConfiguredValue(facesContext, component, "paddingWidth");
        width += 2 * padding;
        if (imageName != null && label.getText() != null) {
            width += padding;
        }
        return width;
    }
}

