/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.extension.fix.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;

public class MessageFixFacesContext
extends FacesContext {
    private FacesContext facesContext;
    private Map<String, List<FacesMessage>> clientIdsWithMessages;
    private List<FacesMessage> messages;
    private FacesMessage.Severity maximumSeverity;
    private boolean released = false;

    MessageFixFacesContext(FacesContext facesContext) {
        this.facesContext = facesContext;
        FacesContext.setCurrentInstance((FacesContext)this);
        Iterator clientIds = this.facesContext.getClientIdsWithMessages();
        while (clientIds.hasNext()) {
            String clientId = (String)clientIds.next();
            Iterator i = this.facesContext.getMessages(clientId);
            while (i.hasNext()) {
                FacesMessage facesMessage = (FacesMessage)i.next();
                this.addMessage(clientId, facesMessage);
            }
        }
    }

    public Iterator getMessages() {
        this.checkReleased();
        if (this.messages == null || this.messages.isEmpty()) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.messages.iterator();
    }

    public Iterator getMessages(String clientId) {
        this.checkReleased();
        if (this.messages == null || this.messages.isEmpty()) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (this.clientIdsWithMessages.containsKey(clientId)) {
            return this.clientIdsWithMessages.get(clientId).iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public Iterator getClientIdsWithMessages() {
        this.checkReleased();
        if (this.messages == null || this.messages.isEmpty()) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.clientIdsWithMessages.keySet().iterator();
    }

    public void addMessage(String clientId, FacesMessage message) {
        this.checkReleased();
        if (message == null) {
            throw new NullPointerException("message");
        }
        if (this.messages == null) {
            this.messages = new ArrayList<FacesMessage>();
            this.clientIdsWithMessages = new LinkedHashMap<String, List<FacesMessage>>();
        }
        this.messages.add(message);
        if (!this.clientIdsWithMessages.containsKey(clientId)) {
            ArrayList<FacesMessage> facesMessages = new ArrayList<FacesMessage>();
            facesMessages.add(message);
            this.clientIdsWithMessages.put(clientId, facesMessages);
        } else {
            this.clientIdsWithMessages.get(clientId).add(message);
        }
        FacesMessage.Severity severity = message.getSeverity();
        if (severity != null) {
            if (this.maximumSeverity == null) {
                this.maximumSeverity = severity;
            } else if (severity.compareTo((Object)this.maximumSeverity) > 0) {
                this.maximumSeverity = severity;
            }
        }
    }

    public FacesMessage.Severity getMaximumSeverity() {
        return this.maximumSeverity;
    }

    public void release() {
        this.released = true;
        this.messages = null;
        this.clientIdsWithMessages = null;
        this.maximumSeverity = null;
        this.facesContext.release();
    }

    public Application getApplication() {
        return this.facesContext.getApplication();
    }

    public ExternalContext getExternalContext() {
        return this.facesContext.getExternalContext();
    }

    public RenderKit getRenderKit() {
        return this.facesContext.getRenderKit();
    }

    public boolean getRenderResponse() {
        return this.facesContext.getRenderResponse();
    }

    public boolean getResponseComplete() {
        return this.facesContext.getResponseComplete();
    }

    public ResponseStream getResponseStream() {
        return this.facesContext.getResponseStream();
    }

    public void setResponseStream(ResponseStream responseStream) {
        this.facesContext.setResponseStream(responseStream);
    }

    public ResponseWriter getResponseWriter() {
        return this.facesContext.getResponseWriter();
    }

    public void setResponseWriter(ResponseWriter responseWriter) {
        this.facesContext.setResponseWriter(responseWriter);
    }

    public UIViewRoot getViewRoot() {
        return this.facesContext.getViewRoot();
    }

    public void setViewRoot(UIViewRoot root) {
        this.facesContext.setViewRoot(root);
    }

    public void renderResponse() {
        this.facesContext.renderResponse();
    }

    public void responseComplete() {
        this.facesContext.responseComplete();
    }

    private void checkReleased() {
        if (this.released) {
            throw new IllegalStateException("FacesContext already released");
        }
    }
}

