/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UITree;
import org.apache.myfaces.tobago.component.UITreeNode;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.renderkit.LayoutableRendererBase;
import org.apache.myfaces.tobago.renderkit.RenderUtil;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.util.FastStringWriter;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class TreeRenderer
extends LayoutableRendererBase {
    private static final String[] TREE_IMAGES = new String[]{"openfoldericon.gif", "foldericon.gif", "unchecked.gif", "uncheckedDisabled.gif", "checked.gif", "checkedDisabled.gif", "new.gif", "T.gif", "L.gif", "I.gif", "Lminus.gif", "Tminus.gif", "Rminus.gif", "Lplus.gif", "Tplus.gif", "Rplus.gif", "treeMenuOpen.gif", "treeMenuClose.gif"};

    public void decode(FacesContext facesContext, UIComponent component) {
        if (ComponentUtil.isOutputOnly((UIComponent)component)) {
            return;
        }
        UITree tree = (UITree)component;
        tree.setValid(true);
    }

    public static boolean isSelectable(UITree tree) {
        return tree.isSelectableTree();
    }

    public static String createJavascriptVariable(String clientId) {
        return clientId == null ? null : clientId.replace(':', '_');
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        UITree tree = (UITree)component;
        String clientId = tree.getClientId(facesContext);
        UIComponent root = tree.getRoot();
        TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter((FacesContext)facesContext);
        writer.startElement("div", (UIComponent)tree);
        writer.writeClassAttribute();
        writer.writeStyleAttribute();
        writer.startElement("input", (UIComponent)tree);
        writer.writeAttribute("type", "hidden", false);
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(clientId);
        writer.writeAttribute("value", ";", false);
        writer.endElement("input");
        writer.startElement("input", (UIComponent)tree);
        writer.writeAttribute("type", "hidden", false);
        writer.writeNameAttribute(clientId + "-marker");
        writer.writeIdAttribute(clientId + "-marker");
        writer.writeAttribute("value", "", false);
        writer.endElement("input");
        if (TreeRenderer.isSelectable(tree)) {
            writer.startElement("input", (UIComponent)tree);
            writer.writeAttribute("type", "hidden", false);
            writer.writeNameAttribute(clientId + "-selectState");
            writer.writeIdAttribute(clientId + "-selectState");
            writer.writeAttribute("value", ";", false);
            writer.endElement("input");
        }
        String scriptTexts = this.createJavascript(facesContext);
        String treeScript = "script/tobago-tree.js";
        List scriptFiles = ComponentUtil.findPage((FacesContext)facesContext, (UIComponent)tree).getScriptFiles();
        scriptFiles.add(treeScript);
        HtmlRendererUtil.writeScriptLoader((FacesContext)facesContext, (String[])new String[]{treeScript}, (String[])new String[]{scriptTexts});
        RenderUtil.encode((FacesContext)facesContext, (UIComponent)root);
        writer.endElement("div");
    }

    private String createJavascript(FacesContext facesContext) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        sb.append("  var treeResourcesHelp = new Object();\n");
        for (String images : TREE_IMAGES) {
            sb.append("  treeResourcesHelp[\"");
            sb.append(images);
            sb.append("\"] = \"");
            sb.append(ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)("image/" + images)));
            sb.append("\";\n");
        }
        sb.append(" \n  treeResourcesHelp.getImage = function (name) {\n");
        sb.append("    var result = this[name];\n");
        sb.append("    if (result) {\n");
        sb.append("      return result;\n");
        sb.append("    } else {\n");
        sb.append("      return \"");
        sb.append(ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)"image/blank.gif"));
        sb.append("\";\n");
        sb.append("    }\n");
        sb.append("  };\n \n");
        sb.append("}");
        return sb.toString();
    }

    protected String getNodesAsJavascript(FacesContext facesContext, UITreeNode root) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        FastStringWriter stringWriter = new FastStringWriter();
        facesContext.setResponseWriter(writer.cloneWithWriter((Writer)stringWriter));
        RenderUtil.encode((FacesContext)facesContext, (UIComponent)root);
        facesContext.setResponseWriter(writer);
        return stringWriter.toString();
    }

    protected String nodeStateId(FacesContext facesContext, UITreeNode node) {
        String clientId = node.getClientId(facesContext);
        int last = clientId.lastIndexOf(58) + 1;
        return clientId.substring(last);
    }
}

