/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UITree;
import org.apache.myfaces.tobago.component.UITreeNode;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.context.ResourceUtils;
import org.apache.myfaces.tobago.model.MixedTreeModel;
import org.apache.myfaces.tobago.renderkit.CommandRendererBase;
import org.apache.myfaces.tobago.renderkit.RenderUtil;
import org.apache.myfaces.tobago.renderkit.html.CommandRendererHelper;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.renderkit.html.HtmlStyleMap;
import org.apache.myfaces.tobago.renderkit.html.StyleClasses;
import org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag.TreeRenderer;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeNodeRenderer
extends CommandRendererBase {
    private static final Log LOG = LogFactory.getLog(TreeNodeRenderer.class);
    protected static final String OPEN_FOLDER = ResourceUtils.createString((String)"image", (String)"treeNode", (String)"icon", (String)"open", (String)"gif");
    protected static final String CLOSED_FOLDER = ResourceUtils.createString((String)"image", (String)"treeNode", (String)"icon", (String)"gif");
    protected static final String LEAF = ResourceUtils.createString((String)"image", (String)"treeNode", (String)"icon", (String)"leaf", (String)"gif");

    public void decode(FacesContext facesContext, UIComponent component) {
        String marked;
        String searchString;
        String selected;
        super.decode(facesContext, component);
        if (ComponentUtil.isOutputOnly((UIComponent)component)) {
            return;
        }
        UITreeNode node = (UITreeNode)component;
        UITree tree = node.findTree();
        String treeId = tree.getClientId(facesContext);
        String nodeStateId = node.nodeStateId(facesContext);
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String id = node.getClientId(facesContext);
        boolean expanded = Boolean.parseBoolean((String)requestParameterMap.get(id + "-expanded"));
        node.setExpanded(expanded);
        if (!TreeRenderer.isSelectable(tree) || StringUtils.contains((String)(selected = (String)requestParameterMap.get(treeId + "-selectState")), (String)(searchString = ";" + nodeStateId + ";"))) {
            // empty if block
        }
        if ((marked = (String)requestParameterMap.get(treeId + "-marker")) != null) {
            searchString = treeId + ':' + nodeStateId;
            node.setMarked(marked.equals(searchString));
        } else {
            LOG.warn((Object)"This log message is help clarifying the occurrence of this else case.");
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        String source;
        UITreeNode node = (UITreeNode)component;
        UITree root = node.findTree();
        MixedTreeModel mixedModel = root.getModel();
        mixedModel.onEncodeBegin();
        TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter((FacesContext)facesContext);
        String treeId = root.getClientId(facesContext);
        DefaultMutableTreeNode modelNode = (DefaultMutableTreeNode)node.getValue();
        boolean folder = mixedModel.isFolder();
        boolean marked = node.isMarked();
        String id = node.getClientId(facesContext);
        boolean menuMode = root.getMode().equals("menu");
        boolean showIcons = root.isShowIcons();
        boolean showJunctions = root.isShowJunctions();
        boolean showRootJunction = root.isShowRootJunction();
        boolean showRoot = root.isShowRoot();
        int depth = mixedModel.getDepth();
        boolean isRoot = mixedModel.isRoot();
        boolean expanded = node.isExpanded() || isRoot && !showRoot;
        boolean hasNextSibling = mixedModel.hasCurrentNodeNextSibling();
        List<Boolean> junctions = mixedModel.getJunctions();
        if (!showRoot && junctions.size() > 0) {
            junctions.remove(0);
        }
        String openSource = null;
        String image = ComponentUtil.getStringAttribute((UIComponent)node, (String)"image");
        String closedSource = image != null ? ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)image) : ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)CLOSED_FOLDER);
        if (folder) {
            openSource = image != null ? ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)ResourceUtils.addPostfixToFilename((String)image, (String)"open"), (boolean)true) : ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)OPEN_FOLDER);
            source = expanded ? openSource : closedSource;
        } else {
            source = image != null ? ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)ResourceUtils.addPostfixToFilename((String)image, (String)"leaf"), (boolean)true) : ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)LEAF);
            if (source == null) {
                source = closedSource;
            }
        }
        CommandRendererHelper helper = new CommandRendererHelper(facesContext, (UICommand)node);
        if (showRoot || !isRoot) {
            writer.startElement("div", null);
            writer.writeIdAttribute(id);
            StyleClasses styleClasses = StyleClasses.ensureStyleClasses((UIComponent)node);
            styleClasses.updateClassAttributeAndMarkup((UIComponent)node, "treeNode");
            if ("menu".equals(root.getMode())) {
                styleClasses.addClass("treeNode", "menu");
                if (marked) {
                    styleClasses.addClass("treeNode", "marker");
                }
            }
            styleClasses.addMarkupClass((UIComponent)node, "treeNode");
            writer.writeClassAttribute(styleClasses);
            Integer width = null;
            HtmlStyleMap style = (HtmlStyleMap)root.getAttributes().get("style");
            if (style != null) {
                width = style.getInt((Object)"width");
            }
            String widthString = width != null ? "width: " + Integer.toString(width - 4) : "100%";
            writer.writeStyleAttribute(widthString);
            if (folder) {
                this.encodeExpandedHidden(writer, node, id, expanded);
            }
            if (folder && menuMode) {
                this.encodeMenuIcon(facesContext, writer, treeId, id, expanded);
            }
            this.encodeIndent(facesContext, writer, menuMode, junctions);
            this.encodeTreeJunction(facesContext, writer, id, treeId, showJunctions, showRootJunction, showRoot, expanded, folder, depth, hasNextSibling, openSource, closedSource);
            this.encodeTreeIcons(writer, id, treeId, showIcons, folder, source, openSource, closedSource);
            this.encodeLabel(writer, helper, node, marked, treeId);
            UIComponent facet = node.getFacet("addendum");
            if (facet != null) {
                RenderUtil.encode((FacesContext)facesContext, (UIComponent)facet);
            }
            writer.endElement("div");
        }
        if (folder) {
            String contentStyle = "display: " + (expanded ? "block" : "none") + ";";
            writer.startElement("div", null);
            writer.writeIdAttribute(id + "-cont");
            writer.writeStyleAttribute(contentStyle);
        }
        if (LOG.isDebugEnabled()) {
            String label = (String)node.getAttributes().get("label");
            int level = modelNode.getLevel();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < level; ++i) {
                builder.append("    ");
            }
            LOG.debug((Object)(builder + "<div name=" + label + ">"));
        }
    }

    private void encodeExpandedHidden(TobagoResponseWriter writer, UITreeNode node, String clientId, boolean expanded) throws IOException {
        writer.startElement("input", (UIComponent)node);
        writer.writeAttribute("type", "hidden", false);
        writer.writeNameAttribute(clientId + "-expanded");
        writer.writeIdAttribute(clientId + "-expanded");
        writer.writeAttribute("value", Boolean.toString(expanded), false);
        writer.endElement("input");
    }

    private void encodeMenuIcon(FacesContext facesContext, TobagoResponseWriter writer, String treeId, String id, boolean expanded) throws IOException {
        String menuOpen = ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)"image/treeMenuOpen.gif");
        String menuClose = ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)"image/treeMenuClose.gif");
        String onclick = "tobagoTreeNodeToggle(this.parentNode, '" + treeId + "', null, null, '" + menuOpen + "', '" + menuClose + "')";
        String src = expanded ? menuOpen : menuClose;
        writer.startElement("img", null);
        writer.writeClassAttribute("tobago-tree-menu-icon");
        writer.writeIdAttribute(id + "-menuIcon");
        writer.writeAttribute("src", src, true);
        writer.writeAttribute("onclick", onclick, true);
        writer.writeAttribute("alt", "", false);
        writer.endElement("img");
    }

    private void encodeIndent(FacesContext facesContext, TobagoResponseWriter writer, boolean menuMode, List<Boolean> junctions) throws IOException {
        String blank = ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)"image/blank.gif");
        String perpendicular = ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)"image/I.gif");
        for (Boolean junction : junctions) {
            writer.startElement("img", null);
            writer.writeClassAttribute("tree-junction");
            if (junction.booleanValue() && !menuMode) {
                writer.writeAttribute("src", perpendicular, true);
            } else {
                writer.writeAttribute("src", blank, true);
            }
            writer.endElement("img");
        }
    }

    private void encodeTreeJunction(FacesContext facesContext, TobagoResponseWriter writer, String id, String treeId, boolean showJunctions, boolean showRootJunction, boolean showRoot, boolean expanded, boolean folder, int depth, boolean hasNextSibling, String openSource, String closedSource) throws IOException {
        if (showJunctions && (showRootJunction || depth != 0) && (showRootJunction || showRoot || depth != 1)) {
            writer.startElement("img", null);
            writer.writeClassAttribute("tree-junction");
            writer.writeIdAttribute(id + "-junction");
            String gif = folder && expanded ? (depth == 0 ? "Rminus.gif" : (hasNextSibling ? "Tminus.gif" : "Lminus.gif")) : (depth == 0 ? "Rplus.gif" : (hasNextSibling ? (folder ? "Tplus.gif" : "T.gif") : (folder ? "Lplus.gif" : "L.gif")));
            String src = ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)("image/" + gif));
            writer.writeAttribute("src", src, true);
            if (folder) {
                writer.writeAttribute("onclick", this.createOnclickForToggle(treeId, openSource, closedSource), true);
            }
            writer.writeAttribute("alt", "", false);
            writer.endElement("img");
        }
    }

    private void encodeTreeIcons(TobagoResponseWriter writer, String id, String treeId, boolean showIcons, boolean folder, String source, String openSource, String closedSource) throws IOException {
        if (showIcons) {
            writer.startElement("img", null);
            writer.writeClassAttribute("tree-icon");
            writer.writeIdAttribute(id + "-icon");
            writer.writeAttribute("src", source, true);
            if (folder) {
                writer.writeAttribute("onclick", this.createOnclickForToggle(treeId, openSource, closedSource), true);
            }
            writer.writeAttribute("alt", "", false);
            writer.endElement("img");
        }
    }

    private String createOnclickForToggle(String treeId, String openSouce, String closedSource) {
        if (openSouce == null) {
            openSouce = closedSource;
        }
        return "tobagoTreeNodeToggle(this.parentNode, '" + treeId + "', '" + openSouce + "', '" + closedSource + "', null, null)";
    }

    private void encodeLabel(TobagoResponseWriter writer, CommandRendererHelper helper, UITreeNode node, boolean marked, String treeId) throws IOException {
        String label;
        Object objTip;
        if (helper.isDisabled()) {
            writer.startElement("span", null);
        } else {
            writer.startElement("a", null);
            writer.writeAttribute("href", helper.getHref(), true);
            writer.writeAttribute("onclick", helper.getOnclick(), true);
            writer.writeAttribute("onfocus", "Tobago.Tree.storeMarker(this.parentNode, '" + treeId + "')", false);
        }
        if (marked) {
            StyleClasses classes = new StyleClasses();
            classes.addClass("treeNode", "marker");
            writer.writeClassAttribute(classes);
        }
        if ((objTip = node.getAttributes().get("tip")) != null) {
            writer.writeAttribute("title", String.valueOf(objTip), true);
        }
        if ((label = (String)node.getAttributes().get("label")) == null) {
            LOG.warn((Object)"label == null");
        }
        writer.writeText(label);
        if (helper.isDisabled()) {
            writer.endElement("span");
        } else {
            writer.endElement("a");
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        UITreeNode node = (UITreeNode)component;
        UITree root = node.findTree();
        MixedTreeModel mixedModel = root.getModel();
        boolean folder = mixedModel.isFolder();
        mixedModel.onEncodeEnd();
        String id = node.getClientId(facesContext);
        TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter((FacesContext)facesContext);
        if (folder) {
            writer.endElement("div");
            writer.writeComment((Object)("\nend of " + id + "-cont "));
        }
        if (LOG.isDebugEnabled()) {
            String label = (String)node.getAttributes().get("label");
            int level = mixedModel.getDepth();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < level; ++i) {
                builder.append("    ");
            }
            LOG.debug((Object)(builder + "</div> <!-- " + label + " -->"));
        }
    }
}

