/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UIColumnEvent;
import org.apache.myfaces.tobago.component.UIColumnSelector;
import org.apache.myfaces.tobago.component.UICommand;
import org.apache.myfaces.tobago.component.UIData;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.component.UIReload;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.ResourceManager;
import org.apache.myfaces.tobago.context.ResourceManagerFactory;
import org.apache.myfaces.tobago.model.SheetState;
import org.apache.myfaces.tobago.renderkit.RenderUtil;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.renderkit.html.HtmlStyleMap;
import org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag.SheetRenderer;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SimpleSheetRenderer
extends SheetRenderer {
    private static final Log LOG = LogFactory.getLog(SimpleSheetRenderer.class);

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        UIData data = (UIData)component;
        this.storeFooterHeight(facesContext, (UIComponent)data);
        if (data.getRowIndex() != -1) {
            LOG.warn((Object)"reset RowIndex");
            data.setRowIndex(-1);
        }
        HtmlRendererUtil.createHeaderAndBodyStyles((FacesContext)facesContext, (UIComponent)data);
        String sheetId = data.getClientId(facesContext);
        HtmlStyleMap sheetStyle = (HtmlStyleMap)data.getAttributes().get("style");
        TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter((FacesContext)facesContext);
        writer.startElement("div", null);
        writer.writeIdAttribute(sheetId + "_outer_div");
        writer.writeClassAttribute("tobago-simpleSheet-content");
        writer.writeStyleAttribute(sheetStyle);
        UICommand clickAction = null;
        UICommand dblClickAction = null;
        int columnSelectorIndex = -1;
        int i = 0;
        for (UIComponent child : data.getChildren()) {
            if (child instanceof UIColumnEvent) {
                UIComponent selectionChild;
                UIColumnEvent columnEvent = (UIColumnEvent)child;
                if (columnEvent.isRendered() && (selectionChild = (UIComponent)child.getChildren().get(0)) != null && selectionChild instanceof UICommand && selectionChild.isRendered()) {
                    UICommand action = (UICommand)selectionChild;
                    if ("click".equals(columnEvent.getEvent())) {
                        clickAction = action;
                    }
                    if ("dblclick".equals(columnEvent.getEvent())) {
                        dblClickAction = action;
                    }
                }
            } else if (child instanceof UIColumnSelector) {
                columnSelectorIndex = i;
            }
            ++i;
        }
        this.renderSheet(facesContext, data, clickAction != null || dblClickAction != null);
        writer.endElement("div");
        ResourceManager resourceManager = ResourceManagerFactory.getResourceManager((FacesContext)facesContext);
        UIViewRoot viewRoot = facesContext.getViewRoot();
        String contextPath = facesContext.getExternalContext().getRequestContextPath();
        String unchecked = contextPath + resourceManager.getImage(viewRoot, "image/sheetUnchecked.gif");
        String checked = contextPath + resourceManager.getImage(viewRoot, "image/sheetChecked.gif");
        boolean ajaxEnabled = TobagoConfig.getInstance((FacesContext)facesContext).isAjaxEnabled();
        String[] styles = new String[]{"style/tobago-sheet.css"};
        String[] scripts = new String[]{"script/tobago-sheet.js"};
        Integer frequency = null;
        UIComponent facetReload = data.getFacet("reload");
        if (facetReload != null && facetReload instanceof UIReload && facetReload.isRendered()) {
            UIReload update = (UIReload)facetReload;
            frequency = update.getFrequency();
        }
        String[] cmds = new String[]{"new Tobago.Sheet(\"" + sheetId + "\", " + ajaxEnabled + ", \"" + checked + "\", \"" + unchecked + "\", \"" + data.getSelectable() + "\", " + columnSelectorIndex + ", " + frequency + ",  " + (clickAction != null ? HtmlRendererUtil.getJavascriptString((String)clickAction.getId()) : null) + ",  " + HtmlRendererUtil.getRenderedPartiallyJavascriptArray((FacesContext)facesContext, (UICommand)clickAction) + ",  " + (dblClickAction != null ? HtmlRendererUtil.getJavascriptString((String)dblClickAction.getId()) : null) + ",  " + HtmlRendererUtil.getRenderedPartiallyJavascriptArray((FacesContext)facesContext, (UICommand)dblClickAction) + ", true);"};
        UIPage page = ComponentUtil.findPage((FacesContext)facesContext, (UIComponent)data);
        page.getStyleFiles().add(styles[0]);
        page.getScriptFiles().add(scripts[0]);
        if (!ajaxEnabled) {
            page.getOnloadScripts().add(cmds[0]);
        } else {
            HtmlRendererUtil.writeStyleLoader((FacesContext)facesContext, (String[])styles);
            HtmlRendererUtil.writeScriptLoader((FacesContext)facesContext, (String[])scripts, (String[])cmds);
        }
    }

    protected void renderSheet(FacesContext facesContext, UIData data, boolean hasClickAction) throws IOException {
        TobagoResponseWriter writer = (TobagoResponseWriter)facesContext.getResponseWriter();
        String sheetId = data.getClientId(facesContext);
        SheetState sheetState = data.getSheetState(facesContext);
        List renderedColumnList = data.getRenderedColumns();
        HtmlStyleMap sheetStyle = (HtmlStyleMap)data.getAttributes().get("style");
        Integer sheetHeight = HtmlRendererUtil.getStyleAttributeIntValue((HtmlStyleMap)sheetStyle, (String)"height");
        if (sheetHeight == null) {
            LOG.error((Object)"no height in parent container, setting to 100");
            sheetHeight = 100;
        }
        int footerHeight = (Integer)data.getAttributes().get("footerHeight");
        HtmlStyleMap bodyStyle = (HtmlStyleMap)data.getAttributes().get("style_body");
        HtmlRendererUtil.replaceStyleAttribute((UIComponent)data, (String)"style_body", (String)"height", (int)(sheetHeight - footerHeight));
        List columnWidths = data.getWidthList();
        writer.startElement("input", null);
        writer.writeIdAttribute(sheetId + "::widths");
        writer.writeNameAttribute(sheetId + "::widths");
        writer.writeAttribute("type", "hidden", false);
        writer.writeAttribute("value", org.apache.myfaces.tobago.util.StringUtils.toString((List)columnWidths), false);
        writer.endElement("input");
        writer.startElement("input", null);
        writer.writeIdAttribute(sheetId + "::scrollPosition");
        writer.writeNameAttribute(sheetId + "::scrollPosition");
        writer.writeAttribute("type", "hidden", false);
        Integer[] scrollPosition = data.getScrollPosition();
        if (scrollPosition != null) {
            String scroll = scrollPosition[0] + ";" + scrollPosition[1];
            writer.writeAttribute("value", scroll, false);
        } else {
            writer.writeAttribute("value", "", false);
        }
        writer.endElement("input");
        List selectedRows = sheetState.getSelectedRows();
        if (!"none".equals(data.getSelectable())) {
            writer.startElement("input", null);
            writer.writeIdAttribute(sheetId + "::selected");
            writer.writeNameAttribute(sheetId + "::selected");
            writer.writeAttribute("type", "hidden", false);
            writer.writeAttribute("value", org.apache.myfaces.tobago.util.StringUtils.toString((List)selectedRows), false);
            writer.endElement("input");
        }
        ResourceManager resourceManager = ResourceManagerFactory.getResourceManager((FacesContext)facesContext);
        UIViewRoot viewRoot = facesContext.getViewRoot();
        String contextPath = facesContext.getExternalContext().getRequestContextPath();
        String selectorDisabled = contextPath + resourceManager.getImage(viewRoot, "image/sheetUncheckedDisabled.gif");
        String unchecked = contextPath + resourceManager.getImage(viewRoot, "image/sheetUnchecked.gif");
        writer.startElement("div", null);
        writer.writeIdAttribute(sheetId + "_data_div");
        writer.writeClassAttribute("tobago-simpleSheet-list");
        writer.writeStyleAttribute(bodyStyle);
        int top = 20;
        boolean odd = false;
        int last = data.getFirst() + data.getRows();
        for (int row = data.getFirst(); row < last; ++row) {
            data.setRowIndex(row);
            if (!data.isRowAvailable()) break;
            odd = !odd;
            String rowClass = odd ? "tobago-sheet-content-odd " : "tobago-sheet-content-even ";
            Object[] rowMarkups = (String[])data.getAttributes().get("rowMarkup");
            String rowMarkup = "";
            if (rowMarkup != null) {
                rowMarkup = " " + StringUtils.join((Object[])rowMarkups, (String)" ");
            }
            writer.startElement("div", null);
            writer.writeClassAttribute("tobago-simpleSheet-row " + rowClass + rowMarkup);
            writer.writeIdAttribute(sheetId + "_data_tr_" + row);
            writer.writeAttribute("style", "top: " + top + "px; left: 0px;", false);
            writer.flush();
            int columnIndex = -1;
            int currentLeft = 0;
            for (UIColumn column : renderedColumnList) {
                writer.startElement("div", null);
                writer.writeClassAttribute("tobago-simpleSheet-cell");
                writer.writeIdAttribute(sheetId + "_" + row + "_" + ++columnIndex);
                String align = (String)column.getAttributes().get("align");
                writer.writeAttribute("style", "top: 0px; left: " + currentLeft + "px; width: " + columnWidths.get(columnIndex) + "px; " + (align != null ? HtmlRendererUtil.toStyleString((String)"text-align", (String)align) : ""), false);
                if (column instanceof UIColumnSelector) {
                    boolean disabled = ComponentUtil.getBooleanAttribute((UIComponent)column, (String)"disabled");
                    writer.startElement("input", null);
                    writer.writeAttribute("type", "checkbox", false);
                    writer.writeAttribute("disabled", disabled);
                    writer.writeIdAttribute(sheetId + "_data_row_selector_" + row);
                    writer.writeClassAttribute("tobago-selectBooleanCheckbox-default");
                    writer.endElement("input");
                } else {
                    List childs = data.getRenderedChildrenOf(column);
                    for (UIComponent grandkid : childs) {
                        grandkid.getAttributes().put("layoutHeight", 0);
                        RenderUtil.encode((FacesContext)facesContext, (UIComponent)grandkid);
                    }
                    if (childs.size() > 1 && LOG.isInfoEnabled()) {
                        LOG.info((Object)"Column should not contain more than one child. Please surround the components with a tc:panel.");
                    }
                }
                writer.endElement("div");
                currentLeft += ((Integer)columnWidths.get(columnIndex)).intValue();
            }
            writer.endElement("div");
            top += 20;
        }
        data.setRowIndex(-1);
        writer.endElement("div");
        String image1x1 = contextPath + resourceManager.getImage(viewRoot, "image/1x1.gif");
        int columnCount = 0;
        int sortMarkerWidth = this.getAscendingMarkerWidth(facesContext, (UIComponent)data);
        String imageAscending = contextPath + resourceManager.getImage(viewRoot, "image/ascending.gif");
        String imageDescending = contextPath + resourceManager.getImage(viewRoot, "image/descending.gif");
        String img = resourceManager.getImage(viewRoot, "image/unsorted.gif", true);
        String imageUnsorted = image1x1;
        if (img != null) {
            imageUnsorted = contextPath + img;
        }
        writer.startElement("div", null);
        writer.writeIdAttribute(sheetId + "_header_div");
        writer.writeClassAttribute("tobago-simpleSheet-header");
        for (UIColumn column : renderedColumnList) {
            this.renderColumnHeader(facesContext, writer, data, columnCount, column, imageAscending, imageDescending, imageUnsorted, image1x1, sortMarkerWidth, false);
            ++columnCount;
        }
        writer.endElement("div");
        this.renderFooter(facesContext, data, writer, sheetId, sheetHeight, this.getFooterHeight(facesContext, (UIComponent)data), bodyStyle);
    }
}

