/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.fo.standard.standard.tag;

import java.text.DecimalFormat;
import java.util.Locale;
import javax.faces.component.UIComponent;

public class Layout {
    public static final int NONE_ORIENTATION = 0;
    public static final int LEFT_ORIENTATION = 1;
    public static final int TOP_ORIENTATION = 2;
    private Layout parent = null;
    private int x;
    private int y;
    private int width;
    private int height;
    private int orientation = 0;

    public Layout(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Layout(int width, int height) {
        this(0, 0, width, height);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public Layout getParent() {
        return this.parent;
    }

    public static String getMM(int value) {
        return DecimalFormat.getNumberInstance(Locale.US).format((double)value / 10.0) + "mm";
    }

    public void setParent(Layout parent) {
        this.parent = parent;
    }

    public int getX() {
        return this.x;
    }

    public String getXMM() {
        return Layout.getMM(this.getX());
    }

    public String getYMM() {
        return Layout.getMM(this.getX());
    }

    public String getHeightMM() {
        return Layout.getMM(this.getHeight());
    }

    public String getWidthMM() {
        return Layout.getMM(this.getWidth());
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void addMargin(int top, int bottom, int left, int right) {
        if (this.orientation != 2) {
            this.x += left;
            this.width -= left + right;
        }
        if (this.orientation != 1) {
            this.height -= top + bottom;
            this.y += top;
        }
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public Layout createWithMargin(int top, int bottom, int left, int right) {
        return new Layout(this.getX() + left, this.getY() + top, this.getWidth() - (left + right), this.getHeight() - (top + bottom));
    }

    public String toInnerString() {
        return "[x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + "]";
    }

    public StringBuilder append(StringBuilder builder) {
        if (this.hasParent()) {
            this.getParent().append(builder);
        }
        builder.append("[x=").append(this.x).append(",y=").append(this.y).append(",width=").append(this.width).append(",height=").append(this.height).append("]\n");
        return builder;
    }

    public String toString() {
        return this.append(new StringBuilder()).toString();
    }

    public static void putLayout(UIComponent component, Layout layout) {
        component.getAttributes().put("fo:layout", layout);
    }

    public static void setInLayout(UIComponent component, boolean layout) {
        component.getAttributes().put("fo:layoutMode", "LayoutMode");
    }

    public static boolean isInLayout(UIComponent component) {
        return component.getAttributes().containsKey("fo:layoutMode");
    }

    public static Layout getLayout(UIComponent component) {
        return (Layout)component.getAttributes().get("fo:layout");
    }
}

