/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeModel {
    private static final Log LOG = LogFactory.getLog(TreeModel.class);
    private Map<String, DefaultMutableTreeNode> nodes = new HashMap<String, DefaultMutableTreeNode>();
    private List<String> keys = new ArrayList<String>();
    private List<Tag> doubleKeys = new ArrayList<Tag>();

    public TreeModel(DefaultMutableTreeNode node) {
        this.putNodes(node, "", 0);
    }

    private void putNodes(DefaultMutableTreeNode node, String position, int index) {
        if (node == null) {
            LOG.warn((Object)"node is null");
            return;
        }
        position = position + "_" + index;
        this.keys.add(position);
        this.doubleKeys.add(new Tag(position, true));
        this.nodes.put(position, node);
        index = 0;
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode subNode = (DefaultMutableTreeNode)e.nextElement();
            this.putNodes(subNode, position, index);
            ++index;
        }
        this.doubleKeys.add(new Tag(position, false));
    }

    public DefaultMutableTreeNode getNode(String pathIndex) {
        return this.nodes.get(pathIndex);
    }

    public List<String> getPathIndexList() {
        return Collections.unmodifiableList(this.keys);
    }

    public List<Tag> getDoublePathIndexList() {
        return Collections.unmodifiableList(this.doubleKeys);
    }

    public String getParentPathIndex(String pathIndex) {
        int lastUnderscore = pathIndex.lastIndexOf(95);
        switch (lastUnderscore) {
            case -1: {
                throw new IllegalArgumentException();
            }
            case 0: {
                return null;
            }
        }
        return pathIndex.substring(0, lastUnderscore);
    }

    public static class Tag {
        private String name;
        private boolean start;

        public Tag(String name, boolean start) {
            this.name = name;
            this.start = start;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isStart() {
            return this.start;
        }

        public void setStart(boolean start) {
            this.start = start;
        }
    }
}

