/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.model;

import org.apache.myfaces.tobago.model.Crud;

public abstract class AbstractCrudController
implements Crud {
    private String defaultOutcome;
    private boolean showDetail;
    private boolean itemEditable;

    protected AbstractCrudController() {
        this.reset();
    }

    public final boolean getShowDetail() {
        return this.showDetail;
    }

    public final boolean isItemEditable() {
        return this.itemEditable;
    }

    public final String deleteItem() {
        this.doDeleteItem();
        return this.getDefaultOutcome();
    }

    protected abstract boolean doDeleteItem();

    public final String showItem() {
        this.itemEditable = false;
        this.showDetail = this.doShowItem();
        return this.getDefaultOutcome();
    }

    public final String editItem() {
        this.itemEditable = true;
        this.showDetail = this.doShowItem();
        return this.getDefaultOutcome();
    }

    protected abstract boolean doShowItem();

    public final String createItem() {
        this.itemEditable = true;
        this.showDetail = this.doCreateItem();
        return this.getDefaultOutcome();
    }

    protected abstract boolean doCreateItem();

    public final String saveItem() {
        this.showDetail = !this.doSaveItem();
        return this.getDefaultOutcome();
    }

    protected abstract boolean doSaveItem();

    public final String cancelItem() {
        this.showDetail = false;
        return this.getDefaultOutcome();
    }

    protected final String getDefaultOutcome() {
        return this.defaultOutcome;
    }

    public final void setDefaultOutcome(String defaultOutcome) {
        this.defaultOutcome = defaultOutcome;
    }

    protected void reset() {
        this.showDetail = false;
        this.itemEditable = false;
    }
}

