/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.TreeModelBuilder;
import org.apache.myfaces.tobago.component.UITreeNode;
import org.apache.myfaces.tobago.model.MixedTreeModel;
import org.apache.myfaces.tobago.model.TreeModel;

public class UITreeData
extends UIInput
implements NamingContainer,
TreeModelBuilder {
    private static final Log LOG = LogFactory.getLog(UITreeData.class);
    public static final String COMPONENT_TYPE = "org.apache.myfaces.tobago.TreeData";
    private String var;
    private TreeModel treeModel;
    private DefaultMutableTreeNode currentNode;
    private String currentNodeId;
    private String currentParentNodeId;
    private String pathIndex;
    private Object marker;
    private Map<String, Object> pathStates = new HashMap<String, Object>();

    public void processDecodes(FacesContext facesContext) {
        this.treeModel = new TreeModel((DefaultMutableTreeNode)this.getValue());
        for (String pathIndex : this.treeModel.getPathIndexList()) {
            this.setPathIndex(pathIndex);
            UITreeNode node = this.getTemplateComponent();
            node.processDecodes(facesContext);
            if (node.isMarked()) {
                this.marker = node.getValue();
            }
            this.setPathIndex(null);
        }
    }

    public void decode(FacesContext facesContext) {
    }

    public String getPathIndex() {
        return this.pathIndex;
    }

    private void setPathIndex(String pathIndex) {
        if (StringUtils.equals((String)this.pathIndex, (String)pathIndex)) {
            return;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UITreeNode template = this.getTemplateComponent();
        this.pathStates.put(this.pathIndex, template.saveState(facesContext));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("save   " + this.pathIndex + " ex=" + template.isExpanded()));
        }
        template.setId(template.getId());
        this.pathIndex = pathIndex;
        if (pathIndex != null) {
            this.currentNode = this.treeModel.getNode(pathIndex);
            facesContext.getExternalContext().getRequestMap().put(this.var, this.currentNode);
            this.currentNodeId = pathIndex;
            this.currentParentNodeId = this.treeModel.getParentPathIndex(pathIndex);
        } else {
            FacesContext.getCurrentInstance().getExternalContext().getRequestMap().remove(this.var);
            this.currentNode = null;
            this.currentNodeId = null;
            this.currentParentNodeId = null;
        }
        Object state = this.pathStates.get(this.pathIndex);
        if (state != null) {
            template.restoreState(facesContext, state);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("restore " + this.pathIndex + " ex=" + template.isExpanded()));
            }
        }
    }

    public void buildBegin(MixedTreeModel model) {
        model.beginBuildNodeData(this);
    }

    public void buildChildren(MixedTreeModel model) {
        for (Object child : this.getChildren()) {
            if (!(child instanceof TreeModelBuilder)) continue;
            TreeModelBuilder builder = (TreeModelBuilder)child;
            builder.buildBegin(model);
            builder.buildChildren(model);
            builder.buildEnd(model);
        }
    }

    public void buildEnd(MixedTreeModel model) {
        model.endBuildNodeData(this);
    }

    public void encodeChildren(FacesContext context) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext) throws IOException {
        this.treeModel = new TreeModel((DefaultMutableTreeNode)this.getValue());
        for (TreeModel.Tag pathIndex : this.treeModel.getDoublePathIndexList()) {
            this.setPathIndex(pathIndex.getName());
            if (pathIndex.isStart()) {
                this.getTemplateComponent().encodeBegin(facesContext);
            } else {
                this.getTemplateComponent().encodeEnd(facesContext);
            }
            this.setPathIndex(null);
        }
        super.encodeEnd(facesContext);
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void updateModel(FacesContext facesContext) {
    }

    public UITreeNode getTemplateComponent() {
        for (Object child : this.getChildren()) {
            if (!(child instanceof UITreeNode)) continue;
            return (UITreeNode)child;
        }
        return null;
    }

    public String getClientId(FacesContext context) {
        String clientId = super.getClientId(context);
        if (this.pathIndex == null) {
            return clientId;
        }
        return clientId + ':' + this.pathIndex;
    }

    public UIComponent findComponent(String searchId) {
        assert (searchId.matches("^(_\\d+)+:.*")) : "The searchId '" + searchId + "' does not start with a tree structure";
        searchId = searchId.substring(searchId.indexOf(58) + 1);
        return super.findComponent(searchId);
    }

    public void queueEvent(FacesEvent event) {
        super.queueEvent((FacesEvent)new FacesEventWrapper(event, this.getPathIndex(), this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof FacesEventWrapper) {
            FacesEvent originalEvent = ((FacesEventWrapper)event).getWrappedFacesEvent();
            String eventPathIndex = ((FacesEventWrapper)event).getPathIndex();
            String currentPathIndex = this.getPathIndex();
            this.setPathIndex(eventPathIndex);
            try {
                originalEvent.getComponent().broadcast(originalEvent);
            }
            finally {
                this.setPathIndex(currentPathIndex);
            }
        } else {
            super.broadcast(event);
        }
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{super.saveState(context), this.var};
        return state;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.var = (String)values[1];
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public DefaultMutableTreeNode getCurrentNode() {
        return this.currentNode;
    }

    public void setCurrentNode(DefaultMutableTreeNode currentNode) {
        this.currentNode = currentNode;
    }

    public String getCurrentNodeId() {
        return this.currentNodeId;
    }

    public void setCurrentNodeId(String currentNodeId) {
        this.currentNodeId = currentNodeId;
    }

    public String getCurrentParentNodeId() {
        return this.currentParentNodeId;
    }

    public void setCurrentParentNodeId(String currentParentNodeId) {
        this.currentParentNodeId = currentParentNodeId;
    }

    public Object getMarker() {
        return this.marker;
    }

    private static class FacesEventWrapper
    extends FacesEvent {
        private static final long serialVersionUID = 1L;
        private FacesEvent wrappedFacesEvent;
        private String pathIndex;

        FacesEventWrapper(FacesEvent facesEvent, String pathIndex, UITreeData redirectComponent) {
            super((UIComponent)redirectComponent);
            this.wrappedFacesEvent = facesEvent;
            this.pathIndex = pathIndex;
        }

        public PhaseId getPhaseId() {
            return this.wrappedFacesEvent.getPhaseId();
        }

        public void setPhaseId(PhaseId phaseId) {
            this.wrappedFacesEvent.setPhaseId(phaseId);
        }

        public void queue() {
            this.wrappedFacesEvent.queue();
        }

        public String toString() {
            return this.wrappedFacesEvent.toString();
        }

        public boolean isAppropriateListener(FacesListener faceslistener) {
            return this.wrappedFacesEvent.isAppropriateListener(faceslistener);
        }

        public void processListener(FacesListener faceslistener) {
            this.wrappedFacesEvent.processListener(faceslistener);
        }

        public FacesEvent getWrappedFacesEvent() {
            return this.wrappedFacesEvent;
        }

        public String getPathIndex() {
            return this.pathIndex;
        }
    }
}

