/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.TreeModelBuilder;
import org.apache.myfaces.tobago.component.UITreeData;
import org.apache.myfaces.tobago.component.UITreeNode;
import org.apache.myfaces.tobago.model.MixedTreeModel;

public class UITree
extends UIInput
implements NamingContainer {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.tobago.Tree";
    public static final String MESSAGE_NOT_LEAF = "tobago.tree.MESSAGE_NOT_LEAF";
    public static final String SEP = "-";
    public static final String TREE_STATE = "-treeState";
    public static final String SELECT_STATE = "-selectState";
    public static final String MARKER = "-marker";
    public static final String FACET_TREE_NODE_COMMAND = "treeNodeCommand";
    public static final String PARAMETER_TREE_NODE_ID = "treeNodeId";
    private boolean showJunctions = true;
    private boolean showJunctionsSet = false;
    private boolean showIcons = true;
    private boolean showIconsSet = false;
    private boolean showRoot = true;
    private boolean showRootSet = false;
    private boolean showRootJunction = true;
    private boolean showRootJunctionSet = false;
    private String mode;
    private MixedTreeModel model;

    public String getMode() {
        if (this.mode != null) {
            return this.mode;
        }
        ValueBinding vb = this.getValueBinding("mode");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext());
        }
        return "tree";
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public UIComponent getRoot() {
        for (UIComponent child : this.getChildren()) {
            if (child instanceof UITreeNode) {
                return child;
            }
            if (!(child instanceof UITreeData)) continue;
            return child;
        }
        return null;
    }

    public void encodeEnd(FacesContext context) throws IOException {
        this.model = new MixedTreeModel();
        this.buildModel();
        super.encodeEnd(context);
    }

    private void buildModel() {
        for (Object child : this.getChildren()) {
            if (!(child instanceof TreeModelBuilder)) continue;
            TreeModelBuilder builder = (TreeModelBuilder)child;
            builder.buildBegin(this.model);
            builder.buildChildren(this.model);
            builder.buildEnd(this.model);
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    public boolean isSelectableTree() {
        Object selectable = ComponentUtil.getAttribute((UIComponent)this, (String)"selectable");
        return selectable != null && (selectable.equals("multi") || selectable.equals("multiLeafOnly") || selectable.equals("single") || selectable.equals("singleLeafOnly") || selectable.equals("sibling") || selectable.equals("siblingLeafOnly"));
    }

    public void processDecodes(FacesContext facesContext) {
        if (!this.isRendered()) {
            return;
        }
        if (ComponentUtil.isOutputOnly((UIComponent)this)) {
            this.setValid(true);
        } else {
            this.decode(facesContext);
            Iterator i = this.getFacetsAndChildren();
            while (i.hasNext()) {
                UIComponent uiComponent = (UIComponent)i.next();
                uiComponent.processDecodes(facesContext);
            }
        }
    }

    public void validate(FacesContext context) {
        if (this.getValidators() != null) {
            for (Validator validator : this.getValidators()) {
                try {
                    validator.validate(context, (UIComponent)this, null);
                }
                catch (ValidatorException ve) {
                    this.setValid(false);
                    FacesMessage message = ve.getFacesMessage();
                    if (message == null) continue;
                    message.setSeverity(FacesMessage.SEVERITY_ERROR);
                    context.addMessage(this.getClientId(context), message);
                }
            }
        }
    }

    public void updateModel(FacesContext facesContext) {
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{super.saveState(context), this.showJunctionsSet ? Boolean.valueOf(this.showJunctions) : null, this.showIconsSet ? Boolean.valueOf(this.showIcons) : null, this.showRootSet ? Boolean.valueOf(this.showRoot) : null, this.showRootJunctionSet ? Boolean.valueOf(this.showRootJunction) : null, this.mode};
        return state;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        if (values[1] != null) {
            this.showJunctions = (Boolean)values[1];
            this.showJunctionsSet = true;
        }
        if (values[2] != null) {
            this.showIcons = (Boolean)values[2];
            this.showIconsSet = true;
        }
        if (values[3] != null) {
            this.showRoot = (Boolean)values[3];
            this.showRootSet = true;
        }
        if (values[4] != null) {
            this.showRootJunction = (Boolean)values[4];
            this.showRootJunctionSet = true;
        }
        this.mode = (String)values[5];
    }

    public boolean isShowJunctions() {
        if (this.showJunctionsSet) {
            return this.showJunctions;
        }
        ValueBinding vb = this.getValueBinding("showJunctions");
        if (vb != null) {
            return !Boolean.FALSE.equals(vb.getValue(this.getFacesContext()));
        }
        return this.showJunctions;
    }

    public void setShowJunctions(boolean showJunctions) {
        this.showJunctions = showJunctions;
        this.showJunctionsSet = true;
    }

    public boolean isShowIcons() {
        if (this.showIconsSet) {
            return this.showIcons;
        }
        ValueBinding vb = this.getValueBinding("showIcons");
        if (vb != null) {
            return !Boolean.FALSE.equals(vb.getValue(this.getFacesContext()));
        }
        return this.showIcons;
    }

    public void setShowIcons(boolean showIcons) {
        this.showIcons = showIcons;
        this.showIconsSet = true;
    }

    public boolean isShowRoot() {
        if (this.showRootSet) {
            return this.showRoot;
        }
        ValueBinding vb = this.getValueBinding("showRoot");
        if (vb != null) {
            return !Boolean.FALSE.equals(vb.getValue(this.getFacesContext()));
        }
        return this.showRoot;
    }

    public void setShowRoot(boolean showRoot) {
        this.showRoot = showRoot;
        this.showRootSet = true;
    }

    public boolean isShowRootJunction() {
        if (this.showRootJunctionSet) {
            return this.showRootJunction;
        }
        ValueBinding vb = this.getValueBinding("showRootJunction");
        if (vb != null) {
            return !Boolean.FALSE.equals(vb.getValue(this.getFacesContext()));
        }
        return this.showRootJunction;
    }

    public void setShowRootJunction(boolean showRootJunction) {
        this.showRootJunction = showRootJunction;
        this.showRootJunctionSet = true;
    }

    public MixedTreeModel getModel() {
        return this.model;
    }

    public static class Command
    implements Serializable {
        private String command;

        public Command(String command) {
            this.command = command;
        }

        public String getCommand() {
            return this.command;
        }
    }
}

