/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.component.UISelectBoolean;
import javax.faces.component.UISelectOne;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.commons.lang.ObjectUtils;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UIMenuSelectOne;
import org.apache.myfaces.tobago.component.UISelectBooleanCommand;
import org.apache.myfaces.tobago.component.UISelectOneCommand;
import org.apache.myfaces.tobago.context.ResourceManager;
import org.apache.myfaces.tobago.context.ResourceManagerFactory;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.LayoutableRendererBase;
import org.apache.myfaces.tobago.renderkit.RenderUtil;
import org.apache.myfaces.tobago.renderkit.html.CommandRendererHelper;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.util.AccessKeyMap;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public abstract class ToolBarRendererBase
extends LayoutableRendererBase {
    static /* synthetic */ Class class$org$apache$myfaces$tobago$model$SelectItem;

    protected String getLabelPosition(UIComponent component) {
        return (String)component.getAttributes().get("labelPosition");
    }

    protected String getIconSize(UIComponent component) {
        return (String)component.getAttributes().get("iconSize");
    }

    public void encodeEnd(FacesContext context, UIComponent uiComponent) throws IOException {
        UIPanel toolbar = (UIPanel)uiComponent;
        TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter((FacesContext)context);
        List children = toolbar.getChildren();
        boolean first = true;
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            UIComponent component = (UIComponent)iter.next();
            if (component instanceof UICommand) {
                boolean last = !iter.hasNext();
                this.renderToolbarCommand(context, (UICommand)component, writer, first, last);
                first = false;
                continue;
            }
            LOG.error((Object)("Illegal UIComponent class in toolbar :" + component.getClass().getName()));
        }
    }

    private void renderToolbarCommand(FacesContext facesContext, UICommand command, TobagoResponseWriter writer, boolean first, boolean last) throws IOException {
        if (command instanceof UISelectBooleanCommand) {
            this.renderSelectBoolean(facesContext, command, writer, first, last);
        } else if (command instanceof UISelectOneCommand) {
            this.renderSelectOne(facesContext, command, writer, first, last);
        } else if (command.getFacet("items") != null) {
            UIComponent facet = command.getFacet("items");
            if (facet instanceof UISelectBoolean) {
                this.renderSelectBoolean(facesContext, command, writer, first, last);
            } else if (facet instanceof UISelectOne) {
                this.renderSelectOne(facesContext, command, writer, first, last);
            }
        } else {
            String onClick = this.createOnClick(facesContext, (UIComponent)command);
            this.renderToolbarButton(facesContext, command, writer, first, last, false, onClick);
        }
    }

    private void renderSelectOne(FacesContext facesContext, UICommand command, TobagoResponseWriter writer, boolean first, boolean last) throws IOException {
        List items;
        String onclick = this.createOnClick(facesContext, (UIComponent)command);
        UIMenuSelectOne radio = (UIMenuSelectOne)command.getFacet("items");
        if (radio == null) {
            items = ComponentUtil.getSelectItems((UIComponent)command);
            radio = ComponentUtil.createUIMenuSelectOneFacet((FacesContext)facesContext, (UICommand)command);
            radio.setId(facesContext.getViewRoot().createUniqueId());
        } else {
            items = ComponentUtil.getSelectItems((UIComponent)radio);
        }
        if (radio != null) {
            Object value = radio.getValue();
            boolean markFirst = !ComponentUtil.hasSelectedValue((List)items, (Object)value);
            String radioId = radio.getClientId(facesContext);
            String onClickPrefix = "menuSetRadioValue('" + radioId + "', '";
            String onClickPostfix = onclick != null ? "') ; " + onclick : "";
            Iterator i$ = items.iterator();
            while (i$.hasNext()) {
                boolean checked;
                SelectItem item = (SelectItem)i$.next();
                String labelText = item.getLabel();
                if (labelText != null) {
                    command.getAttributes().put("label", labelText);
                } else {
                    LOG.warn((Object)("Menu item has label=null. UICommand.getClientId()=" + command.getClientId(facesContext)));
                }
                String image = null;
                if (item instanceof org.apache.myfaces.tobago.model.SelectItem) {
                    image = ((org.apache.myfaces.tobago.model.SelectItem)item).getImage();
                } else if (LOG.isDebugEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer().append("select item is not ");
                    Class<?> clazz = class$org$apache$myfaces$tobago$model$SelectItem;
                    if (clazz == null) {
                        clazz = new org.apache.myfaces.tobago.model.SelectItem[0].getClass().getComponentType();
                    }
                    LOG.debug((Object)stringBuffer.append(clazz.getName()).toString());
                }
                if (image == null) {
                    image = "image/1x1.gif";
                }
                command.getAttributes().put("image", image);
                if (item.getDescription() != null) {
                    command.getAttributes().put("tip", item.getDescription());
                }
                String formattedValue = RenderUtil.getFormattedValue((FacesContext)facesContext, (UIComponent)radio, (Object)item.getValue());
                onclick = onClickPrefix + formattedValue + onClickPostfix;
                if (ObjectUtils.equals((Object)item.getValue(), (Object)value) || markFirst) {
                    checked = true;
                    markFirst = false;
                    writer.writeJavascript("    " + onClickPrefix + formattedValue + "');");
                } else {
                    checked = false;
                }
                this.renderToolbarButton(facesContext, command, writer, first, last, checked, onclick);
            }
        }
    }

    private void renderSelectBoolean(FacesContext facesContext, UICommand command, TobagoResponseWriter writer, boolean first, boolean last) throws IOException {
        UIComponent checkbox = command.getFacet("items");
        if (checkbox == null) {
            checkbox = ComponentUtil.createUISelectBooleanFacet((FacesContext)facesContext, (UICommand)command);
            checkbox.setId(facesContext.getViewRoot().createUniqueId());
        }
        boolean checked = ComponentUtil.getBooleanAttribute((UIComponent)checkbox, (String)"value");
        String onClick = this.createOnClick(facesContext, (UIComponent)command);
        String clientId = checkbox.getClientId(facesContext);
        onClick = RenderUtil.addMenuCheckToggle((String)clientId, (String)onClick);
        if (checked) {
            writer.writeJavascript("    menuCheckToggle('" + clientId + "');\n");
        }
        this.renderToolbarButton(facesContext, command, writer, first, last, checked, onClick);
    }

    private void renderToolbarButton(FacesContext facesContext, UICommand command, TobagoResponseWriter writer, boolean first, boolean last, boolean selected, String onClick) throws IOException {
        boolean popupOn2;
        boolean anchorOnLabel;
        if (!command.isRendered()) {
            return;
        }
        String clientId = command.getClientId(facesContext);
        boolean disabled = ComponentUtil.getBooleanAttribute((UIComponent)command, (String)"disabled");
        LabelWithAccessKey label = new LabelWithAccessKey((UIComponent)command);
        UIComponent popupMenu = command.getFacet("menupopup");
        String labelPosition = this.getLabelPosition(command.getParent());
        String iconSize = this.getIconSize(command.getParent());
        String iconName = (String)command.getAttributes().get("image");
        String image = this.getImage(facesContext, iconName, iconSize, disabled, selected);
        String graphicId = clientId + "::" + "icon";
        String hover = this.getHoverClasses(first, last);
        String mouseOverScript = "Tobago.toolbarMousesover(this, '" + hover + "', '" + graphicId + "');";
        String mouseOutScript = "Tobago.toolbarMousesout(this, '" + hover + "', '" + graphicId + "');";
        writer.startElement("div", null);
        writer.writeIdAttribute(command.getClientId(facesContext));
        String divClasses = this.getDivClasses(selected, disabled);
        writer.writeClassAttribute(divClasses);
        if (!disabled) {
            writer.writeAttribute("onmouseover", (Object)mouseOverScript, null);
            writer.writeAttribute("onmouseout", (Object)mouseOutScript, null);
            writer.writeAttribute("onclick", (Object)onClick, null);
        }
        writer.startElement("table", null);
        writer.writeAttribute("cellpadding", 0);
        writer.writeAttribute("cellspacing", 0);
        writer.writeAttribute("summary", "", false);
        writer.writeAttribute("border", 0);
        String tableClasses = this.getTableClasses(selected, disabled);
        writer.writeClassAttribute(tableClasses);
        writer.startElement("tr", null);
        boolean bl = anchorOnLabel = label.getText() != null && !"off".equals(labelPosition);
        if (!"off".equals(iconSize)) {
            boolean render1pxImage;
            HtmlRendererUtil.addImageSources((FacesContext)facesContext, (TobagoResponseWriter)writer, (String)(iconName != null ? iconName : "image/1x1.gif"), (String)graphicId);
            writer.startElement("td", (UIComponent)command);
            writer.writeAttribute("align", "center", false);
            HtmlRendererUtil.renderTip((UIComponent)command, (TobagoResponseWriter)writer);
            boolean bl2 = render1pxImage = iconName == null && !"bottom".equals(labelPosition) && label.getText() != null;
            if ((!"off".equals(labelPosition) && label.getText() != null || popupMenu != null) && !render1pxImage) {
                writer.writeStyleAttribute("padding-right: 3px;");
            }
            String className = this.getIconClass(iconSize);
            if (!anchorOnLabel) {
                this.renderAnchorBegin(facesContext, writer, command, label, disabled);
            }
            writer.startElement("img", (UIComponent)command);
            writer.writeIdAttribute(graphicId);
            writer.writeAttribute("src", image, false);
            writer.writeAttribute("alt", "", false);
            HtmlRendererUtil.renderTip((UIComponent)command, (TobagoResponseWriter)writer);
            writer.writeAttribute("border", 0);
            writer.writeClassAttribute(className);
            if (render1pxImage) {
                writer.writeStyleAttribute("width: 1px;");
            }
            writer.endElement("img");
            if (!anchorOnLabel) {
                writer.endElement("a");
            }
            writer.endElement("td");
        }
        boolean bl3 = popupOn2 = "bottom".equals(labelPosition) && !"off".equals(iconSize);
        if (popupOn2) {
            if (popupMenu != null) {
                this.renderPopupTd(facesContext, writer, (UIComponent)command, popupMenu, true);
            }
            writer.endElement("tr");
            writer.startElement("tr", null);
        }
        if (!"off".equals(labelPosition)) {
            writer.startElement("td", null);
            writer.writeClassAttribute("tobago-toolbar-label-td");
            writer.writeAttribute("align", "center", false);
            if (popupMenu != null) {
                writer.writeAttribute("style", "padding-right: 3px;", false);
            }
            if (label.getText() != null) {
                this.renderAnchorBegin(facesContext, writer, command, label, disabled);
                HtmlRendererUtil.writeLabelWithAccessKey((TobagoResponseWriter)writer, (LabelWithAccessKey)label);
                writer.endElement("a");
            }
            writer.endElement("td");
        }
        if (!popupOn2 && popupMenu != null) {
            this.renderPopupTd(facesContext, writer, (UIComponent)command, popupMenu, false);
        }
        writer.endElement("tr");
        writer.endElement("table");
        writer.endElement("div");
    }

    protected String getIconClass(String iconSize) {
        return "tobago-image-default tobago-toolBar-button-image tobago-toolBar-button-image-" + iconSize;
    }

    protected abstract String getHoverClasses(boolean var1, boolean var2);

    protected abstract String getTableClasses(boolean var1, boolean var2);

    protected abstract String getDivClasses(boolean var1, boolean var2);

    private String createOnClick(FacesContext facesContext, UIComponent component) {
        if (component.getFacet("menupopup") != null && ((UICommand)component).getAction() == null && ((UICommand)component).getActionListener() == null && ((UICommand)component).getActionListeners().length == 0) {
            String searchId = component.getClientId(facesContext) + "::popup";
            return "tobagoButtonOpenMenu(this, '" + searchId + "')";
        }
        CommandRendererHelper helper = new CommandRendererHelper(facesContext, (UICommand)component);
        return helper.getOnclick();
    }

    private String getImage(FacesContext facesContext, String name, String iconSize, boolean disabled, boolean selected) {
        if (name == null) {
            return ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)"image/1x1.gif");
        }
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            pos = name.length();
        }
        String key = name.substring(0, pos);
        String ext = name.substring(pos);
        String size = "";
        if ("small".equals(iconSize)) {
            size = "16";
        } else if ("big".equals(iconSize)) {
            size = "32";
        }
        String image = null;
        ResourceManager resourceManager = ResourceManagerFactory.getResourceManager((FacesContext)facesContext);
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (disabled && selected && (image = resourceManager.getImage(viewRoot, key + "SelectedDisabled" + size + ext, true)) == null) {
            image = resourceManager.getImage(viewRoot, key + "SelectedDisabled" + ext, true);
        }
        if (image == null && disabled && (image = resourceManager.getImage(viewRoot, key + "Disabled" + size + ext, true)) == null) {
            image = resourceManager.getImage(viewRoot, key + "Disabled" + ext, true);
        }
        if (image == null && selected && (image = resourceManager.getImage(viewRoot, key + "Selected" + size + ext, true)) == null) {
            image = resourceManager.getImage(viewRoot, key + "Selected" + ext, true);
        }
        if (image == null && (image = resourceManager.getImage(viewRoot, key + size + ext, true)) == null) {
            image = resourceManager.getImage(viewRoot, key + ext, true);
        }
        String contextPath = facesContext.getExternalContext().getRequestContextPath();
        return contextPath + image;
    }

    private void renderAnchorBegin(FacesContext facesContext, TobagoResponseWriter writer, UICommand command, LabelWithAccessKey label, boolean disabled) throws IOException {
        writer.startElement("a", (UIComponent)command);
        writer.writeClassAttribute(this.getAnchorClass(disabled));
        HtmlRendererUtil.renderTip((UIComponent)command, (TobagoResponseWriter)writer);
        if (!disabled) {
            writer.writeAttribute("href", "#", false);
            writer.writeAttribute("onfocus", "Tobago.toolbarFocus(this, event)", false);
            String id = command.getClientId(facesContext) + "::" + "link";
            writer.writeIdAttribute(id);
            if (label.getAccessKey() != null) {
                if (LOG.isInfoEnabled() && !AccessKeyMap.addAccessKey((FacesContext)facesContext, (Character)label.getAccessKey())) {
                    LOG.info((Object)("dublicated accessKey : " + label.getAccessKey()));
                }
                HtmlRendererUtil.addClickAcceleratorKey((FacesContext)facesContext, (String)id, (char)label.getAccessKey().charValue());
            }
        }
    }

    protected String getAnchorClass(boolean disabled) {
        return "tobago-toolBar-button-link" + (disabled ? " tobago-toolBar-button-link-disabled" : "");
    }

    private void renderPopupTd(FacesContext facesContext, TobagoResponseWriter writer, UIComponent command, UIComponent popupMenu, boolean labelBottom) throws IOException {
        writer.startElement("td", null);
        if (labelBottom) {
            writer.writeAttribute("rowspan", 2);
        }
        if (popupMenu != null) {
            String backgroundImage = ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)"image/1x1.gif");
            writer.startElement("div", null);
            writer.writeIdAttribute(command.getClientId(facesContext) + "::" + "popup");
            writer.writeClassAttribute("tobago-toolBar-button-menu");
            writer.startElement("img", null);
            writer.writeAttribute("src", backgroundImage, false);
            writer.writeClassAttribute("tobago-toolBar-button-menu-background-image");
            writer.endElement("img");
            writer.endElement("div");
            popupMenu.getAttributes().put("menuPopup", Boolean.TRUE);
            popupMenu.getAttributes().put("menuPopupType", "ToolBarButton");
            popupMenu.setRendererType("MenuBar");
            popupMenu.getAttributes().remove("label");
            popupMenu.getAttributes().put("image", "image/toolbarButtonMenu.gif");
            RenderUtil.encode((FacesContext)facesContext, (UIComponent)popupMenu);
        }
        writer.endElement("td");
    }

    public int getFixedHeight(FacesContext facesContext, UIComponent component) {
        Map attributes = component.getAttributes();
        String labelPosition = this.getLabelPosition(component);
        String iconSize = this.getIconSize(component);
        String key = iconSize + "_" + labelPosition + "_Height";
        return this.getConfiguredValue(facesContext, component, key);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

