/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.facelets;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.el.LegacyMethodBinding;
import com.sun.facelets.el.LegacyValueBinding;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributeException;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagException;
import com.sun.facelets.tag.TagHandler;
import java.io.IOException;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.tobago.event.TabChangeEvent;
import org.apache.myfaces.tobago.event.TabChangeListener;
import org.apache.myfaces.tobago.event.TabChangeListenerValueBindingDelegate;
import org.apache.myfaces.tobago.event.TabChangeSource;

public class TabChangeListenerHandler
extends TagHandler {
    private static final Class[] TAB_CHANGE_LISTENER_ARGS = new Class[]{TabChangeEvent.class};
    private Class listenerType;
    private final TagAttribute type;
    private final TagAttribute binding = this.getAttribute("binding");
    private final TagAttribute listener;

    public TabChangeListenerHandler(TagConfig config) {
        super(config);
        this.type = this.getAttribute("type");
        this.listener = this.getAttribute("listener");
        if (this.type != null) {
            if (!this.type.isLiteral()) {
                throw new TagAttributeException(this.tag, this.type, "Must be literal");
            }
            try {
                this.listenerType = Class.forName(this.type.getValue());
            }
            catch (Exception e) {
                throw new TagAttributeException(this.tag, this.type, (Throwable)e);
            }
        }
    }

    public void apply(FaceletContext faceletContext, UIComponent parent) throws IOException, FacesException, ELException {
        if (parent instanceof TabChangeSource) {
            if (parent.getParent() == null) {
                TabChangeSource changeSource = (TabChangeSource)parent;
                TabChangeListener changeListener = null;
                ValueExpression valueExpression = null;
                if (this.binding != null) {
                    valueExpression = this.binding.getValueExpression(faceletContext, TabChangeListener.class);
                    changeListener = (TabChangeListener)valueExpression.getValue((ELContext)faceletContext);
                }
                if (changeListener == null) {
                    try {
                        changeListener = (TabChangeListener)this.listenerType.newInstance();
                    }
                    catch (Exception e) {
                        throw new TagAttributeException(this.tag, this.type, e.getCause());
                    }
                    if (valueExpression != null) {
                        valueExpression.setValue((ELContext)faceletContext, (Object)changeListener);
                    }
                }
                if (valueExpression != null) {
                    changeSource.addTabChangeListener((TabChangeListener)new TabChangeListenerValueBindingDelegate(this.type.getValue(), (ValueBinding)new LegacyValueBinding(valueExpression)));
                } else {
                    changeSource.addTabChangeListener(changeListener);
                }
                if (this.listener != null && !this.listener.isLiteral()) {
                    changeSource.setTabChangeListener((MethodBinding)new LegacyMethodBinding(this.listener.getMethodExpression(faceletContext, null, TAB_CHANGE_LISTENER_ARGS)));
                }
            }
        } else {
            throw new TagException(this.tag, "Parent is not of type TabChangeSource, type is: " + parent);
        }
    }
}

