/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.facelets;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.el.LegacyValueBinding;
import com.sun.facelets.tag.MetaRule;
import com.sun.facelets.tag.Metadata;
import com.sun.facelets.tag.MetadataTarget;
import com.sun.facelets.tag.TagAttribute;
import javax.faces.component.UIComponent;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UIPage;

public class PageRule
extends MetaRule {
    public static final PageRule INSTANCE = new PageRule();

    public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget metadataTarget) {
        if (metadataTarget.isTargetInstanceOf(UIPage.class) && attribute.isLiteral()) {
            if ("width".equals(name)) {
                return new PageWidthMapper(attribute);
            }
            if ("height".equals(name)) {
                return new PageHeightMapper(attribute);
            }
        }
        return null;
    }

    static final class PageHeightMapper
    extends Metadata {
        private final TagAttribute attribute;

        PageHeightMapper(TagAttribute attribute) {
            this.attribute = attribute;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            UIPage page = (UIPage)instance;
            page.setHeight(new Integer(ComponentUtil.removePx((String)this.attribute.getValue())));
        }
    }

    static final class PageWidthMapper
    extends Metadata {
        private final TagAttribute attribute;

        PageWidthMapper(TagAttribute attribute) {
            this.attribute = attribute;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            UIPage page = (UIPage)instance;
            page.setWidth(new Integer(ComponentUtil.removePx((String)this.attribute.getValue())));
        }
    }

    static final class PageDimensionExpression
    extends Metadata {
        private final String name;
        private final TagAttribute attr;
        private final Class type;

        PageDimensionExpression(String name, Class type, TagAttribute attr) {
            this.name = name;
            this.attr = attr;
            this.type = type;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((UIComponent)instance).setValueBinding(this.name, (ValueBinding)new LegacyValueBinding(this.attr.getValueExpression(ctx, this.type)));
        }
    }
}

