/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectItems;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.renderkit.RenderUtil;
import org.apache.myfaces.tobago.renderkit.SelectOneRendererBase;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.renderkit.html.StyleClasses;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SelectOneRadioRenderer
extends SelectOneRendererBase {
    private static final Log LOG = LogFactory.getLog(SelectOneRadioRenderer.class);

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        if (!(component instanceof org.apache.myfaces.tobago.component.UISelectOne)) {
            LOG.error((Object)("Wrong type: Need " + org.apache.myfaces.tobago.component.UISelectOne.class.getName() + ", but was " + component.getClass().getName()));
            return;
        }
        org.apache.myfaces.tobago.component.UISelectOne selectOne = (org.apache.myfaces.tobago.component.UISelectOne)component;
        String clientId = selectOne.getClientId(facesContext);
        ComponentUtil.findPage((FacesContext)facesContext, (UIComponent)selectOne).getOnloadScripts().add("Tobago.selectOneRadioInit('" + clientId + "')");
        if (LOG.isDebugEnabled()) {
            for (Object o : selectOne.getChildren()) {
                LOG.debug((Object)("ITEMS " + o));
                if (!(o instanceof UISelectItems)) continue;
                UISelectItems uiitems = (UISelectItems)o;
                Object v = uiitems.getValue();
                LOG.debug((Object)("VALUE " + v));
                if (v == null) continue;
                LOG.debug((Object)("VALUE " + v.getClass().getName()));
            }
        }
        List items = ComponentUtil.getItemsToRender((UISelectOne)selectOne);
        boolean inline = ComponentUtil.getBooleanAttribute((UIComponent)selectOne, (String)"inline");
        String title = HtmlRendererUtil.getTitleFromTipAndMessages((FacesContext)facesContext, (UIComponent)selectOne);
        TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter((FacesContext)facesContext);
        if (!inline) {
            writer.startElement("table", (UIComponent)selectOne);
            writer.writeAttribute("border", 0);
            writer.writeAttribute("cellspacing", 0);
            writer.writeAttribute("cellpadding", 0);
            writer.writeAttribute("summary", "", false);
            writer.writeStyleAttribute();
            if (title != null) {
                writer.writeAttribute("title", title, true);
            }
        }
        boolean disabled = ComponentUtil.getBooleanAttribute((UIComponent)selectOne, (String)"disabled");
        boolean readonly = ComponentUtil.getBooleanAttribute((UIComponent)selectOne, (String)"readonly");
        Object value = selectOne.getValue();
        ArrayList<String> clientIds = new ArrayList<String>();
        int i = 0;
        for (SelectItem item : items) {
            Integer tabIndex;
            if (!inline) {
                writer.startElement("tr", null);
                writer.startElement("td", null);
            }
            String id = clientId + ':' + ':' + i++;
            clientIds.add(id);
            writer.startElement("input", (UIComponent)selectOne);
            writer.writeAttribute("type", "radio", false);
            writer.writeClassAttribute();
            boolean checked = ObjectUtils.equals((Object)item.getValue(), (Object)value);
            if (checked) {
                writer.writeAttribute("checked", "checked", false);
            }
            writer.writeNameAttribute(clientId);
            writer.writeIdAttribute(id);
            String formattedValue = RenderUtil.getFormattedValue((FacesContext)facesContext, (UIComponent)selectOne, (Object)item.getValue());
            writer.writeAttribute("value", formattedValue, true);
            writer.writeAttribute("disabled", item.isDisabled() || disabled);
            if (readonly) {
                writer.writeAttribute("readonly", true);
            }
            if ((tabIndex = selectOne.getTabIndex()) != null) {
                writer.writeAttribute("tabindex", tabIndex.intValue());
            }
            HtmlRendererUtil.renderTip((UIComponent)selectOne, (TobagoResponseWriter)writer);
            if (!ComponentUtil.getBooleanAttribute((UIComponent)selectOne, (String)"required") || readonly) {
                writer.writeAttribute("onclick", "Tobago.selectOneRadioClick(this, '" + clientId + "'," + ComponentUtil.getBooleanAttribute((UIComponent)selectOne, (String)"required") + " , " + readonly + ")", false);
            }
            writer.endElement("input");
            if (item.getLabel() != null) {
                if (!inline) {
                    writer.endElement("td");
                    writer.startElement("td", null);
                    writer.writeStyleAttribute("width: 100%;");
                }
                writer.startElement("label", null);
                StyleClasses styleClasses = new StyleClasses();
                styleClasses.addAspectClass("label", StyleClasses.Aspect.DEFAULT);
                if (item.isDisabled() || disabled) {
                    styleClasses.addAspectClass("label", StyleClasses.Aspect.DISABLED);
                }
                if (readonly) {
                    styleClasses.addAspectClass("label", StyleClasses.Aspect.READONLY);
                }
                writer.writeClassAttribute(styleClasses);
                writer.writeAttribute("for", id, false);
                writer.writeText(item.getLabel());
                writer.endElement("label");
            }
            if (inline) continue;
            writer.endElement("td");
            writer.endElement("tr");
        }
        if (!inline) {
            writer.endElement("table");
        }
        this.checkForCommandFacet((UIComponent)selectOne, clientIds, facesContext, writer);
        HtmlRendererUtil.renderFocusId((FacesContext)facesContext, (UIInput)selectOne);
    }

    public int getFixedHeight(FacesContext facesContext, UIComponent component) {
        int heightPerRow = super.getFixedHeight(facesContext, component);
        if (ComponentUtil.getBooleanAttribute((UIComponent)component, (String)"inline")) {
            return heightPerRow;
        }
        List items = ComponentUtil.getItemsToRender((UISelectOne)((org.apache.myfaces.tobago.component.UISelectOne)component));
        return items.size() * heightPerRow;
    }
}

