/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UISelectMany;
import org.apache.myfaces.tobago.renderkit.SelectManyRendererBase;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.util.LayoutUtil;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SelectManyListboxRenderer
extends SelectManyRendererBase {
    private static final Log LOG = LogFactory.getLog(SelectManyListboxRenderer.class);

    public boolean getRendersChildren() {
        return true;
    }

    public int getComponentExtraWidth(FacesContext facesContext, UIComponent component) {
        return 0;
    }

    public int getLabelWidth(FacesContext facesContext, UIComponent component) {
        return this.getConfiguredValue(facesContext, component, "labelWidth");
    }

    public int getFixedHeight(FacesContext facesContext, UIComponent component) {
        int fixedHeight = -1;
        String height = (String)component.getAttributes().get("height");
        if (height != null) {
            try {
                fixedHeight = Integer.parseInt(LayoutUtil.stripNonNumericChars((String)height));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("Can't parse " + height + " to int"));
            }
        }
        if (fixedHeight == -1) {
            fixedHeight = super.getFixedHeight(facesContext, component);
        }
        return fixedHeight;
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        if (!(component instanceof UISelectMany)) {
            LOG.error((Object)("Wrong type: Need " + UISelectMany.class.getName() + ", but was " + component.getClass().getName()));
            return;
        }
        UISelectMany selectMany = (UISelectMany)component;
        List items = ComponentUtil.getSelectItems((UIComponent)selectMany);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("items.size() = '" + items.size() + "'"));
        }
        TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter((FacesContext)facesContext);
        String title = HtmlRendererUtil.getTitleFromTipAndMessages((FacesContext)facesContext, (UIComponent)selectMany);
        writer.startElement("select", (UIComponent)selectMany);
        String clientId = selectMany.getClientId(facesContext);
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(clientId);
        boolean renderDisabled = ComponentUtil.getBooleanAttribute((UIComponent)selectMany, (String)"disabled") || ComponentUtil.getBooleanAttribute((UIComponent)selectMany, (String)"readonly");
        writer.writeAttribute("disabled", renderDisabled);
        Integer tabIndex = selectMany.getTabIndex();
        if (tabIndex != null) {
            writer.writeAttribute("tabindex", tabIndex.intValue());
        }
        writer.writeStyleAttribute();
        writer.writeClassAttribute();
        writer.writeAttribute("multiple", "multiple", false);
        if (title != null) {
            writer.writeAttribute("title", title, true);
        }
        Object[] values = selectMany.getSelectedValues();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("values = '" + Arrays.toString(values) + "'"));
        }
        HtmlRendererUtil.renderSelectItems((UIInput)selectMany, (List)items, (Object[])values, (TobagoResponseWriter)writer, (FacesContext)facesContext);
        writer.endElement("select");
        this.checkForCommandFacet((UIComponent)selectMany, facesContext, writer);
        HtmlRendererUtil.renderFocusId((FacesContext)facesContext, (UIInput)selectMany);
    }
}

