/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UISelectBoolean;
import org.apache.myfaces.tobago.renderkit.LayoutableRendererBase;
import org.apache.myfaces.tobago.renderkit.RenderUtil;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SelectBooleanCheckboxRenderer
extends LayoutableRendererBase {
    private static final Log LOG = LogFactory.getLog(SelectBooleanCheckboxRenderer.class);

    public void decode(FacesContext facesContext, UIComponent component) {
        UIInput input = (UIInput)component;
        if (ComponentUtil.isOutputOnly((UIComponent)input)) {
            return;
        }
        String newValue = (String)facesContext.getExternalContext().getRequestParameterMap().get(input.getClientId(facesContext));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("new value = '" + newValue + "'"));
        }
        input.setSubmittedValue((Object)("true".equals(newValue) ? "true" : "false"));
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        String title;
        if (!(component instanceof UISelectBoolean)) {
            LOG.error((Object)("Wrong type: Need " + UISelectBoolean.class.getName() + ", but was " + component.getClass().getName()));
            return;
        }
        UISelectBoolean selectBoolean = (UISelectBoolean)component;
        TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter((FacesContext)facesContext);
        UIComponent label = ComponentUtil.provideLabel((FacesContext)facesContext, (UIComponent)selectBoolean);
        boolean inline = ComponentUtil.getBooleanAttribute((UIComponent)selectBoolean, (String)"inline");
        if (label != null && !inline) {
            writer.startElement("table", (UIComponent)selectBoolean);
            writer.writeAttribute("border", 0);
            writer.writeAttribute("cellspacing", 0);
            writer.writeAttribute("cellpadding", 0);
            writer.writeAttribute("summary", "", false);
            HtmlRendererUtil.renderTip((UIComponent)component, (TobagoResponseWriter)writer);
            writer.startElement("tr", null);
            writer.startElement("td", null);
        }
        String currentValue = this.getCurrentValue(facesContext, (UIComponent)selectBoolean);
        boolean checked = "true".equals(currentValue);
        writer.startElement("input", (UIComponent)selectBoolean);
        writer.writeAttribute("type", "checkbox", false);
        writer.writeAttribute("value", "true", false);
        writer.writeAttribute("checked", checked);
        if (ComponentUtil.getBooleanAttribute((UIComponent)selectBoolean, (String)"readonly")) {
            writer.writeAttribute("readonly", true);
            if (checked) {
                writer.writeAttribute("onclick", "this.checked=true", false);
            } else {
                writer.writeAttribute("onclick", "this.checked=false", false);
            }
        }
        writer.writeNameAttribute(selectBoolean.getClientId(facesContext));
        writer.writeClassAttribute();
        writer.writeIdAttribute(selectBoolean.getClientId(facesContext));
        writer.writeAttribute("disabled", ComponentUtil.getBooleanAttribute((UIComponent)selectBoolean, (String)"disabled"));
        Integer tabIndex = selectBoolean.getTabIndex();
        if (tabIndex != null) {
            writer.writeAttribute("tabindex", tabIndex.intValue());
        }
        if ((title = HtmlRendererUtil.getTitleFromTipAndMessages((FacesContext)facesContext, (UIComponent)selectBoolean)) != null) {
            writer.writeAttribute("title", title, true);
        }
        writer.endElement("input");
        if (label != null && !inline) {
            writer.endElement("td");
            writer.startElement("td", null);
            writer.flush();
        }
        if (label != null) {
            RenderUtil.encode((FacesContext)facesContext, (UIComponent)label);
        }
        if (label != null && !inline) {
            writer.endElement("td");
            writer.endElement("tr");
            writer.endElement("table");
        }
        this.checkForCommandFacet((UIComponent)selectBoolean, facesContext, writer);
    }
}

