/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.taglib.sandbox;

import java.util.List;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.webapp.FacetTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.model.Wizard;
import org.apache.myfaces.tobago.model.WizardStep;
import org.apache.myfaces.tobago.taglib.component.AttributeTag;
import org.apache.myfaces.tobago.taglib.component.ButtonTag;
import org.apache.myfaces.tobago.taglib.component.GridLayoutTag;
import org.apache.myfaces.tobago.taglib.component.OutTag;
import org.apache.myfaces.tobago.taglib.component.PanelTag;

public class WizardTrainTag
extends BodyTagSupport {
    private static final Log LOG = LogFactory.getLog(WizardTrainTag.class);
    private String controller;
    private String wizard;

    public int doStartTag() throws JspException {
        int result = super.doStartTag();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        Wizard wizardObject = (Wizard)application.createValueBinding(this.controller).getValue(facesContext);
        List<WizardStep> course = wizardObject.getCourse();
        PanelTag panel = new PanelTag();
        panel.setPageContext(this.pageContext);
        panel.setParent(this.getParent());
        panel.doStartTag();
        FacetTag facetTag = new FacetTag();
        facetTag.setPageContext(this.pageContext);
        facetTag.setName("layout");
        facetTag.setParent((Tag)panel);
        facetTag.doStartTag();
        GridLayoutTag gridLayoutTag = new GridLayoutTag();
        gridLayoutTag.setPageContext(this.pageContext);
        StringBuilder columns = new StringBuilder();
        for (WizardStep info : course) {
            columns.append("fixed;");
        }
        gridLayoutTag.setColumns(columns + "*");
        gridLayoutTag.setParent((Tag)facetTag);
        gridLayoutTag.doStartTag();
        gridLayoutTag.doEndTag();
        facetTag.doEndTag();
        for (WizardStep info : course) {
            ButtonTag button = new ButtonTag();
            button.setPageContext(this.pageContext);
            button.setParent((Tag)panel);
            button.setAction(info.getOutcome());
            button.setActionListener("#{" + this.wizard + ".gotoStep}");
            button.setLabel(info.getTitle());
            button.doStartTag();
            AttributeTag step = new AttributeTag();
            step.setPageContext(this.pageContext);
            step.setParent((Tag)button);
            step.setName("step");
            step.setValue("" + info.getIndex());
            step.doStartTag();
            step.doEndTag();
            button.doEndTag();
        }
        OutTag spacer = new OutTag();
        spacer.setPageContext(this.pageContext);
        spacer.setParent((Tag)panel);
        spacer.setValue("#{" + this.wizard + ".index}");
        spacer.doStartTag();
        spacer.doEndTag();
        panel.doEndTag();
        return result;
    }

    public void release() {
        super.release();
        this.controller = null;
        this.wizard = null;
    }

    public void setWizard(String wizard) {
        this.wizard = wizard;
    }

    public void setController(String controller) {
        this.controller = controller;
    }
}

