/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.sandbox.standard.tag;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.config.ThemeConfig;
import org.apache.myfaces.tobago.context.ResourceManager;
import org.apache.myfaces.tobago.context.ResourceManagerFactory;
import org.apache.myfaces.tobago.renderkit.LayoutableRendererBase;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.renderkit.html.HtmlStyleMap;
import org.apache.myfaces.tobago.renderkit.html.StyleClasses;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class InputNumberSliderRenderer
extends LayoutableRendererBase {
    private static final String SLIDER_WIDTH_PERCENT = "sliderWidthPercent";

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        String[] scripts = new String[]{"script/scriptaculous.js"};
        ComponentUtil.addScripts((UIComponent)component, (String[])scripts);
        String id = component.getClientId(facesContext);
        String currentValue = this.getCurrentValue(facesContext, component);
        boolean readonly = ComponentUtil.getBooleanAttribute((UIComponent)component, (String)"readonly");
        boolean disabled = ComponentUtil.getBooleanAttribute((UIComponent)component, (String)"disabled");
        Integer min = ComponentUtil.getIntAttribute((UIComponent)component, (String)"min");
        Integer max = ComponentUtil.getIntAttribute((UIComponent)component, (String)"max");
        TobagoResponseWriter writer = HtmlRendererUtil.getTobagoResponseWriter((FacesContext)facesContext);
        HtmlStyleMap style = (HtmlStyleMap)component.getAttributes().get("style");
        int width = -1;
        int sliderWidthPerc = 33;
        if (ThemeConfig.hasValue((FacesContext)facesContext, (UIComponent)component, (String)SLIDER_WIDTH_PERCENT)) {
            sliderWidthPerc = ThemeConfig.getValue((FacesContext)facesContext, (UIComponent)component, (String)SLIDER_WIDTH_PERCENT);
            if (sliderWidthPerc <= 25) {
                sliderWidthPerc = 25;
            }
            if (sliderWidthPerc >= 75) {
                sliderWidthPerc = 75;
            }
        }
        int sliderWidth = 100;
        int inputWidth = 50;
        if (style != null && style.containsKey((Object)"width")) {
            width = style.getInt((Object)"width");
        }
        if (width >= 0) {
            sliderWidth = width * sliderWidthPerc / 100;
            inputWidth = width * (100 - sliderWidthPerc) / 100;
        }
        writer.startElement("table", component);
        writer.writeIdAttribute(id);
        writer.writeClassAttribute();
        writer.writeStyleAttribute();
        StyleClasses styleClasses = new StyleClasses();
        styleClasses.addAspectClass("inputNumberSlider", "min", StyleClasses.Aspect.DEFAULT);
        writer.startElement("tr", null);
        writer.startElement("td", null);
        writer.writeClassAttribute(styleClasses);
        HtmlStyleMap widthStyle = new HtmlStyleMap();
        widthStyle.put("width", (Object)(sliderWidth / 2));
        writer.writeStyleAttribute(widthStyle);
        writer.startElement("span", null);
        writer.writeClassAttribute(styleClasses);
        writer.write(Integer.toString(min));
        writer.endElement("span");
        styleClasses = new StyleClasses();
        styleClasses.addAspectClass("inputNumberSlider", "max", StyleClasses.Aspect.DEFAULT);
        writer.endElement("td");
        writer.startElement("td", null);
        writer.writeClassAttribute(styleClasses);
        writer.writeStyleAttribute(widthStyle);
        writer.startElement("span", null);
        writer.writeClassAttribute(styleClasses);
        writer.write(Integer.toString(max));
        writer.endElement("span");
        writer.endElement("td");
        writer.startElement("td", null);
        writer.writeAttribute("rowspan", "2", false);
        writer.writeClassAttribute("tobago-inputNumberSlider-input-default");
        writer.startElement("input", null);
        writer.writeClassAttribute("tobago-in-default");
        widthStyle.put("width", (Object)inputWidth);
        writer.writeStyleAttribute(widthStyle);
        String inputIdAndName = this.getIdForInputField(facesContext, component);
        writer.writeNameAttribute(inputIdAndName);
        writer.writeIdAttribute(inputIdAndName);
        if (currentValue != null) {
            writer.writeAttribute("value", currentValue, false);
        }
        writer.writeAttribute("readonly", readonly);
        writer.writeAttribute("disabled", disabled);
        writer.endElement("input");
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", null);
        writer.startElement("td", null);
        writer.writeAttribute("colspan", 2);
        writer.startElement("div", null);
        writer.writeClassAttribute("tobago-inputNumberSlider-slider-default");
        writer.writeIdAttribute(this.getIdForSliderTrack(facesContext, component));
        writer.startElement("div", null);
        writer.writeIdAttribute(this.getIdForSliderHandle(facesContext, component));
        writer.writeStyleAttribute("position:relative; top:-6px; width:12px; height:6px");
        writer.startElement("img", null);
        writer.writeAttribute("src", this.getAbsoluteImagePath(facesContext, "image/sliderTriangle.gif"), true);
        writer.endElement("img");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        this.writeSliderJavaScript(facesContext, component, writer);
    }

    public void decode(FacesContext context, UIComponent component) {
        if (!(component instanceof UIInput) || ComponentUtil.isOutputOnly((UIComponent)component)) {
            return;
        }
        UIInput uiInput = (UIInput)component;
        String inputId = this.getIdForInputField(context, component);
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        if (requestParameterMap.containsKey(inputId)) {
            String newValue = (String)requestParameterMap.get(inputId);
            uiInput.setSubmittedValue((Object)newValue);
        }
    }

    private String getAbsoluteImagePath(FacesContext facesContext, String relativeImagePath) {
        ResourceManager resourceManager = ResourceManagerFactory.getResourceManager((FacesContext)facesContext);
        UIViewRoot viewRoot = facesContext.getViewRoot();
        String contextPath = facesContext.getExternalContext().getRequestContextPath();
        return contextPath + resourceManager.getImage(viewRoot, relativeImagePath);
    }

    private String getIdForInputField(FacesContext context, UIComponent component) {
        String id = component.getClientId(context);
        return id + "::" + "input";
    }

    private String getIdForSliderTrack(FacesContext context, UIComponent component) {
        String id = component.getClientId(context);
        return id + "::" + "track";
    }

    private String getIdForSliderHandle(FacesContext context, UIComponent component) {
        String id = component.getClientId(context);
        return id + "::" + "handle";
    }

    private void writeSliderJavaScript(FacesContext context, UIComponent component, TobagoResponseWriter writer) throws IOException {
        String trackId = this.getIdForSliderTrack(context, component);
        String handleId = this.getIdForSliderHandle(context, component);
        String inputId = this.getIdForInputField(context, component);
        String jsId = component.getClientId(context).replace(':', '_');
        Integer min = ComponentUtil.getIntAttribute((UIComponent)component, (String)"min");
        Integer max = ComponentUtil.getIntAttribute((UIComponent)component, (String)"max");
        String script = "    var slider_" + jsId + " = new Control.Slider('" + handleId + "', '" + trackId + "', {\n" + "        sliderValue:$('" + inputId + "').value,\n" + "        range : $R(" + min + ", " + max + "),\n" + "        values: $R(" + min + ", " + max + ").toArray(),\n" + "        onSlide:function(v) {\n" + "            $('" + inputId + "').value = v;\n" + "        },\n" + "        onChange:function(v) {\n" + "            $('" + inputId + "').value = v;\n" + "        }\n" + "    });\n" + "\n" + "    Event.observe('value', 'change', function() {\n" + "        slider_" + jsId + ".setValue($('" + inputId + "').value);\n" + "    });\n";
        writer.writeJavascript(script);
    }
}

