/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.UITreeData;
import org.apache.myfaces.tobago.component.UITreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MixedTreeModel {
    private static final Log LOG = LogFactory.getLog(MixedTreeModel.class);
    private DefaultMutableTreeNode root;
    private DefaultMutableTreeNode current;
    private Integer nextChildIndex;
    private DefaultMutableTreeNode dataRoot;
    private boolean isInData;
    private Stack<Boolean> junctions = new Stack();

    public void beginBuildNode(UITreeNode node) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(node.getAttributes().get("label"));
        }
        if (!this.isInData) {
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(node.getAttributes().get("label"));
            if (this.root == null) {
                this.current = this.root = newNode;
            } else {
                this.current.add(newNode);
                this.current = newNode;
            }
        }
    }

    public void endBuildNode(UITreeNode node) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(node.getAttributes().get("label"));
        }
        if (!this.isInData) {
            this.current = (DefaultMutableTreeNode)this.current.getParent();
        }
    }

    public void beginBuildNodeData(UITreeData data) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("var=" + data.getVar()));
        }
        this.current = new DefaultMutableTreeNode(data.getValue());
        if (this.root == null) {
            this.root = this.current;
        } else {
            this.root.add(this.current);
        }
        this.isInData = true;
    }

    public void endBuildNodeData(UITreeData data) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("var=" + data.getVar()));
        }
        this.current = (DefaultMutableTreeNode)this.current.getParent();
        this.isInData = false;
    }

    public void onEncodeBegin() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("current=" + this.current));
        }
        this.current = this.current == null ? this.root : (DefaultMutableTreeNode)this.current.getChildAt(this.nextChildIndex);
        if (!this.isInData && this.current.getUserObject() instanceof DefaultMutableTreeNode) {
            this.isInData = true;
            this.dataRoot = this.current;
            this.current = (DefaultMutableTreeNode)this.current.getUserObject();
        }
        this.nextChildIndex = 0;
        this.junctions.push(this.hasCurrentNodeNextSibling());
    }

    public void onEncodeEnd() {
        DefaultMutableTreeNode parent;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("current=" + this.current));
        }
        if (this.isInData && this.current.isRoot()) {
            this.current = this.dataRoot;
            this.isInData = false;
        }
        if ((parent = (DefaultMutableTreeNode)this.current.getParent()) != null) {
            this.nextChildIndex = parent.getIndex(this.current) + 1;
            this.current = parent;
        } else {
            this.nextChildIndex = null;
            this.current = null;
        }
        this.junctions.pop();
    }

    public boolean hasCurrentNodeNextSibling() {
        boolean result = this.isInData && this.current.isRoot() ? this.dataRoot.getNextSibling() != null : this.current.getNextSibling() != null;
        return result;
    }

    public boolean isFolder() {
        boolean folder = this.current.getChildCount() > 0;
        return folder;
    }

    public int getDepth() {
        int depth = this.junctions.size();
        return depth;
    }

    public boolean isRoot() {
        return this.junctions.size() < 2;
    }

    public List<Boolean> getJunctions() {
        Boolean top = this.junctions.pop();
        ArrayList<Boolean> result = new ArrayList<Boolean>(this.junctions);
        this.junctions.push(top);
        return result;
    }
}

