/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.component;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.SupportsMarkup;
import org.apache.myfaces.tobago.component.TreeModelBuilder;
import org.apache.myfaces.tobago.component.UICommand;
import org.apache.myfaces.tobago.component.UITree;
import org.apache.myfaces.tobago.model.MixedTreeModel;

public class UITreeNode
extends UICommand
implements SupportsMarkup,
TreeModelBuilder {
    private static final Log LOG = LogFactory.getLog(UITreeNode.class);
    public static final String COMPONENT_TYPE = "org.apache.myfaces.tobago.TreeNode";
    private String[] markup;
    private Boolean marked;
    private static final boolean DEFAULT_MARKED = false;
    private Boolean expanded;
    private static final boolean DEFAULT_EXPANDED = false;

    public String[] getMarkup() {
        if (this.markup != null) {
            return this.markup;
        }
        return ComponentUtil.getMarkupBinding((FacesContext)this.getFacesContext(), (SupportsMarkup)this);
    }

    public void setMarkup(String[] markup) {
        this.markup = markup;
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void buildBegin(MixedTreeModel model) {
        model.beginBuildNode(this);
    }

    public void buildChildren(MixedTreeModel model) {
        for (Object child : this.getChildren()) {
            if (!(child instanceof TreeModelBuilder)) continue;
            TreeModelBuilder builder = (TreeModelBuilder)child;
            builder.buildBegin(model);
            builder.buildChildren(model);
            builder.buildEnd(model);
        }
    }

    public void buildEnd(MixedTreeModel model) {
        model.endBuildNode(this);
    }

    public Object getValue() {
        DefaultMutableTreeNode value = (DefaultMutableTreeNode)super.getValue();
        if (value == null) {
            value = new DefaultMutableTreeNode();
            value.setUserObject(System.identityHashCode(value));
            this.setValue(value);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Created temporary Node: " + value.getUserObject()));
            }
        }
        return value;
    }

    public String nodeStateId(FacesContext facesContext) {
        String clientId = this.getClientId(facesContext);
        UITree tree = this.findTree((UIComponent)this);
        String treeId = tree.getClientId(facesContext);
        return clientId.substring(treeId.length() + 1);
    }

    public UITree findTree() {
        return this.findTree((UIComponent)this);
    }

    private UITree findTree(UIComponent component) {
        while (component != null) {
            if (component instanceof UITree) {
                return (UITree)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.markup = (String[])values[1];
        this.marked = (Boolean)values[2];
        this.expanded = (Boolean)values[3];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.markup, this.marked, this.expanded};
        return values;
    }

    public void setMarked(boolean marked) {
        this.marked = marked;
    }

    public boolean isMarked() {
        if (this.marked != null) {
            return this.marked;
        }
        ValueBinding valueBinding = this.getValueBinding("marked");
        Boolean value = valueBinding != null ? (Boolean)valueBinding.getValue(this.getFacesContext()) : null;
        return value != null ? value : false;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public boolean isExpanded() {
        if (this.expanded != null) {
            return this.expanded;
        }
        ValueBinding valueBinding = this.getValueBinding("expanded");
        Boolean value = valueBinding != null ? (Boolean)valueBinding.getValue(this.getFacesContext()) : null;
        return value != null ? value : false;
    }
}

