/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.application;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.application.FopConverter;
import org.apache.myfaces.tobago.application.ViewHandlerImpl;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.context.ClientProperties;
import org.apache.myfaces.tobago.webapp.TobagoResponse;

public class FoViewHandlerImpl
extends ViewHandlerImpl {
    private static final Log LOG = LogFactory.getLog(FoViewHandlerImpl.class);

    public FoViewHandlerImpl(ViewHandler base) {
        super(base);
    }

    public void renderView(FacesContext facesContext, UIViewRoot viewRoot) throws IOException, FacesException {
        String requestUri = viewRoot.getViewId();
        String contentType = ClientProperties.getInstance((UIViewRoot)viewRoot).getContentType();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("contentType = '" + contentType + "'"));
        }
        if (contentType.indexOf("fo") == -1) {
            super.renderView(facesContext, viewRoot);
        } else {
            try {
                if (facesContext.getExternalContext().getResponse() instanceof TobagoResponse) {
                    ((TobagoResponse)facesContext.getExternalContext().getResponse()).setBuffering();
                    HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
                    HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
                    RequestDispatcher requestDispatcher = request.getRequestDispatcher(requestUri);
                    requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
                    response.setContentType("application/pdf");
                    String buffer = ((TobagoResponse)facesContext.getExternalContext().getResponse()).getBufferedString();
                    ServletResponse servletResponse = (ServletResponse)facesContext.getExternalContext().getResponse();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("fo buffer: " + buffer));
                    }
                    FopConverter.fo2Pdf(servletResponse, buffer);
                }
            }
            catch (ServletException e) {
                IOException ex = new IOException();
                ex.initCause(e);
                throw ex;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"VIEW");
            LOG.debug((Object)ComponentUtil.toString((UIComponent)facesContext.getViewRoot(), (int)0));
        }
    }
}

