/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.util;

import java.io.IOException;
import java.io.Writer;
import org.apache.myfaces.tobago.util.ResponseWriterBuffer;

public final class HtmlWriterUtil {
    private static final char[][] CHARS_TO_ESCAPE = new char[160][];
    private final Writer out;
    private final ResponseWriterBuffer buffer;
    private final boolean utf8;
    private static final char[][] ISO8859_1_ENTITIES;

    public HtmlWriterUtil(Writer out, String characterEncoding) {
        this.out = out;
        this.utf8 = "utf-8".equalsIgnoreCase(characterEncoding);
        this.buffer = new ResponseWriterBuffer(out);
    }

    public void writeAttributeValue(String text) throws IOException {
        this.writeEncodedValue(text.toCharArray(), 0, text.length(), true);
    }

    public void writeText(String text) throws IOException {
        this.writeEncodedValue(text.toCharArray(), 0, text.length(), false);
    }

    public void writeText(char[] text, int start, int length) throws IOException {
        this.writeEncodedValue(text, start, length, false);
    }

    private void writeEncodedValue(char[] text, int start, int length, boolean isAttribute) throws IOException {
        char ch;
        int i;
        int localIndex = -1;
        int end = start + length;
        for (i = start; i < end; ++i) {
            ch = text[i];
            if (ch < CHARS_TO_ESCAPE.length && CHARS_TO_ESCAPE[ch] == null) continue;
            localIndex = i;
            break;
        }
        if (localIndex == -1) {
            this.out.write(text, start, length);
        } else {
            this.out.write(text, start, localIndex);
            for (i = localIndex; i < end; ++i) {
                ch = text[i];
                if (ch < CHARS_TO_ESCAPE.length) {
                    if (isAttribute && ch == '&' && i + 1 < end && text[i + 1] == '{') {
                        this.buffer.addToBuffer('&');
                        continue;
                    }
                    if (CHARS_TO_ESCAPE[ch] != null) {
                        this.buffer.addToBuffer(CHARS_TO_ESCAPE[ch]);
                        continue;
                    }
                    this.buffer.addToBuffer(ch);
                    continue;
                }
                if (this.utf8) {
                    this.buffer.addToBuffer(ch);
                    continue;
                }
                if (ch <= '\u00ff') {
                    this.buffer.flushBuffer();
                    this.out.write(38);
                    char[] chars = ISO8859_1_ENTITIES[ch - 160];
                    this.out.write(chars, 0, chars.length);
                    this.out.write(59);
                    continue;
                }
                this.buffer.flushBuffer();
                this.writeDecRef(ch);
            }
            this.buffer.flushBuffer();
        }
    }

    private void writeDecRef(char ch) throws IOException {
        if (ch == 8364) {
            this.out.write("&euro;");
            return;
        }
        this.out.write("&#");
        int i = ch;
        if (i > 10000) {
            this.out.write(48 + i / 10000);
            this.out.write(48 + (i %= 10000) / 1000);
            this.out.write(48 + (i %= 1000) / 100);
            this.out.write(48 + (i %= 100) / 10);
            this.out.write(48 + (i %= 10));
        } else if (i > 1000) {
            this.out.write(48 + i / 1000);
            this.out.write(48 + (i %= 1000) / 100);
            this.out.write(48 + (i %= 100) / 10);
            this.out.write(48 + (i %= 10));
        } else {
            this.out.write(48 + i / 100);
            this.out.write(48 + (i %= 100) / 10);
            this.out.write(48 + (i %= 10));
        }
        this.out.write(59);
    }

    public static boolean attributeValueMustEscaped(String name) {
        try {
            switch (name.charAt(0)) {
                case 'i': {
                    if (name.length() == 2 && name.charAt(1) == 'd') {
                        return false;
                    }
                    break;
                }
                case 'n': {
                    if (name.length() == 4 && name.charAt(1) == 'a' && name.charAt(2) == 'm' && name.charAt(3) == 'e') {
                        return false;
                    }
                    break;
                }
                case 'c': {
                    if (name.length() == 5 && name.charAt(1) == 'l' && name.charAt(2) == 'a' && name.charAt(3) == 's' && name.charAt(4) == 's') {
                        return false;
                    }
                    break;
                }
                default: {
                    return true;
                }
            }
        }
        catch (NullPointerException e) {
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        return true;
    }

    static {
        HtmlWriterUtil.CHARS_TO_ESCAPE[34] = "&quot;".toCharArray();
        HtmlWriterUtil.CHARS_TO_ESCAPE[38] = "&amp;".toCharArray();
        HtmlWriterUtil.CHARS_TO_ESCAPE[60] = "&lt;".toCharArray();
        HtmlWriterUtil.CHARS_TO_ESCAPE[62] = "&gt;".toCharArray();
        ISO8859_1_ENTITIES = new char[][]{"nbsp".toCharArray(), "iexcl".toCharArray(), "cent".toCharArray(), "pound".toCharArray(), "curren".toCharArray(), "yen".toCharArray(), "brvbar".toCharArray(), "sect".toCharArray(), "uml".toCharArray(), "copy".toCharArray(), "ordf".toCharArray(), "laquo".toCharArray(), "not".toCharArray(), "shy".toCharArray(), "reg".toCharArray(), "macr".toCharArray(), "deg".toCharArray(), "plusmn".toCharArray(), "sup2".toCharArray(), "sup3".toCharArray(), "acute".toCharArray(), "micro".toCharArray(), "para".toCharArray(), "middot".toCharArray(), "cedil".toCharArray(), "sup1".toCharArray(), "ordm".toCharArray(), "raquo".toCharArray(), "frac14".toCharArray(), "frac12".toCharArray(), "frac34".toCharArray(), "iquest".toCharArray(), "Agrave".toCharArray(), "Aacute".toCharArray(), "Acirc".toCharArray(), "Atilde".toCharArray(), "Auml".toCharArray(), "Aring".toCharArray(), "AElig".toCharArray(), "Ccedil".toCharArray(), "Egrave".toCharArray(), "Eacute".toCharArray(), "Ecirc".toCharArray(), "Euml".toCharArray(), "Igrave".toCharArray(), "Iacute".toCharArray(), "Icirc".toCharArray(), "Iuml".toCharArray(), "ETH".toCharArray(), "Ntilde".toCharArray(), "Ograve".toCharArray(), "Oacute".toCharArray(), "Ocirc".toCharArray(), "Otilde".toCharArray(), "Ouml".toCharArray(), "times".toCharArray(), "Oslash".toCharArray(), "Ugrave".toCharArray(), "Uacute".toCharArray(), "Ucirc".toCharArray(), "Uuml".toCharArray(), "Yacute".toCharArray(), "THORN".toCharArray(), "szlig".toCharArray(), "agrave".toCharArray(), "aacute".toCharArray(), "acirc".toCharArray(), "atilde".toCharArray(), "auml".toCharArray(), "aring".toCharArray(), "aelig".toCharArray(), "ccedil".toCharArray(), "egrave".toCharArray(), "eacute".toCharArray(), "ecirc".toCharArray(), "euml".toCharArray(), "igrave".toCharArray(), "iacute".toCharArray(), "icirc".toCharArray(), "iuml".toCharArray(), "eth".toCharArray(), "ntilde".toCharArray(), "ograve".toCharArray(), "oacute".toCharArray(), "ocirc".toCharArray(), "otilde".toCharArray(), "ouml".toCharArray(), "divide".toCharArray(), "oslash".toCharArray(), "ugrave".toCharArray(), "uacute".toCharArray(), "ucirc".toCharArray(), "uuml".toCharArray(), "yacute".toCharArray(), "thorn".toCharArray(), "yuml".toCharArray()};
    }
}

