/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.util;

import java.text.MessageFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DebugPhaseListener
implements PhaseListener {
    private static final Log LOG;
    private static final String KEY;
    static /* synthetic */ Class class$org$apache$myfaces$tobago$util$DebugPhaseListener;

    public void afterPhase(PhaseEvent phaseEvent) {
        if (LOG.isInfoEnabled()) {
            Date start;
            Date end = new Date();
            FacesContext facesContext = phaseEvent.getFacesContext();
            Map map = facesContext.getExternalContext().getRequestMap();
            map.put(KEY + phaseEvent.getPhaseId().getOrdinal() + "E", end);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("After Phase :" + phaseEvent.getPhaseId() + " Time=" + end.getTime()));
            }
            if (LOG.isDebugEnabled()) {
                start = (Date)map.get(KEY + phaseEvent.getPhaseId().getOrdinal() + "S");
                LOG.debug((Object)("Phase " + phaseEvent.getPhaseId() + " needs " + (end.getTime() - start.getTime()) + " milliseconds"));
            }
            if (phaseEvent.getPhaseId().getOrdinal() == 6) {
                if (LOG.isTraceEnabled()) {
                    HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
                    LOG.trace((Object)(" response Locale            = \"" + response.getLocale() + "\""));
                    LOG.trace((Object)(" response ContentType       = \"" + response.getContentType() + "\""));
                    LOG.trace((Object)(" response CharacterEncoding = \"{" + response.getCharacterEncoding() + "}\""));
                }
                if ((start = (Date)map.get(KEY + "1S")) != null) {
                    LOG.info((Object)("Total response time : " + (end.getTime() - start.getTime()) + " milliseconds"));
                }
            }
            Iterator iter = facesContext.getClientIdsWithMessages();
            while (iter.hasNext()) {
                String clientId = (String)iter.next();
                Iterator msgIter = facesContext.getMessages(clientId);
                while (msgIter.hasNext()) {
                    FacesMessage msg = (FacesMessage)msgIter.next();
                    LOG.info((Object)MessageFormat.format("Faces message found.\n  Component: {0} \n  Severity : {1}\n  Summary  : {2} \n  Detail   : {3}", clientId, msg.getSeverity(), msg.getSummary(), msg.getDetail()));
                }
            }
        }
    }

    public void beforePhase(PhaseEvent phaseEvent) {
        if (LOG.isInfoEnabled()) {
            Date start = null;
            Map map = null;
            PhaseId phaseId = phaseEvent.getPhaseId();
            if (LOG.isDebugEnabled() || phaseId.getOrdinal() == 1) {
                ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
                if (LOG.isTraceEnabled() && PhaseId.RESTORE_VIEW == phaseId) {
                    Object request = externalContext.getRequest();
                    if (request instanceof HttpServletRequest) {
                        HttpServletRequest servletRequest = (HttpServletRequest)request;
                        LOG.trace((Object)("RequestURI = " + servletRequest.getRequestURI()));
                    }
                    Map headerMap = externalContext.getRequestHeaderMap();
                    Iterator i$ = headerMap.keySet().iterator();
                    while (i$.hasNext()) {
                        Object key = i$.next();
                        LOG.trace((Object)("Header : \"" + key + "\" = \"" + headerMap.get(key) + "\""));
                    }
                    Map parameterMap = externalContext.getRequestParameterMap();
                    Iterator i$2 = parameterMap.keySet().iterator();
                    while (i$2.hasNext()) {
                        Object key = i$2.next();
                        LOG.trace((Object)("Param  : \"" + key + "\" = \"" + parameterMap.get(key) + "\""));
                    }
                }
                start = new Date();
                map = externalContext.getRequestMap();
                map.put(KEY + phaseId.getOrdinal() + "S", start);
            }
            if (LOG.isDebugEnabled()) {
                Date end = null;
                int ordinal = phaseId.getOrdinal();
                while (end == null && ordinal > 0) {
                    end = (Date)map.get(KEY + --ordinal + "E");
                }
                if (end != null) {
                    LOG.debug((Object)("Time between phases " + ordinal + " and " + phaseId.getOrdinal() + ": " + (start.getTime() - end.getTime()) + " milliseconds"));
                }
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Before Phase :" + phaseId + " Time=" + start.getTime()));
            }
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    static {
        Class<?> clazz = class$org$apache$myfaces$tobago$util$DebugPhaseListener;
        if (clazz == null) {
            clazz = class$org$apache$myfaces$tobago$util$DebugPhaseListener = new DebugPhaseListener[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
        StringBuffer stringBuffer = new StringBuffer();
        Class<?> clazz2 = class$org$apache$myfaces$tobago$util$DebugPhaseListener;
        if (clazz2 == null) {
            clazz2 = class$org$apache$myfaces$tobago$util$DebugPhaseListener = new DebugPhaseListener[0].getClass().getComponentType();
        }
        KEY = stringBuffer.append(clazz2.getName()).append("_ID_").toString();
    }
}

