/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import net.sf.retrotranslator.runtime.java.lang.Deprecated_;
import net.sf.retrotranslator.runtime.java.lang.Enum_;
import net.sf.retrotranslator.runtime.java.lang._Iterable;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.SupportsMarkup;
import org.apache.myfaces.tobago.context.ClientProperties;
import org.apache.myfaces.tobago.context.Theme;

public class StyleClasses
implements Serializable {
    private static final long serialVersionUID = 3738052927067803517L;
    private static final Log LOG;
    public static final char SEPERATOR = '-';
    public static final String PREFIX = "tobago-";
    public static final String MARKUP = "-markup-";
    private ListOrderedSet classes = new ListOrderedSet();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$apache$myfaces$tobago$renderkit$html$StyleClasses;

    public StyleClasses() {
    }

    private StyleClasses(StyleClasses base) {
        this();
        this.classes.addAll((Collection)base.classes);
    }

    public static StyleClasses ensureStyleClasses(UIComponent component) {
        Map attributes = component.getAttributes();
        StyleClasses classes = (StyleClasses)attributes.get("styleClass");
        if (classes == null) {
            classes = new StyleClasses();
            attributes.put("styleClass", classes);
        }
        return classes;
    }

    public static StyleClasses ensureStyleClassesCopy(UIComponent component) {
        return new StyleClasses(StyleClasses.ensureStyleClasses(component));
    }

    @Deprecated_
    public void addFullQualifiedClass(String clazz) {
        this.classes.add((Object)clazz);
    }

    @Deprecated_
    public void removeFullQualifiedClass(String clazz) {
        this.classes.remove((Object)clazz);
    }

    public void addClass(String renderer, String sub) {
        this.classes.add((Object)this.nameOfClass(renderer, sub));
    }

    public void removeClass(String renderer, String sub) {
        this.classes.remove((Object)this.nameOfClass(renderer, sub));
    }

    private String nameOfClass(String renderer, String sub) {
        StringBuffer builder = new StringBuffer(PREFIX);
        builder.append(renderer);
        builder.append('-');
        builder.append(sub);
        return builder.toString();
    }

    public void addMarkupClass(String renderer, String markup) {
        this.addMarkupClass(renderer, null, markup);
    }

    public void removeMarkupClass(String renderer, String markup) {
        this.removeMarkupClass(renderer, null, markup);
    }

    public void addMarkupClass(String renderer, String sub, String markup) {
        this.classes.add((Object)this.nameOfMarkupClass(renderer, sub, markup));
    }

    public void removeMarkupClass(String renderer, String sub, String markup) {
        this.classes.remove((Object)this.nameOfMarkupClass(renderer, sub, markup));
    }

    private String nameOfMarkupClass(String renderer, String sub, String markup) {
        StringBuffer builder = new StringBuffer(PREFIX);
        builder.append(renderer);
        if (sub != null) {
            builder.append('-');
            builder.append(sub);
        }
        builder.append(MARKUP);
        builder.append(markup);
        return builder.toString();
    }

    public void addMarkupClass(UIComponent component, String rendererName) {
        if (component instanceof SupportsMarkup) {
            this.addMarkupClass((SupportsMarkup)component, rendererName, null);
        }
    }

    public void addMarkupClass(SupportsMarkup supportsMarkup, String rendererName, String sub) {
        String[] arr$ = supportsMarkup.getMarkup();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String markup = arr$[i$];
            if (StringUtils.isBlank((String)markup)) continue;
            Theme theme = ClientProperties.getInstance(FacesContext.getCurrentInstance().getViewRoot()).getTheme();
            if (theme.getRenderersConfig().isMarkupSupported(rendererName, markup)) {
                this.addMarkupClass(rendererName, sub, markup);
                continue;
            }
            if ("none".equals(markup)) continue;
            LOG.warn((Object)("Ignoring unknown markup='" + markup + "' for rendererName='" + rendererName + "'"));
        }
    }

    public void addAspectClass(String renderer, Aspect aspect) {
        this.classes.add((Object)this.nameOfAspectClass(renderer, aspect));
    }

    public void removeAspectClass(String renderer, Aspect aspect) {
        this.classes.remove((Object)this.nameOfAspectClass(renderer, aspect));
    }

    private String nameOfAspectClass(String renderer, Aspect aspect) {
        StringBuffer builder = new StringBuffer(PREFIX);
        builder.append(renderer);
        builder.append((Object)aspect);
        return builder.toString();
    }

    public void addAspectClass(String renderer, String sub, Aspect aspect) {
        this.classes.add((Object)this.nameOfAspectClass(renderer, sub, aspect));
    }

    public void removeAspectClass(String renderer, String sub, Aspect aspect) {
        this.classes.remove((Object)this.nameOfAspectClass(renderer, sub, aspect));
    }

    private String nameOfAspectClass(String renderer, String sub, Aspect aspect) {
        StringBuffer builder = new StringBuffer(PREFIX);
        builder.append(renderer);
        builder.append('-');
        builder.append(sub);
        builder.append((Object)aspect);
        return builder.toString();
    }

    public void addClasses(StyleClasses styleClasses) {
        Iterator i$ = _Iterable.iterator((Object)styleClasses.classes);
        while (i$.hasNext()) {
            String clazz = (String)i$.next();
            this.classes.add((Object)clazz);
        }
    }

    public void removeClass(String clazz) {
        this.classes.remove((Object)clazz);
    }

    public void removeTobagoClasses(String rendererName) {
        Iterator i = this.classes.iterator();
        while (i.hasNext()) {
            String clazz = (String)i.next();
            if (!clazz.startsWith(PREFIX + rendererName)) continue;
            i.remove();
        }
    }

    public void updateClassAttributeAndMarkup(UIComponent component, String rendererName) {
        this.updateClassAttribute(component, rendererName);
        this.addMarkupClass(component, rendererName);
    }

    public void updateClassAttribute(UIComponent component, String rendererName) {
        UIInput input;
        FacesMessage.Severity severity;
        this.removeTobagoClasses(rendererName);
        this.addAspectClass(rendererName, Aspect.DEFAULT);
        if (ComponentUtil.getBooleanAttribute(component, "disabled")) {
            this.addAspectClass(rendererName, Aspect.DISABLED);
        }
        if (ComponentUtil.getBooleanAttribute(component, "readonly")) {
            this.addAspectClass(rendererName, Aspect.READONLY);
        }
        if (ComponentUtil.getBooleanAttribute(component, "inline")) {
            this.addAspectClass(rendererName, Aspect.INLINE);
        }
        if ((severity = ComponentUtil.getMaximumSeverity(component)) != null) {
            if (severity.equals(FacesMessage.SEVERITY_FATAL)) {
                this.addMarkupClass(rendererName, "fatal");
                this.addAspectClass(rendererName, Aspect.ERROR);
            } else if (severity.equals(FacesMessage.SEVERITY_ERROR)) {
                this.addMarkupClass(rendererName, "error");
                this.addAspectClass(rendererName, Aspect.ERROR);
            } else if (severity.equals(FacesMessage.SEVERITY_WARN)) {
                this.addMarkupClass(rendererName, "warn");
            } else if (severity.equals(FacesMessage.SEVERITY_INFO)) {
                this.addMarkupClass(rendererName, "info");
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Ordinal constants may be wrong");
            }
        }
        if (component instanceof UIInput && (input = (UIInput)component).isRequired()) {
            this.addAspectClass(rendererName, Aspect.REQUIRED);
        }
    }

    public boolean isEmpty() {
        return this.classes.isEmpty();
    }

    public String toString() {
        if (this.classes.isEmpty()) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(32);
        Iterator i = this.classes.iterator();
        while (i.hasNext()) {
            String clazz = (String)i.next();
            buffer.append(clazz);
            if (!i.hasNext()) continue;
            buffer.append(' ');
        }
        return buffer.toString();
    }

    static {
        Class<?> clazz = class$org$apache$myfaces$tobago$renderkit$html$StyleClasses;
        if (clazz == null) {
            clazz = class$org$apache$myfaces$tobago$renderkit$html$StyleClasses = new StyleClasses[0].getClass().getComponentType();
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$org$apache$myfaces$tobago$renderkit$html$StyleClasses;
        if (clazz2 == null) {
            clazz2 = class$org$apache$myfaces$tobago$renderkit$html$StyleClasses = new StyleClasses[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz2);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Aspect
    extends Enum_<Aspect> {
        public static final Aspect DEFAULT = new Aspect("DEFAULT", 0);
        public static final Aspect DISABLED = new Aspect("DISABLED", 1);
        public static final Aspect READONLY = new Aspect("READONLY", 2);
        public static final Aspect INLINE = new Aspect("INLINE", 3);
        public static final Aspect ERROR = new Aspect("ERROR", 4);
        public static final Aspect REQUIRED = new Aspect("REQUIRED", 5);
        private String aspect = new StringBuffer().append('-').append(this.name().toLowerCase(Locale.ENGLISH)).toString();
        private static final /* synthetic */ Aspect[] $VALUES;
        static /* synthetic */ Class class$org$apache$myfaces$tobago$renderkit$html$StyleClasses$Aspect;

        public static Aspect[] values() {
            return (Aspect[])$VALUES.clone();
        }

        public static Aspect valueOf(String name) {
            Class<?> clazz = class$org$apache$myfaces$tobago$renderkit$html$StyleClasses$Aspect;
            if (clazz == null) {
                clazz = class$org$apache$myfaces$tobago$renderkit$html$StyleClasses$Aspect = new Aspect[0].getClass().getComponentType();
            }
            return (Aspect)Enum_.valueOf((Class)clazz, (String)name);
        }

        private Aspect() {
            super((String)var1_1, n);
        }

        public String toString() {
            return this.aspect;
        }

        static {
            $VALUES = new Aspect[]{DEFAULT, DISABLED, READONLY, INLINE, ERROR, REQUIRED};
            Class<?> clazz = class$org$apache$myfaces$tobago$renderkit$html$StyleClasses$Aspect;
            if (clazz == null) {
                clazz = class$org$apache$myfaces$tobago$renderkit$html$StyleClasses$Aspect = new Aspect[0].getClass().getComponentType();
            }
            Enum_.setEnumConstants((Class)clazz, (Enum_[])Aspect.values());
        }
    }
}

