/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit;

import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UICell;
import org.apache.myfaces.tobago.component.UICommand;
import org.apache.myfaces.tobago.renderkit.LayoutInformationProvider;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.util.LayoutUtil;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LayoutableRendererBase
extends RendererBase
implements LayoutInformationProvider {
    @Override
    public int getHeaderHeight(FacesContext facesContext, UIComponent component) {
        int height = this.getConfiguredValue(facesContext, component, "headerHeight");
        UIComponent menubar = component.getFacet("menuBar");
        if (menubar != null) {
            height += this.getConfiguredValue(facesContext, menubar, "headerHeight");
        }
        return height;
    }

    @Override
    public int getPaddingWidth(FacesContext facesContext, UIComponent component) {
        return this.getConfiguredValue(facesContext, component, "paddingWidth");
    }

    @Override
    public int getPaddingHeight(FacesContext facesContext, UIComponent component) {
        return this.getConfiguredValue(facesContext, component, "paddingHeight");
    }

    @Override
    public int getComponentExtraWidth(FacesContext facesContext, UIComponent component) {
        return this.getConfiguredValue(facesContext, component, "componentExtraWidth");
    }

    @Override
    public int getComponentExtraHeight(FacesContext facesContext, UIComponent component) {
        return this.getConfiguredValue(facesContext, component, "componentExtraHeight");
    }

    @Override
    public Dimension getMinimumSize(FacesContext facesContext, UIComponent component) {
        int height;
        int width = this.getConfiguredValue(facesContext, component, "minimumWidth");
        if (width == -1) {
            width = this.getConfiguredValue(facesContext, component, "fixedWidth");
        }
        if ((height = this.getConfiguredValue(facesContext, component, "minimumHeight")) == -1) {
            height = this.getConfiguredValue(facesContext, component, "fixedHeight");
        }
        return new Dimension(width, height);
    }

    @Override
    public int getFixedWidth(FacesContext facesContext, UIComponent component) {
        return this.getFixedSpace(facesContext, component, true);
    }

    @Override
    public int getFixedHeight(FacesContext facesContext, UIComponent component) {
        return this.getFixedSpace(facesContext, component, false);
    }

    @Override
    public int getFixedSpace(FacesContext facesContext, UIComponent component, boolean width) {
        int fixedSpace = 0;
        if (component instanceof UICell) {
            List<UIComponent> children = LayoutUtil.addChildren(new ArrayList<UIComponent>(), component);
            for (UIComponent aChildren : children) {
                UIComponent child = aChildren;
                LayoutableRendererBase renderer = ComponentUtil.getRenderer(facesContext, child);
                if (renderer == null) continue;
                if (width) {
                    fixedSpace = Math.max(fixedSpace, renderer.getFixedWidth(facesContext, child));
                    continue;
                }
                fixedSpace = Math.max(fixedSpace, renderer.getFixedHeight(facesContext, child));
            }
        } else {
            fixedSpace = width ? this.getFixedSpace(facesContext, component, "width", "fixedWidth") : this.getFixedSpace(facesContext, component, "height", "fixedHeight");
        }
        return fixedSpace;
    }

    private int getFixedSpace(FacesContext facesContext, UIComponent component, String attr, String attrFixed) {
        int intSpace = -1;
        String space = null;
        if (component != null) {
            space = ComponentUtil.getStringAttribute(component, attr);
        }
        if (space != null) {
            try {
                intSpace = Integer.parseInt(LayoutUtil.stripNonNumericChars(space));
            }
            catch (NumberFormatException e) {
                LOG.error((Object)new StringBuffer().append("Caught: ").append(e.getMessage()).toString(), (Throwable)e);
            }
        }
        if (intSpace == -1) {
            return this.getConfiguredValue(facesContext, component, attrFixed);
        }
        return intSpace;
    }

    protected void checkForCommandFacet(UIComponent component, FacesContext facesContext, TobagoResponseWriter writer) throws IOException {
        this.checkForCommandFacet(component, Arrays.asList(component.getClientId(facesContext)), facesContext, writer);
    }

    protected void checkForCommandFacet(UIComponent component, List<String> clientIds, FacesContext facesContext, TobagoResponseWriter writer) throws IOException {
        if (ComponentUtil.getBooleanAttribute(component, "readonly") || ComponentUtil.getBooleanAttribute(component, "disabled")) {
            return;
        }
        Map facets = component.getFacets();
        for (Map.Entry<String, UIComponent> entry : facets.entrySet()) {
            if (!(entry.getValue() instanceof UICommand)) continue;
            this.addCommandFacet(clientIds, entry, facesContext, writer);
        }
    }

    private void addCommandFacet(List<String> clientIds, Map.Entry<String, UIComponent> facetEntry, FacesContext facesContext, TobagoResponseWriter writer) throws IOException {
        for (String clientId : clientIds) {
            this.writeScriptForClientId(clientId, facetEntry, facesContext, writer);
        }
    }

    private void writeScriptForClientId(String clientId, Map.Entry<String, UIComponent> facetEntry, FacesContext facesContext, TobagoResponseWriter writer) throws IOException {
        if (facetEntry.getValue() instanceof UICommand && ((UICommand)facetEntry.getValue()).getRenderedPartially().length > 0) {
            String script = new StringBuffer().append("var element = Tobago.element(\"").append(clientId).append("\");\n").append("if (element) {\n").append("   Tobago.addEventListener(element, \"").append(facetEntry.getKey()).append("\", function(){Tobago.reloadComponent2(this, '").append(HtmlRendererUtil.getComponentId(facesContext, facetEntry.getValue(), ((UICommand)facetEntry.getValue()).getRenderedPartially()[0])).append("','").append(facetEntry.getValue().getClientId(facesContext)).append("', {})});\n").append("}").toString();
            writer.writeJavascript(script);
        } else {
            UIComponent facetComponent = facetEntry.getValue();
            String facetAction = (String)facetComponent.getAttributes().get("onclick");
            facetAction = facetAction == null ? new StringBuffer().append("Tobago.submitAction2(this, '").append(facetComponent.getClientId(facesContext)).append("', ").append(ComponentUtil.getBooleanAttribute(facetComponent, "transition")).append(", null, '").append(clientId).append("')").toString() : StringUtils.replace((String)facetAction, (String)"@autoId", (String)facetComponent.getClientId(facesContext));
            String script = new StringBuffer().append("var element = Tobago.element(\"").append(clientId).append("\");\n").append("if (element) {\n").append("   Tobago.addEventListener(element, \"").append(facetEntry.getKey()).append("\", function(){").append(facetAction).append("});\n}").toString();
            writer.writeJavascript(script);
        }
    }
}

