/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.event;

import java.io.Serializable;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.webapp.UIComponentTag;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UIPopup;

public class PopupActionListener
implements ActionListener,
Serializable {
    private static final Log LOG;
    private String popupId;
    private ValueBinding popupIdBinding;
    private boolean facet;
    static /* synthetic */ Class class$org$apache$myfaces$tobago$event$PopupActionListener;

    public PopupActionListener() {
    }

    public PopupActionListener(String popupId) {
        if (UIComponentTag.isValueReference((String)popupId)) {
            this.popupIdBinding = ComponentUtil.createValueBinding(popupId);
        } else {
            this.popupId = popupId;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Add ActionListener: " + popupId));
        }
    }

    public PopupActionListener(UIPopup popup) {
        this.facet = true;
    }

    public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UIPopup popup = null;
        if (this.facet) {
            UIComponent component = actionEvent.getComponent().getFacet("popup");
            if (component instanceof UIPopup) {
                popup = (UIPopup)component;
            }
            if (popup == null) {
                LOG.error((Object)("Found no popup facet in component " + actionEvent.getComponent().getClientId(facesContext)));
            }
        } else {
            String id = this.popupIdBinding != null ? (String)this.popupIdBinding.getValue(facesContext) : this.popupId;
            popup = (UIPopup)ComponentUtil.findComponent(actionEvent.getComponent(), id);
            if (popup == null) {
                LOG.error((Object)("Found no popup for \"" + (this.popupIdBinding != null ? this.popupIdBinding.getExpressionString() + "\" := \"" : "") + id + "\"! Search base componentId : " + actionEvent.getComponent().getClientId(facesContext)));
            }
        }
        if (popup != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("activated " + actionEvent.getComponent().getClientId(facesContext)));
            }
            popup.setActivated(true);
        }
    }

    static {
        Class<?> clazz = class$org$apache$myfaces$tobago$event$PopupActionListener;
        if (clazz == null) {
            clazz = class$org$apache$myfaces$tobago$event$PopupActionListener = new PopupActionListener[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
    }
}

